/*
 * Decompiled with CFR 0.152.
 */
package auto.anim.outlay;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public final class Cell {
    int dx = 0;
    int dy = 0;
    int idx = 0;
    int idy = 0;
    int wr = 0;
    int hr = 0;
    public int w = 0;
    public int h = 0;
    public String text;
    String fName = "Dialog";
    int fSize = 0;
    int fStyle = 0;
    Font ft = null;
    FontMetrics fmt = null;
    public Cell foot = null;
    public Cell head = null;
    public Cell right = null;
    public Cell down = null;
    public boolean downLine = false;

    public Cell() {
    }

    public Cell(String string) {
        this.text = string;
    }

    void centerCalc() {
        this.idy = (this.h - this.hr) / 2;
        this.idx = (this.w - this.wr) / 2;
        if (this.right != null) {
            this.right.centerCalc();
            this.right.dx += this.idx;
        }
        if (this.down != null) {
            this.down.centerCalc();
            this.down.dy += this.idy;
        }
        if (this.foot != null) {
            this.foot.centerCalc();
            this.foot.dx += this.idx;
            this.foot.dy += this.idy;
        }
        if (this.head != null) {
            this.head.centerCalc();
            this.head.dx += this.idx;
            this.head.dy += this.idy;
        }
    }

    void calc(int n, int n2, int n3, Graphics graphics) {
        int n4;
        int n5;
        int n6 = this.fSize + n3;
        this.dx = n;
        this.dy = n2;
        this.ft = new Font(this.fName, this.fStyle, n6);
        this.fmt = graphics.getFontMetrics(this.ft);
        int n7 = this.fmt.stringWidth(this.text);
        int n8 = this.fmt.getHeight();
        int n9 = 0;
        int n10 = n7;
        int n11 = n8;
        int n12 = n8;
        int n13 = n7;
        if (this.foot != null) {
            n5 = n7;
            n4 = 3 * n8 / 4;
            this.foot.calc(n5, n4, 2 * n3 / 3, graphics);
            n10 = n13 = Math.max(n10, n5 + this.foot.w);
            n11 = n12 = Math.max(n11, n4 + this.foot.h);
        }
        if (this.head != null) {
            n5 = n7;
            n4 = -n8 / 4;
            n9 = Math.min(n9, n4);
            this.head.calc(n5, n4, 2 * n3 / 3, graphics);
            n10 = n13 = Math.max(n10, n7 + this.head.w);
        }
        if (this.right != null) {
            n5 = n10;
            n4 = n9;
            this.right.calc(n5, n4, n3, graphics);
            n10 = n13 = Math.max(n10, n5 + this.right.w);
            n11 = Math.max(n11, n4 + this.right.h);
        }
        if (this.down != null) {
            n5 = 0;
            n4 = n11;
            this.down.calc(n5, n4, n3, graphics);
            n10 = Math.max(n10, n5 + this.down.w);
            n11 = n12 = Math.max(n11, n4 + this.down.h);
        }
        this.w = n10;
        this.wr = n13;
        this.dy += -n9;
        this.h = n11 - n9;
        this.hr = n12 - n9;
    }

    void draw(int n, int n2, Graphics graphics, int n3) {
        graphics.setFont(this.ft);
        graphics.drawString(this.text, n + this.dx + this.idx, n2 + this.dy + this.idy + this.fmt.getAscent());
        if (this.downLine) {
            graphics.drawLine(n + this.dx, n2 + this.dy + this.down.dy, n + this.dx + this.w, n2 + this.dy + this.down.dy);
        }
        ++n3;
        if (this.foot != null) {
            this.foot.draw(n + this.dx, n2 + this.dy, graphics, n3);
        }
        if (this.head != null) {
            this.head.draw(n + this.dx, n2 + this.dy, graphics, n3);
        }
        if (this.right != null) {
            this.right.draw(n + this.dx, n2 + this.dy, graphics, n3);
        }
        if (this.down != null) {
            this.down.draw(n + this.dx, n2 + this.dy, graphics, n3);
        }
    }
}

