/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.ExtButton;
import auto.awt.HotKey;
import auto.awt.KeyManager;
import auto.awt.Utils;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ColorDialog
extends Dialog
implements AdjustmentListener,
ActionListener {
    Color color;
    Color oldColor;
    ColorCanvas colorCanvas;
    ColorSelect colorSelect;
    Label lr;
    Label lg;
    Label lb;
    Scrollbar sr;
    Scrollbar sg;
    Scrollbar sb;

    public static Color process(Frame frame, Color color) {
        ColorDialog colorDialog = new ColorDialog(frame, color);
        colorDialog.show();
        return colorDialog.color;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("cancel")) {
            this.color = this.oldColor;
        }
        this.setVisible(false);
        this.dispose();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.setColor(new Color(this.sr.getValue(), this.sg.getValue(), this.sb.getValue()));
    }

    Color calcColor(int n, int n2, int n3, int n4) {
        int n5 = (n < n3 ? 255 - n * 255 / n3 : 0) + (n / n3 == 2 ? (n - n3 - n3) * 255 / n3 : 0);
        int n6 = (n < n3 ? n * 255 / n3 : 0) + (n / n3 == 1 ? 255 - (n - n3) * 255 / n3 : 0);
        int n7 = (n / n3 == 1 ? (n - n3) * 255 / n3 : 0) + (n / n3 == 2 ? 255 - (n - n3 - n3) * 255 / n3 : 0);
        int n8 = n5 > n6 ? n5 : n6;
        int n9 = n8 = n8 > n7 ? n8 : n7;
        if (n8 > 0) {
            n5 = n5 * 255 / n8;
            n6 = n6 * 255 / n8;
            n7 = n7 * 255 / n8;
        }
        n5 = n2 < n4 ? (n4 - n2) * 255 / n4 + n2 * n5 / n4 : (n4 + n4 - n2) * n5 / n4;
        n6 = n2 < n4 ? (n4 - n2) * 255 / n4 + n2 * n6 / n4 : (n4 + n4 - n2) * n6 / n4;
        n7 = n2 < n4 ? (n4 - n2) * 255 / n4 + n2 * n7 / n4 : (n4 + n4 - n2) * n7 / n4;
        return new Color(n5, n6, n7);
    }

    public ColorDialog(Frame frame, Color color) {
        super(frame, "ColorDialog", true);
        this.oldColor = color;
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ColorDialog.this.color = ColorDialog.this.oldColor;
                ColorDialog.this.setVisible(false);
                ColorDialog.this.dispose();
            }
        };
        this.addWindowListener(windowAdapter);
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        ExtButton extButton = new ExtButton("&Ok", "images/ok.gif", "ok");
        panel.add(extButton);
        extButton.addActionListener(this);
        extButton.setHotKey(new HotKey(extButton.getHotKey().toString() + " ENTER"));
        extButton = new ExtButton("&Cancel", "images/cancel.gif", "cancel");
        panel.add(extButton);
        extButton.addActionListener(this);
        extButton.setHotKey(new HotKey(extButton.getHotKey().toString() + " ESC"));
        this.add((Component)panel, "South");
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout());
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(3, 2));
        this.lr = new Label("Red:         ");
        panel3.add(this.lr);
        Panel panel4 = new Panel();
        this.sr = new Scrollbar(0, 0, 1, 0, 255);
        panel4.add(this.sr);
        panel3.add(panel4);
        this.lg = new Label("Green:        ");
        panel3.add(this.lg);
        panel4 = new Panel();
        this.sg = new Scrollbar(0, 0, 1, 0, 255);
        panel4.add(this.sg);
        panel3.add(panel4);
        this.lb = new Label("Blue:         ");
        panel3.add(this.lb);
        panel4 = new Panel();
        this.sb = new Scrollbar(0, 0, 1, 0, 255);
        panel4.add(this.sb);
        panel3.add(panel4);
        Panel panel5 = new Panel();
        panel5.add(panel3);
        panel2.add((Component)panel5, "East");
        this.colorCanvas = new ColorCanvas();
        panel2.add((Component)this.colorCanvas, "Center");
        this.add((Component)panel2, "North");
        this.colorSelect = new ColorSelect();
        this.add((Component)this.colorSelect, "Center");
        this.pack();
        this.setColor(color == null ? Color.gray : color);
        Dimension dimension = Utils.defaultToolkit.getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
        this.sr.addAdjustmentListener(this);
        this.sg.addAdjustmentListener(this);
        this.sb.addAdjustmentListener(this);
        new KeyManager(this);
        this.colorSelect.setCursor(new Cursor(1));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ColorDialog.this.setColor(ColorDialog.this.calcColor(mouseEvent.getX() / 4, mouseEvent.getY() / 4, (ColorDialog.this.colorSelect.getSize().width / 4 + 1) / 3, (ColorDialog.this.colorSelect.getSize().height / 4 + 1) / 2));
            }
        };
        MouseMotionAdapter mouseMotionAdapter = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                int n;
                int n2 = mouseEvent.getX();
                if (n2 >= 0 & (n = mouseEvent.getY()) >= 0 & n2 < ColorDialog.this.colorSelect.getSize().width & n < ColorDialog.this.colorSelect.getSize().height) {
                    ColorDialog.this.setColor(ColorDialog.this.calcColor(mouseEvent.getX() / 4, mouseEvent.getY() / 4, (ColorDialog.this.colorSelect.getSize().width / 4 + 1) / 3, (ColorDialog.this.colorSelect.getSize().height / 4 + 1) / 2));
                }
            }
        };
        this.colorSelect.addMouseListener(mouseAdapter);
        this.colorSelect.addMouseMotionListener(mouseMotionAdapter);
    }

    void setColor(Color color) {
        this.color = color;
        this.colorCanvas.repaint();
        this.lr.setText("Red: " + this.color.getRed());
        this.lg.setText("Green: " + this.color.getGreen());
        this.lb.setText("Blue: " + this.color.getBlue());
        this.sr.setValue(this.color.getRed());
        this.sg.setValue(this.color.getGreen());
        this.sb.setValue(this.color.getBlue());
    }

    class ColorSelect
    extends Canvas {
        ColorSelect() {
        }

        public Dimension getPreferredSize() {
            return new Dimension(30, 30);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void paint(Graphics graphics) {
            Point point = new Point(this.getSize().width - 1, this.getSize().height - 1);
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(0, 0, point.x, 0);
            graphics.drawLine(0, 0, 0, point.y);
            graphics.setColor(this.getBackground().brighter());
            graphics.drawLine(point.x, 0, point.x, point.y);
            graphics.drawLine(0, point.y, point.x, point.y);
            graphics.setClip(1, 1, point.x - 1, point.y - 1);
            int n = point.x / 4 + 1;
            int n2 = point.y / 4 + 1;
            int n3 = n / 3;
            int n4 = n2 / 2;
            int n5 = 0;
            while (n5 < n2) {
                int n6 = 0;
                while (n6 < n) {
                    graphics.setColor(ColorDialog.this.calcColor(n6, n5, n3, n4));
                    graphics.fillRect(n6 * 4, n5 * 4, 4, 4);
                    ++n6;
                }
                ++n5;
            }
        }
    }

    class ColorCanvas
    extends Canvas {
        ColorCanvas() {
        }

        public Dimension getPreferredSize() {
            return new Dimension(80, 80);
        }

        public void paint(Graphics graphics) {
            Point point = new Point(this.getSize().width - 1, this.getSize().height - 1);
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(0, 0, point.x, 0);
            graphics.drawLine(0, 0, 0, point.y);
            graphics.setColor(this.getBackground().brighter());
            graphics.drawLine(point.x, 0, point.x, point.y);
            graphics.drawLine(0, point.y, point.x, point.y);
            graphics.setColor(ColorDialog.this.color == null ? this.getBackground() : ColorDialog.this.color);
            graphics.fillRect(1, 1, point.x - 1, point.y - 1);
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }
}

