/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;

public class ComponentWatch
implements ContainerListener {
    public ComponentWatch(Component component) {
        this.register(component);
    }

    void register(Component component) {
        this.registerListeners(component);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this);
            int n = 0;
            while (n < container.getComponentCount()) {
                this.register(container.getComponent(n));
                ++n;
            }
        }
    }

    public void registerListeners(Component component) {
    }

    public void deregisterListeners(Component component) {
    }

    public void deregister(Component component) {
        this.deregisterListeners(component);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            int n = 0;
            while (n < container.getComponentCount()) {
                this.deregister(container.getComponent(n));
                ++n;
            }
        }
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.register(containerEvent.getChild());
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.deregister(containerEvent.getChild());
    }
}

