/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.Utils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;

public class ControlPanel
extends Panel {
    public static final int NORM_PANEL = 0;
    public static final int CONTROL_PANEL = 1;
    public static final int THIN_PANEL = 2;
    public static final int BOTTOMRIGHT_PANEL = 3;
    public static final int PUSHED_PANEL = 4;
    public static final int CHOICE_PANEL = 5;
    int typ = 1;
    public Dimension fixSize = new Dimension(-1, -1);

    public ControlPanel(Component component) {
        this(component, 1);
    }

    public ControlPanel(int n) {
        this(null, n);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (this.fixSize.width != -1) {
            dimension.width = this.fixSize.width;
        }
        if (this.fixSize.height != -1) {
            dimension.height = this.fixSize.height;
        }
        return dimension;
    }

    public ControlPanel(Component component, int n) {
        this.typ = n;
        this.setLayout(new BorderLayout());
        if (component != null) {
            this.add(component, "Center");
        }
    }

    public Insets getInsets() {
        switch (this.typ) {
            case 3: {
                return new Insets(3, 3, 2, 2);
            }
            case 2: 
            case 4: {
                return new Insets(2, 2, 2, 2);
            }
            case 5: {
                return new Insets(0, 1, 1, 1);
            }
        }
        return new Insets(5, 5, 5, 5);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        switch (this.typ) {
            case 3: {
                Utils.draw3DRect(graphics, new Rectangle(1, 1, this.getSize().width - 1, this.getSize().height - 1), this.getBackground(), false);
                graphics.setColor(Color.black);
                graphics.drawLine(0, 0, this.getSize().width, 0);
                graphics.drawLine(0, 0, 0, this.getSize().height);
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                Utils.draw3DRect(graphics, new Rectangle(0, 0, this.getSize().width, this.getSize().height), this.getBackground(), false);
                break;
            }
            case 4: {
                Utils.draw3DRect(graphics, new Rectangle(0, 0, this.getSize().width, this.getSize().height), this.getBackground(), true);
                break;
            }
            default: {
                super.paint(graphics);
            }
        }
    }
}

