/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.DiaAble;
import auto.awt.HotKey;
import auto.awt.ImageManager;
import auto.awt.StringInterpreter;
import auto.awt.Utils;
import auto.awt.menu.ExtMenuBar;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class ExtButton
extends Canvas
implements Runnable,
FocusListener,
KeyListener,
DiaAble {
    String text = "";
    String filename = "";
    boolean mouseInside = false;
    boolean down = false;
    boolean stayingdown = false;
    ActionListener actionListener = null;
    boolean hasFocus = false;
    Image img = null;
    int underlinedKey = -1;
    HotKey hotkey = null;
    String actionCommand = "";
    boolean selected = false;
    public boolean staydown = false;
    boolean tabAble = true;
    int specialTyp = 0;
    final int UP = 1;
    final int DOWN = 2;
    final int COLOR = 3;
    static final int DOUBLE_UP = 4;
    static final int DOUBLE_DOWN = 5;
    Color color = Color.red;
    boolean isMenuButton = false;
    String menu = "";
    boolean wasPushed = false;
    final int IMAGE_LEFT = 0;
    final int IMAGE_RIGHT = 1;
    final int IMAGE_UP = 2;
    final int IMAGE_DOWN = 3;
    int iDist = 0;
    boolean ignoreDoubleClick = false;
    int fontsize = 100;
    int imageAlign = 0;
    MouseAdapter mlis;

    public void run() {
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.wasPushed = false;
    }

    public String getValue() {
        return this.down ? "1" : "0";
    }

    public void requestFocus() {
        if (this.tabAble) {
            super.requestFocus();
        }
    }

    public void setValue(String string) {
        if (this.staydown) {
            if (string.equals("1")) {
                this.down = true;
                this.stayingdown = true;
            } else {
                this.down = false;
                this.stayingdown = false;
            }
        }
        this.repaint();
    }

    public void setOptions(String string) {
        StringInterpreter stringInterpreter = new StringInterpreter(string, true, true);
        if (stringInterpreter.isVariable("ignoredoubleclick")) {
            this.ignoreDoubleClick = true;
        }
        if (stringInterpreter.isVariable("staydown")) {
            this.staydown = true;
        }
        if (stringInterpreter.isVariable("fontsize")) {
            this.fontsize = Integer.parseInt(stringInterpreter.getVariableValue("fontsize"));
        }
        if (stringInterpreter.isVariable("up")) {
            this.specialTyp = 1;
        }
        if (stringInterpreter.isVariable("down")) {
            this.specialTyp = 2;
        }
        if (stringInterpreter.isVariable("doubleup")) {
            this.specialTyp = 4;
        }
        if (stringInterpreter.isVariable("doubledown")) {
            this.specialTyp = 5;
        }
        if (stringInterpreter.isVariable("color")) {
            this.specialTyp = 3;
        }
        if (stringInterpreter.isVariable("menu")) {
            this.isMenuButton = true;
        }
        if (stringInterpreter.isVariable("align")) {
            String string2 = stringInterpreter.getVariableValue("align").toLowerCase();
            if (string2.equals("up")) {
                this.imageAlign = 2;
            }
            if (string2.equals("left")) {
                this.imageAlign = 0;
            }
            if (string2.equals("right")) {
                this.imageAlign = 1;
            }
            if (string2.equals("down")) {
                this.imageAlign = 3;
            }
        }
        if (stringInterpreter.isVariable("dist")) {
            this.iDist = Integer.parseInt(stringInterpreter.getVariableValue("dist"));
        }
        this.repaint();
    }

    public String getCaption() {
        return this.getText();
    }

    public void setCaption(String string) {
        this.setText(string);
    }

    public String getOptions() {
        String string = "";
        if (this.ignoreDoubleClick) {
            string = string + ";ignoredoubleclick";
        }
        if (this.staydown) {
            string = string + ";staydown";
        }
        if (this.fontsize != 100) {
            string = string + ";fontsize=" + this.fontsize;
        }
        if (this.isMenuButton) {
            string = string + ";menu";
        }
        switch (this.imageAlign) {
            case 2: {
                string = string + ";align=up";
                break;
            }
            case 3: {
                string = string + ";align=down";
                break;
            }
            case 1: {
                string = string + ";align=right";
            }
        }
        if (this.iDist != 0) {
            string = string + ";dist=" + this.iDist;
        }
        if (string.length() > 0) {
            string = string.substring(1);
        }
        return string;
    }

    public void setSelect(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    public String getOwnMenu() {
        return this.menu;
    }

    public void reactOnHotKey() {
        this.push();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setHotKey(HotKey hotKey) {
        this.hotkey = hotKey;
    }

    public HotKey getHotKey() {
        return this.hotkey;
    }

    void push() {
        if (this.wasPushed) {
            return;
        }
        this.wasPushed = true;
        new Thread((Runnable)this){

            public String toString() {
                return "ExtButton.thread";
            }
        }.start();
        if (this.staydown) {
            this.down = this.stayingdown = !this.stayingdown;
            this.repaint();
        }
        if (this.isMenuButton) {
            ExtMenuBar extMenuBar = new ExtMenuBar(true);
            extMenuBar.setStructure(this.menu);
            extMenuBar.showPopup(this, this.getSize().width, 0);
        }
        this.processEvent(new ActionEvent(this, 0, this.actionCommand));
    }

    public ExtButton(int n) {
        this("", null, "", null);
        this.specialTyp = n;
    }

    public ExtButton(String string) {
        this(string, null, string, null);
    }

    public ExtButton(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public ExtButton(String string, String string2, String string3, String string4) {
        this.actionCommand = string3;
        this.setText(string);
        this.setBackground(SystemColor.control);
        this.setImage(string2);
        if (string4 != null) {
            this.setOptions(string4);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.mlis = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                ExtButton.this.mouseInside = true;
                ExtButton.this.repaint();
            }

            public void mouseExited(MouseEvent mouseEvent) {
                ExtButton.this.mouseInside = false;
                ExtButton.this.repaint();
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) > 0) {
                    return;
                }
                ExtButton.this.down = true;
                ExtButton.this.requestFocus();
                ExtButton.this.repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 4) > 0) {
                    return;
                }
                if (!ExtButton.this.down) {
                    return;
                }
                ExtButton.this.down = false;
                ExtButton.this.repaint();
                if (ExtButton.this.ignoreDoubleClick && mouseEvent.getClickCount() > 1) {
                    return;
                }
                if (new Rectangle(0, 0, ExtButton.this.getSize().width, ExtButton.this.getSize().height).contains(mouseEvent.getPoint())) {
                    ExtButton.this.push();
                }
            }
        };
        this.addMouseListener(this.mlis);
        this.addKeyListener(this);
        this.addFocusListener(this);
    }

    public void removeNotify() {
        this.removeMouseListener(this.mlis);
        this.mlis = null;
        this.removeKeyListener(this);
        this.removeFocusListener(this);
        super.removeNotify();
    }

    public void setImage(String string) {
        if (string != null) {
            this.filename = string;
            this.img = ImageManager.getImage(string, this);
        } else {
            this.img = null;
            this.filename = "";
        }
        this.repaint();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: 
            case 32: {
                this.down = true;
                this.repaint();
                break;
            }
            case 39: {
                keyEvent.setKeyCode(9);
                this.processEvent(keyEvent);
                break;
            }
            case 37: {
                keyEvent.setKeyCode(9);
                keyEvent.setModifiers(1);
                this.processEvent(keyEvent);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: 
            case 32: {
                if (!this.down) break;
                this.down = false;
                this.repaint();
                this.push();
            }
        }
        if (Character.isLetter(keyEvent.getKeyChar()) & !keyEvent.isAltDown()) {
            keyEvent.setModifiers(8);
            this.processEvent(keyEvent);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        if (!this.stayingdown) {
            this.down = false;
        }
        this.repaint();
    }

    public String getText() {
        if (this.underlinedKey != -1) {
            return this.text.substring(0, this.underlinedKey) + "&" + this.text.substring(this.underlinedKey);
        }
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
        this.underlinedKey = this.text.indexOf(38);
        if (this.underlinedKey != -1) {
            this.text = this.text.substring(0, this.underlinedKey) + this.text.substring(this.underlinedKey + 1);
            this.setHotKey(new HotKey("alt;" + this.text.substring(this.underlinedKey, this.underlinedKey + 1).toLowerCase()));
        }
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed((ActionEvent)aWTEvent);
            }
            return;
        }
        super.processEvent(aWTEvent);
    }

    int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    public Dimension getPreferredSize() {
        if (this.getFont() == null) {
            return null;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Dimension dimension = null;
        switch (this.imageAlign) {
            case 0: 
            case 1: {
                dimension = new Dimension(this.iDist + fontMetrics.stringWidth(this.text) + (this.img != null ? this.img.getWidth(this) : 0) + 10, this.max(fontMetrics.getHeight(), this.img != null ? this.img.getHeight(this) : 0) + 6);
                break;
            }
            case 2: 
            case 3: {
                dimension = new Dimension(this.max(fontMetrics.stringWidth(this.text), this.img != null ? this.img.getWidth(this) : 0) + 10, this.iDist + fontMetrics.getHeight() + (this.img != null ? this.img.getHeight(this) : 0) + 6);
            }
        }
        return dimension;
    }

    public void paint(Graphics graphics) {
        Point point;
        block28: {
            int n;
            block27: {
                Color color = this.getBackground();
                if (this.mouseInside) {
                    color = color.brighter();
                }
                point = new Point(this.getSize().width - 1, this.getSize().height - 1);
                Point point2 = new Point(point.x / 2, point.y / 2);
                if (!this.down) {
                    graphics.setColor(color.brighter());
                    graphics.drawLine(0, 0, point.x, 0);
                    graphics.drawLine(0, 1, 0, point.y);
                    graphics.setColor(Color.black);
                    graphics.drawLine(point.x, 0, point.x, point.y);
                    graphics.drawLine(0, point.y, point.x, point.y);
                    graphics.setColor(color.darker());
                    graphics.drawLine(point.x - 1, 1, point.x - 1, point.y - 1);
                    graphics.drawLine(1, point.y - 1, point.x - 1, point.y - 1);
                    graphics.setColor(color);
                    graphics.fillRect(1, 1, point.x - 2, point.y - 2);
                    graphics.setColor(this.getForeground());
                } else {
                    graphics.setColor(color.brighter());
                    graphics.drawLine(point.x, 0, point.x, point.y);
                    graphics.drawLine(0, point.y, point.x, point.y);
                    graphics.setColor(Color.black);
                    graphics.drawLine(0, 0, point.x, 0);
                    graphics.drawLine(0, 1, 0, point.y);
                    graphics.setColor(color.darker());
                    graphics.drawLine(1, 1, point.x - 1, 1);
                    graphics.drawLine(1, 2, 1, point.y - 1);
                    graphics.setColor(color);
                    graphics.fillRect(2, 2, point.x - 2, point.y - 2);
                    graphics.setColor(this.getForeground());
                }
                int n2 = n = this.down ? 1 : 0;
                if (this.specialTyp == 0) break block27;
                switch (this.specialTyp) {
                    case 2: {
                        graphics.setColor(Color.black);
                        int n3 = 0;
                        while (n3 < 4) {
                            graphics.drawLine(point2.x - n3 + n, point2.y + 2 - n3 + n, point2.x + n3 + 1 + n, point2.y + 2 - n3 + n);
                            ++n3;
                        }
                        break block28;
                    }
                    case 5: {
                        graphics.setColor(Color.black);
                        int n4 = 0;
                        while (n4 < 3) {
                            graphics.drawLine(point2.x - n4 + n - 1, point2.y + 0 - n4 + n, point2.x + n4 + n, point2.y + 0 - n4 + n);
                            graphics.drawLine(point2.x - n4 + n - 1, point2.y + 4 - n4 + n, point2.x + n4 + n, point2.y + 4 - n4 + n);
                            ++n4;
                        }
                        break block28;
                    }
                    case 1: {
                        graphics.setColor(Color.black);
                        int n5 = 0;
                        while (n5 < 4) {
                            graphics.drawLine(point2.x - n5 + n, point2.y - 2 + n5 + n, point2.x + n5 + 1 + n, point2.y - 2 + n5 + n);
                            ++n5;
                        }
                        break block28;
                    }
                    case 4: {
                        graphics.setColor(Color.black);
                        int n6 = 0;
                        while (n6 < 3) {
                            graphics.drawLine(point2.x - n6 + n - 1, point2.y - 4 + n6 + n, point2.x + n6 + n, point2.y - 4 + n6 + n);
                            graphics.drawLine(point2.x - n6 + n - 1, point2.y - 0 + n6 + n, point2.x + n6 + n, point2.y - 0 + n6 + n);
                            ++n6;
                        }
                        break block28;
                    }
                    case 3: {
                        graphics.setColor(Color.black);
                        graphics.drawRect(5 + n, 5 + n, point.x - 10, point.y - 10);
                        graphics.setColor(this.color);
                        graphics.fillRect(6 + n, 6 + n, point.x - 11, point.y - 11);
                    }
                }
                break block28;
            }
            if (this.fontsize != 100) {
                graphics.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), this.getFont().getSize() * this.fontsize / 100));
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n7 = fontMetrics.stringWidth(this.text);
            int n8 = fontMetrics.getHeight();
            int n9 = 0;
            int n10 = 0;
            n9 = point.x / 2 - n7 / 2 + n;
            n10 = point.y / 2 - n8 / 2 + n;
            if (this.img != null) {
                switch (this.imageAlign) {
                    case 0: {
                        n9 = n9 - this.img.getWidth(this) / 2 - this.iDist / 2;
                        graphics.drawImage(this.img, n9, point.y / 2 - this.img.getHeight(this) / 2 + n, this);
                        n9 += this.img.getWidth(this) + this.iDist;
                        break;
                    }
                    case 1: {
                        n9 = n9 - this.img.getWidth(this) / 2 - this.iDist / 2;
                        graphics.drawImage(this.img, n9 + n7 + this.iDist, point.y / 2 - this.img.getHeight(this) / 2 + n, this);
                        break;
                    }
                    case 2: {
                        n10 = n10 - this.img.getHeight(this) / 2 - this.iDist / 2;
                        graphics.drawImage(this.img, point.x / 2 - this.img.getWidth(this) / 2 + n, n10, this);
                        n10 += this.img.getHeight(this) + this.iDist;
                        break;
                    }
                    case 3: {
                        n10 = n10 - this.img.getHeight(this) / 2 - this.iDist / 2;
                        graphics.drawImage(this.img, point.x / 2 - this.img.getWidth(this) / 2 + n, n10 + n8 + this.iDist, this);
                    }
                }
            }
            n10 += fontMetrics.getAscent();
            if (this.isEnabled()) {
                graphics.drawString(this.text, n9, n10);
                if (this.underlinedKey != -1) {
                    graphics.drawLine(n9 + fontMetrics.stringWidth(this.text.substring(0, this.underlinedKey)), n10 + 1, n9 + fontMetrics.stringWidth(this.text.substring(0, this.underlinedKey + 1)), n10 + 1);
                }
            } else {
                graphics.setColor(this.getBackground().brighter());
                graphics.drawString(this.text, n9 + 1, n10 + 1);
                graphics.setColor(this.getBackground().darker());
                graphics.drawString(this.text, n9, n10);
            }
        }
        if (this.hasFocus) {
            graphics.setColor(Color.black);
            Utils.drawZebraRect(graphics, 3, 3, point.x - 6, point.y - 6);
        }
        if (this.selected) {
            Utils.drawSelectMarks(this, graphics);
        }
    }
}

