/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.ExtTextField;
import auto.awt.HotKey;
import auto.awt.KeyManagerAble;
import auto.awt.Utils;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class ExtComboBox
extends Panel
implements KeyManagerAble,
ActionListener,
ComponentListener,
FocusListener,
WindowListener,
KeyListener {
    ExtTextField textField = null;
    LButton button = null;
    Window window = null;
    List list = null;
    boolean listFocus = false;
    String oldText = "";
    ActionListener actionListener = null;
    boolean hasFocus = false;
    Vector ret = new Vector(10, 10);
    String fast = "";

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void reactOnHotKey() {
        this.requestFocus();
    }

    public void setHotKey(HotKey hotKey) {
    }

    public HotKey getHotKey() {
        return null;
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this) {
            if (this.textField.isEnabled()) {
                this.textField.requestFocus();
            } else {
                this.button.requestFocus();
            }
            return;
        }
        if (focusEvent.getSource() == this.list) {
            this.listFocus = true;
        } else {
            this.oldText = this.textField.getText();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getSource() == this.list) {
            this.listFocus = false;
        } else {
            if (this.textField.isEnabled() & !this.textField.getText().equals(this.oldText)) {
                this.processEvent(new ActionEvent(this, 0, this.textField.getText()));
            }
            new CheckThread().start();
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed((ActionEvent)aWTEvent);
            }
            return;
        }
        super.processEvent(aWTEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: 
            case 32: {
                this.closeWindow();
                this.actionPerformed(null);
                break;
            }
            case 27: {
                this.closeWindow();
                break;
            }
            default: {
                if (Character.isLetter(keyEvent.getKeyChar())) {
                    boolean bl;
                    this.fast = this.fast + Character.toLowerCase(keyEvent.getKeyChar());
                    do {
                        bl = false;
                        int n = 0;
                        while (n < this.list.getItemCount()) {
                            if (this.list.getItem(n).toLowerCase().startsWith(this.fast)) {
                                this.list.select(n);
                                bl = true;
                                break;
                            }
                            ++n;
                        }
                        if (bl) continue;
                        this.fast = this.fast.substring(0, this.fast.length() - 1);
                    } while (!bl & this.fast.length() > 0);
                    break;
                }
                this.fast = "";
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.closeWindow();
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.closeWindow();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
        new CheckThread().start();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.closeWindow();
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.closeWindow();
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.closeWindow();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.closeWindow();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.closeWindow();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.closeWindow();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.closeWindow();
    }

    void closeWindow() {
        if (this.window == null) {
            return;
        }
        this.button.down = false;
        this.button.repaint();
        if (!this.window.isVisible()) {
            return;
        }
        ((Component)this.window).setVisible(false);
        Container container = this.getParent();
        while (!(container instanceof Window) & container != null) {
            container = container.getParent();
        }
        if (container != null) {
            ((Window)container).removeWindowListener(this);
            container.removeComponentListener(this);
        }
        this.window.dispose();
        this.window = null;
        this.button.requestFocus();
    }

    void openWindow() {
        Point point = this.getLocationOnScreen();
        Point point2 = new Point(this.getSize().width, this.getSize().height);
        this.window = new Window(Utils.getParentFrame(this));
        this.window.setLayout(new BorderLayout());
        this.list.setFont(this.textField.getFont());
        this.window.add((Component)this.list, "Center");
        ((Component)this.window).setLocation(point.x, point.y + point2.y);
        ((Component)this.window).setSize(100, 200);
        Utils.checkWindowOnScreen(this.window, true);
        if (this.window.getSize().width < point2.x) {
            ((Component)this.window).setSize(point2.x, this.window.getSize().height);
        }
        Container container = this.getParent();
        while (!(container instanceof Window) & container != null) {
            container = container.getParent();
        }
        if (container != null) {
            ((Window)container).addWindowListener(this);
            container.addComponentListener(this);
        }
        ((Component)this.window).setVisible(true);
        if (Utils.javaPc) {
            this.window.toFront();
        }
        this.list.requestFocus();
    }

    void focusChanged() {
        if (this.hasFocus) {
            this.textField.selectAll();
        } else {
            this.textField.select(0, 0);
        }
    }

    public void setComboFunction(boolean bl) {
        this.textField.setEnabled(bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.textField.setText(this.list.getItem(this.getSelectedIndex()));
        this.closeWindow();
        this.textField.requestFocus();
        String string = this.textField.getText();
        if (!this.textField.isEnabled() & this.ret.size() > 0) {
            string = (String)this.ret.elementAt(this.getSelectedIndex());
        }
        this.processEvent(new ActionEvent(this, 0, string));
    }

    public int getItemCount() {
        return this.list.getItemCount();
    }

    public String getItem(int n) {
        return this.list.getItem(n);
    }

    public int getItemNr(String string) {
        int n = this.getItemCount() - 1;
        while (n >= 0) {
            if (this.getItem(n).equals(string)) {
                return n;
            }
            --n;
        }
        return -1;
    }

    public void removeAll() {
        this.list.removeAll();
        this.ret.setSize(0);
    }

    public void addItem(String string, String string2) {
        this.addItem(string);
        if (string2 == null | string2.length() == 0) {
            string2 = Utils.str(this.getItemCount(), 4);
        }
        this.ret.addElement(string2);
    }

    public void addItem(String string) {
        this.list.addItem(string);
        if (this.textField.getText().length() == 0) {
            this.list.select(0);
            this.textField.setText(string);
        }
    }

    public int getSelectedIndex() {
        int n = this.list.getSelectedIndex();
        return n;
    }

    public void setText(String string) {
        this.textField.setText(string);
    }

    public String getText() {
        return this.textField.getText();
    }

    public void select(int n) {
        if (n < 0 | n > this.list.getItemCount() - 1) {
            return;
        }
        this.list.select(n);
        this.textField.setText(this.list.getItem(this.list.getSelectedIndex()));
    }

    public ExtComboBox(String string, boolean bl) {
        this(string);
        this.setComboFunction(bl);
    }

    public ExtComboBox(String string) {
        this.setLayout(new BorderLayout());
        this.textField = new ExtTextField(string);
        this.add((Component)this.textField, "Center");
        this.button = new LButton();
        this.add((Component)this.button, "East");
        this.list = new List();
        this.list.setBackground(SystemColor.window);
        this.list.addActionListener(this);
        this.list.addFocusListener(this);
        this.list.addKeyListener(this);
        this.textField.addFocusListener(this);
        this.addFocusListener(this);
    }

    public String toString() {
        return "choice";
    }

    public static void main(String[] stringArray) {
        Panel panel = new Panel();
        ExtComboBox extComboBox = new ExtComboBox("Test");
        panel.add(extComboBox);
        extComboBox.addItem("eins");
        extComboBox.addItem("zwei");
        extComboBox.addItem("drei");
        extComboBox.addItem("eins");
        extComboBox.addItem("zwei");
        extComboBox.addItem("drei");
        extComboBox.addItem("eins");
        extComboBox.addItem("zwei");
        extComboBox.addItem("drei");
        extComboBox.addItem("eins");
        extComboBox.addItem("zwei");
        extComboBox.addItem("drei");
        extComboBox.setComboFunction(false);
        panel.add(new ExtComboBox("zwwwwwa"));
        Utils.mainFrame(panel);
    }

    class CheckThread
    extends Thread {
        CheckThread() {
        }

        public void run() {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!ExtComboBox.this.listFocus) {
                ExtComboBox.this.closeWindow();
            }
        }

        public String toString() {
            return "ExtComboBox.CheckThread";
        }
    }

    class LButton
    extends Canvas
    implements MouseListener,
    FocusListener,
    KeyListener {
        boolean down = false;

        public void focusGained(FocusEvent focusEvent) {
            ExtComboBox.this.hasFocus = true;
            this.repaint();
            ExtComboBox.this.focusChanged();
        }

        public void focusLost(FocusEvent focusEvent) {
            ExtComboBox.this.hasFocus = false;
            this.repaint();
            ExtComboBox.this.focusChanged();
        }

        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 37: 
                case 38: {
                    int n = ExtComboBox.this.getSelectedIndex();
                    if (n <= 0) break;
                    ExtComboBox.this.select(n - 1);
                    ExtComboBox.this.processEvent(new ActionEvent(ExtComboBox.this, 0, ExtComboBox.this.getItem(ExtComboBox.this.getSelectedIndex())));
                    break;
                }
                case 39: 
                case 40: {
                    int n = ExtComboBox.this.getSelectedIndex();
                    if (n >= ExtComboBox.this.getItemCount() - 1) break;
                    ExtComboBox.this.select(n + 1);
                    ExtComboBox.this.processEvent(new ActionEvent(ExtComboBox.this, 0, ExtComboBox.this.getItem(ExtComboBox.this.getSelectedIndex())));
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 10: 
                case 32: {
                    this.down = !this.down;
                    this.repaint();
                    ExtComboBox.this.openWindow();
                }
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.down) {
                this.down = !this.down;
                this.repaint();
                ExtComboBox.this.openWindow();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public Dimension getPreferredSize() {
            return new Dimension(15, 0);
        }

        public void paint(Graphics graphics) {
            Point point = new Point(this.getSize().width - 1, this.getSize().height - 1);
            Point point2 = new Point(point.x / 2, point.y / 2);
            graphics.setColor(this.getBackground());
            Utils.draw3DRect(graphics, new Rectangle(0, 0, point.x, point.y), this.getBackground(), this.down);
            graphics.setColor(Color.black);
            int n = this.down ? 0 : -1;
            int n2 = 0;
            while (n2 < 3) {
                graphics.drawLine(point2.x - n2 + n, point2.y + 1 - n2 + n, point2.x + n2 + 1 + n, point2.y + 1 - n2 + n);
                ++n2;
            }
            if (ExtComboBox.this.hasFocus) {
                graphics.setColor(Color.black);
                Utils.drawZebraRect(graphics, 3 + n, 3 + n, point.x - 5, point.y - 5);
            }
        }

        LButton() {
            this.addFocusListener(this);
            this.addMouseListener(this);
            this.addKeyListener(this);
            this.setBackground(SystemColor.control);
            this.setCursor(new Cursor(0));
        }
    }
}

