/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.ExtScrollPane;
import auto.awt.ScrollGraphicsAble;
import auto.awt.Utils;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class ExtGrid
extends Container
implements ScrollGraphicsAble,
FocusListener,
KeyListener,
MouseListener,
MouseMotionListener,
Runnable {
    public Vector cols = new Vector();
    public int datax = 0;
    public int colWidth = 200;
    boolean hasFocus = false;
    boolean normCursor = true;
    boolean actionOnClick = false;
    boolean actionOnSpace = false;
    public Point cursor = new Point(0, 0);
    ActionListener actionListener;
    public boolean drawHeader = false;
    public boolean dataSync = true;
    public boolean changeCols = false;
    public int changeColRange = 5;
    public int changeColI = -1;
    public int changeWidth;
    public boolean colChanging = false;
    private boolean isOn = false;
    private boolean gotData = false;
    public boolean indexed = false;
    public int[] index = new int[100];
    Cursor defaultCursor = new Cursor(0);
    Cursor changeColCursor = new Cursor(10);
    public Point graphicsLoc = new Point(0, 0);
    public boolean catchFocus = true;
    ExtScrollPane parentSP = null;

    public void toggleCursor(boolean bl) {
    }

    public void setGraphicsLocation(int n, int n2) {
        this.graphicsLoc.x = n;
        this.graphicsLoc.y = n2;
        this.repaint();
    }

    public Point getGraphicsLocation() {
        return this.graphicsLoc;
    }

    public Component withScrollPane() {
        ExtScrollPane extScrollPane = new ExtScrollPane();
        extScrollPane.setBackground(SystemColor.window);
        extScrollPane.addElement(this);
        return extScrollPane;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public int getColCount() {
        return this.cols.size();
    }

    public static final void drawZebraRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n3) {
            if ((n5 + n) % 2 == 0) {
                graphics.drawLine(n + n5, n2, n + n5, n2);
                graphics.drawLine(n + n5, n2 + n4, n + n5, n2 + n4);
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            if ((n6 + n2) % 2 == 0) {
                graphics.drawLine(n, n2 + n6, n, n2 + n6);
                graphics.drawLine(n + n3, n2 + n6, n + n3, n2 + n6);
            }
            ++n6;
        }
    }

    public void repaint() {
        super.repaint();
    }

    public void repaint(int n, int n2, int n3, int n4) {
        super.repaint(n, n2, n3, n4);
    }

    public void setCell(int n, int n2, Object object) {
        GridCol gridCol = (GridCol)this.cols.elementAt(n);
        gridCol.data.setElementAt(object, this.indexed ? this.index[n2] : n2);
    }

    public Object getCell(int n, int n2) {
        if (n >= this.cols.size()) {
            return null;
        }
        GridCol gridCol = (GridCol)this.cols.elementAt(n);
        if (n2 >= gridCol.data.size()) {
            return null;
        }
        return gridCol.data.elementAt(this.indexed ? this.index[n2] : n2);
    }

    public Object getCell() {
        return this.getCell(this.cursor.x, this.cursor.y);
    }

    void spacePressed() {
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed((ActionEvent)aWTEvent);
            }
            return;
        }
        super.processEvent(aWTEvent);
    }

    String getActionString() {
        return "" + this.cursor.x + "," + this.cursor.y;
    }

    public void doAction() {
        this.processEvent(new ActionEvent(this, 0, this.getActionString()));
    }

    public ExtGrid() {
        this.setLayout(null);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public boolean moveCursor(int n, int n2) {
        Point point = new Point(this.cursor);
        point.x += n;
        point.y += n2;
        if (point.x < 0) {
            point.x = 0;
        }
        if (point.x >= this.cols.size()) {
            point.x = this.cols.size() - 1;
        }
        if (point.y < 0) {
            point.y = 0;
        }
        if (point.y >= ((GridCol)this.cols.elementAt((int)this.cursor.x)).data.size()) {
            point.y = ((GridCol)this.cols.elementAt((int)this.cursor.x)).data.size() - 1;
        }
        if (((GridCol)this.cols.elementAt((int)point.x)).width == 0) {
            point.x -= n;
        }
        if (this.cursor.equals(point)) {
            return false;
        }
        int n3 = Math.min(this.cursor.y, point.y);
        int n4 = Math.max(this.cursor.y, point.y);
        this.cursor = point;
        this.checkCursorVisibility();
        this.repaint(0, this.getCellHeight() * (n3 + (this.drawHeader ? 1 : 0)) + this.graphicsLoc.y, this.getSize().width, this.getCellHeight() * (n4 - n3 + 1));
        this.cursorChanged();
        return true;
    }

    public void cursorChanged() {
    }

    public void keyPressed(Object object, KeyEvent keyEvent) {
    }

    void noDown() {
    }

    void noDoubleDown() {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.getRowCount() == 0) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 40: {
                if (this.moveCursor(0, 1)) break;
                this.noDown();
                break;
            }
            case 38: {
                this.moveCursor(0, -1);
                break;
            }
            case 37: {
                this.moveCursor(-1, 0);
                break;
            }
            case 39: {
                this.moveCursor(1, 0);
                break;
            }
            case 33: {
                Dimension dimension = null;
                dimension = this.parentSP != null ? this.parentSP.getViewportSize() : this.getSize();
                this.moveCursor(0, -dimension.height / this.getCellHeight());
                break;
            }
            case 34: {
                Dimension dimension = null;
                dimension = this.parentSP != null ? this.parentSP.getViewportSize() : this.getSize();
                if (this.moveCursor(0, dimension.height / this.getCellHeight())) break;
                this.noDoubleDown();
            }
        }
        this.keyPressed(this.getCell(this.cursor.x, this.cursor.y), keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 32: {
                if (this.actionOnSpace) {
                    this.doAction();
                }
                this.spacePressed();
                break;
            }
            case 10: {
                this.doAction();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    void mousePressed(Object object, int n, int n2, MouseEvent mouseEvent) {
        this.checkCursorVisibility();
        this.repaint();
    }

    private int getForeWidth(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 += this.getCellWidth(n3);
            ++n3;
        }
        return n2;
    }

    private GridCol getCol(int n) {
        return (GridCol)this.cols.elementAt(n);
    }

    private void setMouseToCursor(Point point, MouseEvent mouseEvent) {
        int n;
        Point point2 = point;
        Point point3 = new Point(this.cursor);
        this.cursor.y = point2.y / this.getCellHeight(this.getFontMetrics(this.getFont()));
        if (this.drawHeader) {
            --this.cursor.y;
        }
        if (this.cursor.y < 0) {
            this.cursor.y = 0;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.cols.size()) {
            if (point2.x < (n2 += this.getCellWidth(n3))) {
                this.cursor.x = n3;
                break;
            }
            ++n3;
        }
        if (n3 < this.cols.size()) {
            n2 -= this.getCellWidth(n3);
        }
        if ((n = ((GridCol)this.cols.elementAt((int)this.cursor.x)).data.size() - 1) == -1) {
            return;
        }
        if (this.cursor.y > n) {
            this.cursor.y = n;
        } else if (mouseEvent.getID() == 501) {
            this.mousePressed(this.getCell(this.cursor.x, this.cursor.y), point2.x - n2, point2.y - this.cursor.y * this.getCellHeight(this.getFontMetrics(this.getFont())), mouseEvent);
        } else {
            this.mouseDragged(this.getCell(this.cursor.x, this.cursor.y), point2.x - n2, point2.y - this.cursor.y * this.getCellHeight(this.getFontMetrics(this.getFont())), mouseEvent);
        }
        if (!this.cursor.equals(point3)) {
            this.cursorChanged();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point.x -= this.graphicsLoc.x;
        point.y -= this.graphicsLoc.y;
        if (this.catchFocus) {
            this.requestFocus();
        }
        if (this.changeColI != -1) {
            this.changeWidth = this.getCol((int)this.changeColI).width;
            this.colChanging = true;
            this.repaint();
        } else {
            this.setMouseToCursor(point, mouseEvent);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point.x -= this.graphicsLoc.x;
        point.y -= this.graphicsLoc.y;
        if (this.changeCols) {
            int n = 0;
            Point point2 = point;
            this.changeColI = -1;
            int n2 = 0;
            while (n2 < this.cols.size()) {
                if (((GridCol)this.cols.elementAt((int)n2)).resizeAble && point2.x >= (n += ((GridCol)this.cols.elementAt((int)n2)).width) - this.changeColRange & point2.x <= n + this.changeColRange) {
                    this.changeColI = n2;
                }
                ++n2;
            }
            if (this.changeColI == -1) {
                this.setCursor(this.defaultCursor);
            } else {
                this.setCursor(this.changeColCursor);
            }
        }
    }

    void mouseDragged(Object object, int n, int n2, MouseEvent mouseEvent) {
        this.checkCursorVisibility();
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point.x -= this.graphicsLoc.x;
        point.y -= this.graphicsLoc.y;
        if (!this.hasFocus & this.catchFocus) {
            this.requestFocus();
        }
        if (this.colChanging) {
            this.changeWidth = Math.max(5, point.x - this.getForeWidth(this.changeColI));
            this.repaint();
        } else {
            this.setMouseToCursor(point, mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.changeColI != -1) {
            this.getCol((int)this.changeColI).width = this.changeWidth;
            this.colChanging = false;
            this.repaint();
            if (this.parentSP != null) {
                this.parentSP.invalidate();
                this.parentSP.validate();
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() >= 2 | this.actionOnClick) {
            this.doAction();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.repaint();
    }

    public void checkCursorVisibility() {
        if (this.parentSP != null) {
            FontMetrics fontMetrics;
            int n = 0;
            int n2 = 0;
            while (n2 < this.cursor.x) {
                n += this.getCellWidth(n2);
                ++n2;
            }
            try {
                fontMetrics = this.getFontMetrics(this.getFont());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            int n3 = this.getCellHeight(fontMetrics);
            int n4 = this.cursor.y * n3;
            int n5 = this.getCellWidth(this.cursor.x);
            Point point = new Point(this.parentSP.getScrollPosition());
            Dimension dimension = this.parentSP.getViewportSize();
            dimension.height -= this.parentSP.getHScrollbarHeight() + this.parentSP.getInsets().bottom + this.parentSP.getInsets().top;
            if (n - point.x + n5 > dimension.width) {
                point.x = n + n5 - dimension.width;
            }
            if (n4 - point.y + n3 > dimension.height) {
                point.y = n4 + n3 - dimension.height;
            }
            if (n - point.x < 0) {
                point.x = n;
            }
            if (n4 - point.y < 0) {
                point.y = n4;
            }
            if (!this.parentSP.getScrollPosition().equals(point)) {
                this.parentSP.setScrollPosition(point);
            }
        }
    }

    public void setCursor(int n, int n2) {
        this.cursor.x = n;
        this.cursor.y = n2;
        this.checkCursorVisibility();
        this.repaint();
        this.cursorChanged();
    }

    public boolean isFocusTraversable() {
        return this.catchFocus;
    }

    public Dimension getPreferredSize() {
        if (this.cols.size() == 0) {
            return new Dimension(10, 10);
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.cols.size()) {
            n += this.getCellWidth(n2);
            ++n2;
        }
        return new Dimension(n, this.getCellHeight(this.getFontMetrics(this.getFont())) * (((GridCol)this.cols.elementAt((int)0)).data.size() + (this.drawHeader ? 1 : 0)));
    }

    public Point getIncrements() {
        return new Point(10, this.getCellHeight());
    }

    public Dimension getGraphicsSize() {
        return this.getPreferredSize();
    }

    public int getRowCount() {
        if (this.cols.size() == 0) {
            return 0;
        }
        return ((GridCol)this.cols.elementAt((int)0)).data.size();
    }

    public void clearCols() {
        this.cols.setSize(0);
    }

    public void clear() {
        int n = 0;
        while (n < this.cols.size()) {
            ((GridCol)this.cols.elementAt((int)n)).data.setSize(0);
            ++n;
        }
        this.datax = 0;
        this.cursor.x = 0;
        this.cursor.y = 0;
        this.repaint();
    }

    public void addCol() {
        this.addCol(null, this.colWidth, true);
    }

    public void addCol(String string) {
        this.addCol(string, this.colWidth, true);
    }

    public void addCol(String string, int n, boolean bl) {
        this.addCol(string, string, n, bl);
    }

    public void addCol(String string, String string2, int n, boolean bl) {
        GridCol gridCol = new GridCol();
        this.cols.addElement(gridCol);
        gridCol.id = string2;
        gridCol.name = string;
        gridCol.width = n;
        gridCol.resizeAble = bl;
    }

    public void data(Object object) {
        ((GridCol)this.cols.elementAt((int)this.datax)).data.addElement(object);
        ++this.datax;
        if (this.datax == this.cols.size()) {
            this.datax = 0;
            if (this.indexed) {
                int n = ((GridCol)this.cols.elementAt((int)0)).data.size();
                if (this.index.length == n) {
                    int[] nArray = new int[this.index.length + 1000];
                    System.arraycopy(this.index, 0, nArray, 0, this.index.length);
                    this.index = nArray;
                }
                this.index[n] = n;
            }
        }
        if (this.dataSync) {
            if (this.parentSP != null) {
                this.parentSP.invalidate();
                this.parentSP.validate();
            }
            this.repaint();
        } else {
            this.gotData = true;
        }
    }

    void checkScrollers() {
        if (this.parentSP != null) {
            this.parentSP.validate();
        }
    }

    public void data(Object object, int n) {
        ((GridCol)this.cols.elementAt((int)n)).data.addElement(object);
        this.repaint();
    }

    void calcPreferredWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        this.colWidth = 20;
        GridCol gridCol = (GridCol)this.cols.elementAt(0);
        int n = 0;
        while (n < gridCol.data.size()) {
            int n2 = fontMetrics.stringWidth((String)gridCol.data.elementAt(n));
            if (n2 > this.colWidth) {
                this.colWidth = n2;
            }
            ++n;
        }
        this.colWidth += 4;
    }

    public int getCellHeight() {
        if (this.getFont() == null) {
            this.setFont(new Font("Dialog", 0, 12));
        }
        return this.getCellHeight(this.getFontMetrics(this.getFont()));
    }

    public int getCellHeight(FontMetrics fontMetrics) {
        if (fontMetrics == null) {
            return 10;
        }
        return fontMetrics.getHeight();
    }

    public int getCellWidth(int n) {
        return this.getCol((int)n).width;
    }

    void dataFlush() {
        this.gotData = false;
        this.parentSP.invalidate();
        this.parentSP.validate();
        this.repaint();
    }

    public void run() {
        while (this.isOn) {
            try {
                Thread.sleep(300L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (!this.gotData) continue;
            this.dataFlush();
        }
    }

    public void removeNotify() {
        this.removeKeyListener(this);
        this.isOn = false;
        super.removeNotify();
    }

    public void addNotify() {
        super.addNotify();
        this.addKeyListener(this);
        if (this.getParent().getParent() instanceof ExtScrollPane) {
            this.parentSP = (ExtScrollPane)this.getParent().getParent();
        }
        this.isOn = true;
        if (!this.dataSync) {
            new Thread(this).start();
        }
    }

    public void paint(Graphics graphics) {
        int n;
        graphics.translate(this.graphicsLoc.x, this.graphicsLoc.y);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Point point = new Point(0, 0);
        Rectangle rectangle = new Rectangle(point.x, point.y, 0, 0);
        rectangle.height = this.getCellHeight(fontMetrics);
        Point point2 = new Point();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        if (this.parentSP != null) {
            n2 = this.parentSP.getScrollPosition().y;
            n3 = n2 + this.parentSP.getViewportSize().height;
        } else {
            n2 = 0;
            n3 = this.getParent().getSize().height;
        }
        Rectangle rectangle2 = graphics.getClipBounds();
        n2 = Math.max(n2, rectangle2.y);
        n3 = Math.min(n3, rectangle2.y + rectangle2.height);
        int n4 = n2 / rectangle.height;
        int n5 = n3 / rectangle.height + 1;
        if (this.drawHeader) {
            point.y += rectangle.height;
            if (--n4 < 0) {
                n4 = 0;
            }
            --n5;
        }
        int n6 = 0;
        while (n6 < this.cols.size()) {
            GridCol gridCol = (GridCol)this.cols.elementAt(n6);
            rectangle.y = point.y + n4 * rectangle.height;
            rectangle.width = this.getCellWidth(n6);
            point2.x = n6;
            n = n4;
            while (n < Math.min(n5, gridCol.data.size())) {
                point2.y = n;
                this.drawCell(gridCol.data.elementAt(this.indexed ? this.index[n] : n), graphics, rectangle, point2, fontMetrics);
                if (this.cursor.equals(point2) && this.hasFocus & this.normCursor) {
                    ExtGrid.drawZebraRect(graphics, rectangle.x, rectangle.y, rectangle.width - 2, rectangle.height - 2);
                }
                rectangle.y += rectangle.height;
                ++n;
            }
            rectangle.x += rectangle.width;
            ++n6;
        }
        if (this.drawHeader & n4 == 0) {
            n = rectangle.height;
            int n7 = 0;
            int n8 = 0;
            if (this.parentSP != null) {
                n8 = this.parentSP.getScrollPosition().y;
            }
            int n9 = 0;
            while (n9 < this.cols.size()) {
                int n10 = this.getCellWidth(n9);
                graphics.setColor(Color.gray);
                graphics.fill3DRect(n7, n8, n10, n, true);
                graphics.setColor(Color.black);
                Shape shape = graphics.getClip();
                graphics.setClip(n7, n8, n10, n);
                graphics.drawString(((GridCol)this.cols.elementAt((int)n9)).name, n7 + 2, fontMetrics.getAscent() + n8);
                graphics.setClip(shape);
                n7 += n10;
                ++n9;
            }
        }
        if (this.colChanging) {
            graphics.setColor(this.getBackground().darker());
            Point point3 = this.parentSP.getScrollPosition();
            graphics.fill3DRect(this.getForeWidth(this.changeColI) + this.changeWidth - 2, point3.y, 4, this.getSize().height, true);
        }
    }

    public void drawCell(Object object, Graphics graphics, Rectangle rectangle, Point point, FontMetrics fontMetrics) {
        graphics.drawString(object.toString(), rectangle.x, rectangle.y + fontMetrics.getAscent());
    }

    public String toString() {
        return "extgrid";
    }

    public static void main(String[] stringArray) {
        ExtGrid extGrid = new ExtGrid();
        extGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(actionEvent);
            }
        });
        extGrid.addCol();
        extGrid.addCol();
        extGrid.addCol();
        extGrid.changeCols = true;
        int n = 0;
        while (n < 100) {
            extGrid.data("data" + n);
            ++n;
        }
        Utils.mainFrame(extGrid.withScrollPane());
    }

    public class GridCol {
        public Vector data = new Vector();
        int width;
        String name;
        public String id;
        boolean resizeAble;

        public GridCol() {
            this.width = ExtGrid.this.colWidth;
            this.name = null;
            this.id = null;
            this.resizeAble = true;
        }
    }
}

