/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.DiaAble;
import auto.awt.HotKey;
import auto.awt.ImageManager;
import auto.awt.StringInterpreter;
import auto.awt.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionListener;

public class ExtImage
extends Component
implements DiaAble {
    Image img;
    boolean center = false;
    boolean fillout = false;
    boolean noscale = true;
    String filename = "";
    boolean selected = false;
    Color backCol = null;
    static final boolean DEBUG = false;

    public String getValue() {
        return this.filename;
    }

    public void setValue(String string) {
        this.filename = string;
    }

    public void setSelect(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    public String getOwnMenu() {
        return null;
    }

    public void reactOnHotKey() {
    }

    public void setHotKey(HotKey hotKey) {
    }

    public HotKey getHotKey() {
        return null;
    }

    public void addActionListener(ActionListener actionListener) {
    }

    public void removeActionListener(ActionListener actionListener) {
    }

    public String getCaption() {
        return "";
    }

    public void setCaption(String string) {
    }

    public ExtImage(String string, String string2) {
        this(string, string2, false);
    }

    public void setBackground(Color color) {
        this.backCol = color;
        this.repaint();
    }

    public void setImage(String string) {
        this.filename = string;
        this.img = ImageManager.getImage(string);
        this.repaint();
    }

    public ExtImage(String string, String string2, boolean bl) {
        this.img = bl ? ImageManager.getImage(string, this) : ImageManager.getImage(string);
        this.filename = string;
        if (string2.length() > 0) {
            this.setOptions(string2);
        }
    }

    public ExtImage(String string) {
        this(string, "", false);
    }

    public ExtImage(String string, boolean bl) {
        this(string, "", bl);
    }

    public void setOptions(String string) {
        StringInterpreter stringInterpreter = new StringInterpreter(string, true, true);
        if (stringInterpreter.isVariable("center")) {
            this.center = true;
        }
        if (stringInterpreter.isVariable("fillout")) {
            this.fillout = true;
        }
        if (stringInterpreter.isVariable("noscale")) {
            this.noscale = true;
        }
        if (stringInterpreter.isVariable("scale")) {
            this.noscale = false;
        }
    }

    public String getOptions() {
        String string = "";
        if (this.center) {
            string = string + ";center";
        }
        if (this.fillout) {
            string = string + ";fillout";
        }
        if (this.noscale) {
            string = string + ";noscale";
        }
        if (string.length() > 0) {
            string = string.substring(1);
        }
        return string;
    }

    public Dimension getPreferredSize() {
        if (this.img == null) {
            return new Dimension(30, 30);
        }
        return new Dimension(this.img.getWidth(this), this.img.getHeight(this));
    }

    public void paint(Graphics graphics) {
        if (this.backCol != null) {
            graphics.setColor(this.backCol);
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
        if (this.img != null) {
            if (this.noscale) {
                if (this.center) {
                    graphics.drawImage(this.img, (this.getSize().width - this.img.getWidth(this)) / 2, (this.getSize().height - this.img.getHeight(this)) / 2, this);
                } else {
                    graphics.drawImage(this.img, 0, 0, this);
                }
            } else {
                float f = (float)this.getSize().width / (float)this.img.getWidth(this);
                float f2 = (float)this.getSize().height / (float)this.img.getHeight(this);
                if (!this.fillout) {
                    if (f2 > f) {
                        f2 = f;
                    } else {
                        f = f2;
                    }
                }
                graphics.drawImage(this.img, 0, 0, (int)((float)this.img.getWidth(this) * f), (int)((float)this.img.getHeight(this) * f2), this);
            }
        } else {
            graphics.drawString("cant load:" + this.filename, 0, graphics.getFontMetrics().getAscent());
            graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
        }
        if (this.selected) {
            Utils.drawSelectMarks(this, graphics);
        }
    }
}

