/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.ExtGrid;
import auto.awt.ScrollGraphicsAble;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;

public final class ExtScrollPane
extends Panel
implements AdjustmentListener,
FocusListener {
    Scrollbar sVert;
    Scrollbar sHori;
    Panel panel;
    Insets insets = new Insets(2, 2, 2, 2);
    Dimension oldsize = new Dimension(0, 0);

    public void focusGained(FocusEvent focusEvent) {
        this.transferFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public static final void draw3DRect(Graphics graphics, Rectangle rectangle, Color color, boolean bl) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        if (!bl) {
            graphics.setColor(color);
            graphics.drawLine(n, n2, n, n4);
            graphics.drawLine(n, n2, n3, n4);
            graphics.setColor(color.brighter());
            graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 1);
            graphics.drawLine(n + 1, n2 + 1, n3 - 1, n2 + 1);
            graphics.setColor(Color.black);
            graphics.drawLine(n, n4, n3, n4);
            graphics.drawLine(n3, n2, n3, n4);
            graphics.setColor(color.darker());
            graphics.drawLine(n + 1, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, n2 + 2, n3 - 1, n4 - 1);
        } else {
            graphics.setColor(Color.black);
            graphics.drawLine(n, n2, n, n4);
            graphics.drawLine(n, n2, n3, n2);
            graphics.setColor(color.darker());
            graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 1);
            graphics.drawLine(n + 1, n2 + 1, n3 - 1, n2 + 1);
            graphics.setColor(color.brighter());
            graphics.drawLine(n, n4, n3, n4);
            graphics.drawLine(n3, n2, n3, n4);
            graphics.setColor(color);
            graphics.drawLine(n + 1, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, n2 + 2, n3 - 1, n4 - 1);
        }
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        ExtScrollPane.draw3DRect(graphics, new Rectangle(0, 0, this.getSize().width, this.getSize().height), Color.gray, true);
    }

    public ExtScrollPane() {
        this.setLayout(null);
        this.sVert = new Scrollbar(1);
        this.sVert.addAdjustmentListener(this);
        this.sVert.addFocusListener(this);
        this.add(this.sVert);
        this.sHori = new Scrollbar(0);
        this.sHori.addAdjustmentListener(this);
        this.sHori.addFocusListener(this);
        this.add(this.sHori);
        this.panel = new ScrollPanel();
        this.panel.setLayout(null);
        this.panel.addFocusListener(this);
        this.addFocusListener(this);
        this.add(this.panel);
        try {
            Class.forName("auto.awt.ESPMouseWheel").getConstructor(this.getClass()).newInstance(this);
        }
        catch (Exception exception) {
            System.err.println("ExtScrollPane: " + exception);
        }
    }

    public int getHScrollbarHeight() {
        return this.sHori.getSize().height;
    }

    public Point getScrollPosition() {
        Point point = this.panel.getComponent(0) instanceof ScrollGraphicsAble ? ((ScrollGraphicsAble)((Object)this.panel.getComponent(0))).getGraphicsLocation() : this.panel.getComponent(0).getLocation();
        return new Point(-point.x, -point.y);
    }

    public void setScrollPosition(Point point) {
        if (this.panel.getComponent(0) instanceof ScrollGraphicsAble) {
            ((ScrollGraphicsAble)((Object)this.panel.getComponent(0))).setGraphicsLocation(-point.x, -point.y);
        } else {
            this.panel.getComponent(0).setLocation(-point.x, -point.y);
        }
        this.setScroller();
    }

    public Dimension getViewportSize() {
        return this.panel.getSize();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.panel.getComponentCount() > 0) {
            if (this.panel.getComponent(0) instanceof ScrollGraphicsAble) {
                ((ScrollGraphicsAble)((Object)this.panel.getComponent(0))).setGraphicsLocation(-this.sHori.getValue(), -this.sVert.getValue());
            } else {
                this.panel.getComponent(0).setLocation(-this.sHori.getValue(), -this.sVert.getValue());
            }
        }
    }

    void layoutScrollers(Insets insets, Dimension dimension, Dimension dimension2, Dimension dimension3) {
        this.sHori.setBounds(insets.left, dimension.height - dimension2.height - insets.bottom, dimension.width - dimension3.width - insets.left - insets.right, dimension2.height);
        this.sVert.setBounds(dimension.width - dimension3.width - insets.right, insets.top, dimension3.width, dimension.height - dimension2.height - insets.top - insets.bottom);
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.sHori.getPreferredSize();
        Dimension dimension3 = this.sVert.getPreferredSize();
        Insets insets = this.insets;
        this.layoutScrollers(insets, dimension, dimension2, dimension3);
        this.panel.setBounds(insets.left, insets.top, dimension.width - dimension3.width - insets.left - insets.right, dimension.height - dimension2.height - insets.top - insets.bottom);
        if (this.panel.getComponentCount() > 0) {
            Component component = this.panel.getComponent(0);
            if (component instanceof ScrollGraphicsAble) {
                ScrollGraphicsAble scrollGraphicsAble = (ScrollGraphicsAble)((Object)component);
                component.setBounds(0, 0, this.panel.getSize().width, this.panel.getSize().height);
                dimension = scrollGraphicsAble.getGraphicsSize();
                Point point = scrollGraphicsAble.getGraphicsLocation();
                if (point.x + dimension.width < this.panel.getSize().width) {
                    point.x = Math.min(0, this.panel.getSize().width - dimension.width);
                }
                if (point.y + dimension.height < this.panel.getSize().height) {
                    point.y = Math.min(0, this.panel.getSize().height - dimension.height);
                }
                if (!point.equals(scrollGraphicsAble.getGraphicsLocation())) {
                    scrollGraphicsAble.setGraphicsLocation(point.x, point.y);
                }
            } else {
                dimension = component.getPreferredSize();
                component.setSize(Math.max(this.panel.getSize().width, dimension.width), Math.max(this.panel.getSize().height, dimension.height));
                dimension = component.getSize();
                Point point = component.getLocation();
                if (point.x + dimension.width < this.panel.getSize().width) {
                    point.x = Math.min(0, this.panel.getSize().width - dimension.width);
                }
                if (point.y + dimension.height < this.panel.getSize().height) {
                    point.y = Math.min(0, this.panel.getSize().height - dimension.height);
                }
                if (!point.equals(component.getLocation())) {
                    component.setLocation(point.x, point.y);
                }
            }
        }
        this.setScroller();
    }

    public void setScroller() {
        Cloneable cloneable;
        Object object;
        Component component;
        Component component2 = component = this.panel.getComponentCount() > 0 ? this.panel.getComponent(0) : null;
        if (component != null) {
            if (component instanceof ScrollGraphicsAble) {
                object = (ScrollGraphicsAble)((Object)component);
                cloneable = object.getGraphicsSize();
                Point point = object.getGraphicsLocation();
                this.sHori.setMaximum(cloneable.width);
                this.sHori.setValue(-point.x);
                this.sVert.setMaximum(cloneable.height);
                this.sVert.setValue(-point.y);
            } else {
                this.sHori.setMaximum(component.getSize().width);
                this.sHori.setValue(-component.getLocation().x);
                this.sVert.setMaximum(component.getSize().height);
                this.sVert.setValue(-component.getLocation().y);
            }
        }
        object = this.panel.getSize();
        this.sHori.setVisibleAmount(((Dimension)object).width);
        this.sVert.setVisibleAmount(((Dimension)object).height);
        this.sHori.setEnabled(this.sHori.getMaximum() != this.sHori.getVisibleAmount());
        this.sVert.setEnabled(this.sVert.getMaximum() != this.sVert.getVisibleAmount());
        if (component != null && component instanceof ScrollGraphicsAble) {
            cloneable = ((ScrollGraphicsAble)((Object)component)).getIncrements();
            this.sHori.setUnitIncrement(((Point)cloneable).x);
            this.sVert.setUnitIncrement(((Point)cloneable).y);
        }
    }

    public Component getElement() {
        if (this.panel.getComponentCount() == 0) {
            return null;
        }
        return this.panel.getComponent(0);
    }

    public void addElement(Component component) {
        this.panel.removeAll();
        this.panel.add(component, "Center");
        component.setLocation(0, 0);
        this.invalidate();
    }

    public void removeElement() {
        if (this.panel.getComponentCount() > 0) {
            this.panel.removeAll();
            this.invalidate();
            this.repaint();
        }
    }

    public static void main(String[] stringArray) {
        ExtGrid.main(stringArray);
    }

    class ScrollPanel
    extends Panel {
        Image offscreen;

        ScrollPanel() {
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void invalidate() {
            super.invalidate();
            Dimension dimension = this.getSize();
            if (dimension.width == ExtScrollPane.this.oldsize.width & dimension.height == ExtScrollPane.this.oldsize.height) {
                return;
            }
            ExtScrollPane.this.oldsize.width = dimension.width;
            ExtScrollPane.this.oldsize.height = dimension.height;
            if (dimension.width > 0 & dimension.height > 0) {
                this.offscreen = null;
            }
        }

        public void paint(Graphics graphics) {
            ScrollGraphicsAble scrollGraphicsAble = null;
            if (this.getComponentCount() < 1) {
                return;
            }
            if (this.getComponent(0) instanceof ScrollGraphicsAble) {
                scrollGraphicsAble = (ScrollGraphicsAble)((Object)this.getComponent(0));
            }
            if (scrollGraphicsAble != null) {
                scrollGraphicsAble.toggleCursor(false);
            }
            Rectangle rectangle = graphics.getClipBounds();
            if (!this.isShowing()) {
                return;
            }
            try {
                if (this.offscreen == null) {
                    this.offscreen = this.createImage(this.getSize().width, this.getSize().height);
                }
                if (this.offscreen == null) {
                    return;
                }
                Graphics graphics2 = this.offscreen.getGraphics();
                graphics2.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics2.setColor(ExtScrollPane.this.getBackground());
                graphics2.fillRect(0, 0, this.getSize().width, this.getSize().height);
                graphics2.setColor(Color.black);
                super.paint(graphics2);
                graphics2.dispose();
                if (this.offscreen != null) {
                    graphics.drawImage(this.offscreen, 0, 0, null);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (scrollGraphicsAble != null) {
                scrollGraphicsAble.toggleCursor(true);
            }
        }
    }
}

