/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.HotKey;
import auto.awt.Utils;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;

public class ExtTextField
extends Canvas
implements FocusListener,
MouseMotionListener,
MouseListener,
Runnable,
KeyListener {
    Thread cursorThread = null;
    String text;
    boolean hasFocus = false;
    int cX = 0;
    boolean isCursor = false;
    boolean doCursor = false;
    int lastI = 0;
    int dx = 0;
    int s1 = 0;
    int s2 = 0;
    boolean isSelection = false;
    public boolean thinBorder = false;
    public boolean thinXBorder = false;
    Image db = null;
    char echo = '\u0000';
    TextListener textListener = null;
    int col = 0;
    ActionListener actionListener;
    boolean enterTransferFocus = true;
    HotKey keyInsert = new HotKey("shift;INS ctrl;v");
    HotKey keyCopy = new HotKey("ctrl;INS ctrl;c");
    boolean doScroll = true;
    String caption = null;
    int captionCharCount = 0;
    int captionPhysLength = -1;
    boolean isRight = false;
    boolean isEditable = true;
    char[] sonderZ = new char[]{'{', '}', '[', ']', '\\', '|', '@', '~', '\u00b2', '\u00b3'};

    public void setRight(boolean bl) {
        this.isRight = bl;
        this.repaint();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void reactOnHotKey() {
        this.requestFocus();
    }

    public void setHotKey(HotKey hotKey) {
    }

    public HotKey getHotKey() {
        return null;
    }

    public void addTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.add(this.textListener, textListener);
    }

    public void removeTextListener(TextListener textListener) {
        this.textListener = AWTEventMulticaster.remove(this.textListener, textListener);
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed((ActionEvent)aWTEvent);
            }
            return;
        }
        if (aWTEvent instanceof TextEvent) {
            if (this.textListener != null) {
                this.textListener.textValueChanged((TextEvent)aWTEvent);
            }
            return;
        }
        super.processEvent(aWTEvent);
    }

    void doEvent() {
        this.processEvent(new TextEvent(this, 900));
    }

    public void keyPressed(KeyEvent keyEvent) {
        if ((keyEvent = Utils.checkApostroph(keyEvent)) == null) {
            return;
        }
        if (this.keyInsert.equals(keyEvent)) {
            if (!this.isEditable) {
                return;
            }
            this.insert();
            this.doEvent();
        }
        if (this.keyCopy.equals(keyEvent)) {
            if (!this.isEditable) {
                return;
            }
            this.copy();
            this.doEvent();
        }
        switch (keyEvent.getKeyCode()) {
            case 9: 
            case 10: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 27: 
            case 33: 
            case 34: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 155: {
                break;
            }
            case 8: {
                if (!this.isEditable) {
                    return;
                }
                if (this.cX <= 0) break;
                this.stopBlinking();
                if (this.isSelection) {
                    this.deleteSelected();
                } else {
                    this.text = this.text.substring(0, this.cX - 1) + this.text.substring(this.cX);
                    --this.cX;
                }
                this.paintRest();
                this.startBlinking();
                this.doEvent();
                break;
            }
            case 127: {
                if (!this.isEditable) {
                    return;
                }
                if (this.cX >= this.text.length()) break;
                this.stopBlinking();
                if (this.isSelection) {
                    this.deleteSelected();
                } else {
                    this.text = this.text.substring(0, this.cX) + this.text.substring(this.cX + 1);
                }
                this.paintRest();
                this.startBlinking();
                this.doEvent();
                break;
            }
            case 36: {
                if (this.cX <= 0) break;
                this.stopBlinking();
                this.startSelection(keyEvent);
                this.cX = 0;
                this.stopSelection();
                this.startBlinking();
                break;
            }
            case 35: {
                if (this.cX < this.text.length()) {
                    this.stopBlinking();
                    this.startSelection(keyEvent);
                    this.cX = this.text.length();
                    this.stopSelection();
                    this.startBlinking();
                    break;
                }
                this.removeSelection();
                break;
            }
            case 37: 
            case 38: {
                if (this.cX <= 0) break;
                this.stopBlinking();
                this.startSelection(keyEvent);
                if (keyEvent.isControlDown()) {
                    this.jumpToNextWord(-1);
                } else {
                    --this.cX;
                }
                this.stopSelection();
                this.startBlinking();
                break;
            }
            case 39: 
            case 40: {
                if (this.cX < this.text.length()) {
                    this.stopBlinking();
                    this.startSelection(keyEvent);
                    if (keyEvent.isControlDown()) {
                        this.jumpToNextWord(1);
                    } else {
                        ++this.cX;
                    }
                    this.stopSelection();
                    this.startBlinking();
                    break;
                }
                this.removeSelection();
                break;
            }
            default: {
                if (!this.isEditable) {
                    return;
                }
                if (!(!(keyEvent.isControlDown() | keyEvent.isAltDown()) | keyEvent.getKeyChar() == '\u20ac')) break;
                this.addKey(keyEvent);
            }
        }
    }

    void addKey(KeyEvent keyEvent) {
        this.stopBlinking();
        if (this.isSelection) {
            this.deleteSelected();
        }
        this.text = this.text.substring(0, this.cX) + keyEvent.getKeyChar() + this.text.substring(this.cX);
        this.paintRest();
        ++this.cX;
        this.startBlinking();
        this.doEvent();
    }

    void copy() {
        int n = this.s1 < this.s2 ? this.s1 : this.s2;
        int n2 = this.s1 < this.s2 ? this.s2 : this.s1;
        StringSelection stringSelection = new StringSelection(this.text.substring(n, n2));
        Utils.defaultToolkit.getSystemClipboard().setContents(stringSelection, stringSelection);
    }

    void insert() {
        Transferable transferable;
        this.stopBlinking();
        if (this.isSelection) {
            this.deleteSelected();
        }
        if ((transferable = Utils.defaultToolkit.getSystemClipboard().getContents(this)) instanceof StringSelection) {
            try {
                StringSelection stringSelection = (StringSelection)transferable;
                Object object = stringSelection.getTransferData(DataFlavor.stringFlavor);
                if (object instanceof String) {
                    this.text = this.text.substring(0, this.cX) + (String)object + this.text.substring(this.cX);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.paintRest();
        this.startBlinking();
    }

    void deleteSelected() {
        int n = this.s1 < this.s2 ? this.s1 : this.s2;
        int n2 = this.s1 < this.s2 ? this.s2 : this.s1;
        this.text = this.text.substring(0, n) + this.text.substring(n2);
        this.cX = n;
        this.isSelection = false;
    }

    void startSelection(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown()) {
            if (!this.isSelection) {
                this.isSelection = true;
                this.s1 = this.cX;
            }
        } else {
            this.removeSelection();
        }
    }

    void stopSelection() {
        if (this.isSelection) {
            this.s2 = this.cX;
            this.paintRest();
        }
    }

    void removeSelection() {
        this.isSelection = false;
        this.paintRest();
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent == null) {
            return;
        }
        if (Utils.checkLinuxUml(keyEvent)) {
            this.addKey(keyEvent);
        }
        if (!Utils.isLinux & !Utils.isMicrosoft) {
            int n = 0;
            while (n < this.sonderZ.length) {
                if (keyEvent.getKeyChar() == this.sonderZ[n]) {
                    this.addKey(keyEvent);
                }
                ++n;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 & this.enterTransferFocus) {
            this.transferFocus();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.stopBlinking();
        this.setCursorPosFromMouse(mouseEvent);
        this.s2 = this.cX;
        this.isSelection = true;
        this.paintRest();
        this.startBlinking();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.hasFocus) {
            this.requestFocus();
        }
        this.stopBlinking();
        if (this.isSelection) {
            this.removeSelection();
        }
        this.setCursorPosFromMouse(mouseEvent);
        this.s1 = this.cX;
        this.startBlinking();
    }

    void setCursorPosFromMouse(MouseEvent mouseEvent) {
        if (this.isRight) {
            int n = mouseEvent.getX() - 2 - this.dx - this.getCaptionLength();
            String string = this.texT();
            this.cX = string.length();
            int n2 = this.getSize().width - this.getCaptionLength();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n3 = string.length() - 1;
            while (n3 >= 0) {
                if (n <= (n2 -= fontMetrics.charWidth(string.charAt(n3)))) {
                    --this.cX;
                    --n3;
                    continue;
                }
                break;
            }
        } else {
            int n = mouseEvent.getX() - 2 + this.dx - this.getCaptionLength();
            this.cX = 0;
            int n4 = 0;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            String string = this.texT();
            int n5 = 0;
            while (n5 < string.length()) {
                if (n >= (n4 += fontMetrics.charWidth(string.charAt(n5)))) {
                    ++this.cX;
                    ++n5;
                    continue;
                }
                break;
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
        this.cursorThread = new Thread((Runnable)this){

            public String toString() {
                return "ExtTextField.cursor";
            }
        };
        this.cursorThread.start();
        this.startBlinking();
        this.selectAll();
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.stopBlinking();
        this.cursorThread.stop();
        this.cursorThread = null;
        if (this.dx != 0) {
            this.dx = 0;
        }
        this.removeSelection();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void jumpToNextWord(int n) {
        while (true) {
            if (n == 1) {
                ++this.cX;
                if (this.cX != this.text.length() && !(this.text.charAt(this.cX - 1) == ' ' & Character.isLetter(this.text.charAt(this.cX)))) continue;
                return;
            }
            --this.cX;
            if (this.cX == 0 || this.text.charAt(this.cX - 1) == ' ' & Character.isLetter(this.text.charAt(this.cX))) return;
        }
    }

    void paintRest() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        this.update(graphics);
        graphics.dispose();
    }

    void startBlinking() {
        if (this.isRight) {
            int n = this.getCaptionLength();
            int n2 = this.getSize().width - this.getFontMetrics(this.getFont()).stringWidth(this.sstring(this.texT(), this.cX, this.texT().length())) - 6 + this.dx;
            if (n2 + 10 > this.getSize().width) {
                this.moveText(-1);
            }
            if (n2 < n) {
                this.moveText(1);
            }
        } else {
            int n = this.getFontMetrics(this.getFont()).stringWidth(this.text.substring(0, this.cX)) - this.dx;
            if (n + 10 > this.getSize().width - this.getCaptionLength()) {
                this.moveText(1);
            }
            if (n < 0) {
                this.moveText(-1);
            }
        }
        this.drawCursor();
        this.doCursor = true;
    }

    void moveText(int n) {
        int n2;
        if (!this.doScroll) {
            return;
        }
        if (this.isRight) {
            n2 = this.getSize().width - this.getFontMetrics(this.getFont()).stringWidth(this.sstring(this.texT(), this.cX, this.texT().length())) - 6;
            int n3 = this.getSize().width - this.getFontMetrics(this.getFont()).stringWidth(this.texT()) - 6;
            int n4 = Math.min(30, (this.getSize().width - this.getCaptionLength()) / 2);
            this.dx = n == 1 ? (this.dx += 30) : (this.dx -= this.dx > 30 ? 30 : this.dx);
        } else {
            n2 = this.getFontMetrics(this.getFont()).stringWidth(this.texT().substring(0, this.cX));
            int n5 = this.getFontMetrics(this.getFont()).stringWidth(this.texT()) + 3;
            this.dx = n == 1 ? (this.dx += n5 - n2 < 50 ? n2 - this.dx - this.getSize().width + this.getCaptionLength() + 10 : n2 - this.dx - this.getSize().width + this.getCaptionLength() + 60) : (this.dx -= n2 < 50 ? this.dx : -n2 + this.dx + 50);
        }
        Graphics graphics = this.getGraphics();
        this.update(graphics);
        graphics.dispose();
    }

    synchronized void stopBlinking() {
        if (this.isCursor) {
            this.drawCursor();
        }
        this.doCursor = false;
    }

    public void run() {
        while (this.isShowing()) {
            this.drawCursor();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    synchronized void drawCursor() {
        if (!this.doCursor) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        int n = this.getCaptionLength();
        graphics.translate(n, 0);
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        int n2 = 0;
        n2 = this.isCursor ? this.lastI : (this.isRight ? this.getSize().width - n - graphics.getFontMetrics().stringWidth(this.sstring(this.texT(), this.cX, this.texT().length())) - 6 + this.dx : graphics.getFontMetrics().stringWidth(this.texT().substring(0, this.cX)) - this.dx);
        this.lastI = n2;
        int n3 = this.thinBorder | this.thinXBorder ? 1 : 2;
        int n4 = this.getSize().height - (this.thinBorder | this.thinXBorder ? 2 : 3);
        if (this.thinBorder | this.thinXBorder) {
            --n2;
        }
        if (this.isRight) {
            graphics.setClip(0, 0, this.getSize().width - n, this.getSize().height);
        }
        graphics.drawLine(2 + n2, n3, 2 + n2, n4);
        graphics.drawLine(3 + n2, n3, 3 + n2, n4);
        graphics.drawLine(4 + n2, n3, 4 + n2, n4);
        graphics.dispose();
        this.isCursor = !this.isCursor;
    }

    public ExtTextField() {
        this("", 0);
    }

    public ExtTextField(String string) {
        this(string, 0);
    }

    public ExtTextField(int n) {
        this("", n);
    }

    public ExtTextField(String string, int n) {
        this.text = string;
        if (this.text == null) {
            this.text = "";
        }
        this.col = n;
        this.cX = this.text.length();
        this.setCursor(new Cursor(2));
    }

    public void addNotify() {
        super.addNotify();
        this.addFocusListener(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
    }

    public void removeNotify() {
        this.removeFocusListener(this);
        this.removeMouseMotionListener(this);
        this.removeMouseListener(this);
        this.removeKeyListener(this);
        this.db = null;
        this.cursorThread = null;
        super.removeNotify();
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return new Dimension((this.col != 0 ? this.col * fontMetrics.charWidth('0') : fontMetrics.stringWidth(this.text)) + 20, fontMetrics.getHeight() + 4);
    }

    private String texT() {
        if (this.echo == '\u0000') {
            return this.text;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        while (n < this.text.length()) {
            stringBuffer.append(this.echo);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void setEchoChar(char c) {
        this.echo = c;
        if (this.hasFocus) {
            this.stopBlinking();
        }
        if (this.isShowing()) {
            this.paintRest();
        }
        if (this.hasFocus) {
            this.startBlinking();
        }
    }

    public char getEchoChar() {
        return this.echo;
    }

    public boolean echoCharIsSet() {
        return this.echo != '\u0000';
    }

    public int getCaretPosition() {
        return this.cX;
    }

    public void setCaretPosition(int n) {
        if (n > 0 & n <= this.text.length()) {
            this.stopBlinking();
            this.cX = n;
            this.startBlinking();
        }
    }

    public int getSelectionStart() {
        return this.s1;
    }

    public int getSelectionEnd() {
        return this.s2;
    }

    public void select(int n, int n2) {
        if (this.hasFocus) {
            this.stopBlinking();
        }
        this.s1 = n;
        this.s2 = n2;
        this.isSelection = true;
        if (this.isShowing()) {
            this.paintRest();
        }
        if (this.hasFocus) {
            this.startBlinking();
        }
    }

    public void selectAll() {
        if (this.text.length() > 0) {
            this.select(0, this.text.length());
        }
    }

    public void setSelectionStart(int n) {
        this.select(n, this.s2);
    }

    public void setSelectionEnd(int n) {
        this.select(this.s1, n);
    }

    public void setEditable(boolean bl) {
    }

    public boolean isEditable() {
        return true;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        if (this.hasFocus) {
            this.stopBlinking();
        }
        boolean bl = this.isSelection;
        this.isSelection = false;
        this.text = string;
        this.dx = 0;
        this.cX = this.text.length();
        if (this.isShowing()) {
            this.paintRest();
        }
        if (this.hasFocus) {
            this.startBlinking();
        }
        if (bl) {
            this.selectAll();
        }
    }

    public void update(Graphics graphics) {
        Graphics graphics2;
        if (this.getSize().width == 0 | this.getSize().height == 0) {
            return;
        }
        boolean bl = false;
        if (this.db == null) {
            bl = true;
        } else if (this.db.getWidth(this) != this.getSize().width | this.db.getHeight(this) != this.getSize().height) {
            bl = true;
        }
        if (bl) {
            this.db = this.createImage(this.getSize().width, this.getSize().height);
        }
        if ((graphics2 = this.db.getGraphics()) == null) {
            return;
        }
        this.paint(graphics2);
        graphics2.dispose();
        graphics.drawImage(this.db, 0, 0, this);
    }

    String sstring(String string, int n, int n2) {
        String string2 = "";
        try {
            string2 = string.substring(n, n2);
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    int getCaptionLength() {
        if (this.caption == null) {
            return 0;
        }
        if (this.captionPhysLength != -1) {
            return this.captionPhysLength;
        }
        return this.getFontMetrics(this.getFont()).stringWidth(this.caption) + 5;
    }

    public void paint(Graphics graphics) {
        int n;
        if (graphics == null) {
            return;
        }
        int n2 = 0;
        if (this.caption != null) {
            n2 = this.getCaptionLength();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, n2, this.getSize().height);
            graphics.setColor(this.getForeground());
            graphics.drawString(this.caption, 0, graphics.getFontMetrics().getAscent() + (this.getSize().height - graphics.getFontMetrics().getHeight()) / 2);
            if (this.hasFocus) {
                Utils.drawZebraRect(graphics, 1, 1, n2 - 3, this.getSize().height - 3);
            }
        }
        Point point = new Point(this.getSize().width - 1 - n2, this.getSize().height - 1);
        graphics.translate(n2, 0);
        if (this.thinBorder) {
            graphics.setColor(Color.black);
            graphics.drawLine(0, 0, point.x, 0);
            graphics.drawLine(0, 1, 0, point.y);
            graphics.setColor(this.getParent().getBackground().brighter());
            graphics.drawLine(1, point.y, point.x, point.y);
            graphics.drawLine(point.x, 1, point.x, point.y - 1);
            graphics.setColor(this.getBackground().brighter());
            graphics.fillRect(1, 1, point.x - 1, point.y - 1);
            graphics.setClip(1, 1, point.x, point.y);
        } else if (this.thinXBorder) {
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, point.x - 1, 1);
            graphics.drawLine(0, 1, 0, point.y);
            graphics.setColor(this.getParent().getBackground().darker());
            graphics.drawLine(0, 0, point.x, 0);
            graphics.setColor(this.getParent().getBackground().darker());
            graphics.drawLine(2, point.y - 1, point.x - 1, point.y - 1);
            graphics.setColor(this.getParent().getBackground().brighter());
            graphics.drawLine(1, point.y, point.x, point.y);
            graphics.drawLine(point.x, 1, point.x, point.y - 1);
            graphics.setColor(this.getBackground().brighter());
            graphics.fillRect(1, 2, point.x - 1, point.y - 3);
            graphics.setClip(1, 2, point.x, point.y - 3);
        } else {
            graphics.setColor(Color.black);
            graphics.drawLine(1, 1, point.x - 1, 1);
            graphics.drawLine(1, 2, 1, point.y - 1);
            graphics.setColor(this.getParent().getBackground().darker());
            graphics.drawLine(0, 0, point.x, 0);
            graphics.drawLine(0, 1, 0, point.y);
            graphics.setColor(this.getParent().getBackground().darker());
            graphics.drawLine(2, point.y - 1, point.x - 1, point.y - 1);
            graphics.drawLine(point.x - 1, 2, point.x - 1, point.y - 2);
            graphics.setColor(this.getParent().getBackground().brighter());
            graphics.drawLine(1, point.y, point.x, point.y);
            graphics.drawLine(point.x, 1, point.x, point.y - 1);
            graphics.setColor(this.getBackground().brighter());
            graphics.fillRect(2, 2, point.x - 3, point.y - 3);
            graphics.setClip(2, 2, point.x - 3, point.y - 3);
        }
        if (this.isRight) {
            Rectangle rectangle = graphics.getClipBounds();
            n = rectangle.width - graphics.getFontMetrics().stringWidth(this.texT()) - 1 + this.dx;
        } else {
            n = -this.dx;
        }
        if (this.isSelection) {
            int n3 = this.s1 < this.s2 ? this.s1 : this.s2;
            int n4 = this.s1 < this.s2 ? this.s2 : this.s1;
            graphics.setColor(Color.cyan.darker());
            if (this.thinBorder) {
                graphics.fillRect(1 + graphics.getFontMetrics().stringWidth(this.sstring(this.texT(), 0, n3)) + n, 1, graphics.getFontMetrics().stringWidth(this.sstring(this.texT(), n3, n4)), point.y - 1);
            } else {
                graphics.fillRect(2 + graphics.getFontMetrics().stringWidth(this.sstring(this.texT(), 0, n3)) + n, 2, graphics.getFontMetrics().stringWidth(this.sstring(this.texT(), n3, n4)), point.y - 3);
            }
        }
        graphics.setColor(this.getForeground());
        graphics.drawString(this.texT(), 3 + n, graphics.getFontMetrics().getAscent() + (this.getSize().height - graphics.getFontMetrics().getHeight()) / 2);
        graphics.translate(-n2, 0);
    }

    public void setCaption(String string) {
        this.caption = string;
        if (this.captionCharCount == 0) {
            this.captionCharCount = this.caption.length();
        }
        this.repaint();
    }

    public static void main(String[] stringArray) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        ExtTextField extTextField = new ExtTextField("Daten data");
        panel.add(extTextField);
        extTextField.setRight(true);
        extTextField = new ExtTextField("Daten data");
        panel.add(extTextField);
        extTextField.setRight(true);
        extTextField.setCaption("caption");
        Utils.mainFrame(panel);
    }
}

