/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.ControlPanel;
import auto.awt.Utils;
import dlib.ImageManager;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jedi.GlasUtils;

public class ExtWindow
extends Window
implements MouseListener,
MouseMotionListener,
ContainerListener {
    Point mp;
    boolean resizeAble = true;
    int cursorMode = 0;
    Cursor[] cursor = new Cursor[9];
    Insets insets = new Insets(2, 2, 2, 2);
    boolean isTitle = false;
    String title = "";
    Image backImg = null;
    Image backImg2 = null;

    public Dimension getPreferredSize() {
        if (this.backImg != null) {
            return new Dimension(this.backImg.getWidth(this), this.backImg.getHeight(this));
        }
        return super.getPreferredSize();
    }

    public void setImage(String string) {
        this.backImg = ImageManager.getImage((String)string, (Component)this, (int)5000);
    }

    public void setTitle(String string) {
        if (!this.isTitle) {
            this.isTitle = true;
            this.invalidate();
        }
        this.title = string;
        this.repaint();
    }

    public void componentAdded(ContainerEvent containerEvent) {
        Component component = containerEvent.getChild();
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        if (component instanceof Container) {
            ((Container)component).addContainerListener(this);
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.resizeAble) {
            return;
        }
        Point point = mouseEvent.getPoint();
        boolean[] blArray = new boolean[]{point.y <= this.insets.top + 5, point.x >= this.getSize().width - this.insets.right - 5, point.y >= this.getSize().height - this.insets.bottom - 5, point.x <= this.insets.left + 5};
        int n = 0;
        if (blArray[0]) {
            n = blArray[3] ? 1 : (blArray[1] ? 3 : 2);
        } else if (blArray[2]) {
            n = blArray[3] ? 7 : (blArray[1] ? 5 : 6);
        } else if (blArray[3]) {
            n = 8;
        } else if (blArray[1]) {
            n = 4;
        }
        if (n != this.cursorMode) {
            this.cursorMode = n;
            this.setCursor(this.cursor[n]);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setCursor(this.cursor[this.cursorMode]);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(this.cursor[0]);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.validate();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mp = mouseEvent.getComponent().getLocationOnScreen();
        this.mp.x += mouseEvent.getX();
        this.mp.y += mouseEvent.getY();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = mouseEvent.getComponent().getLocationOnScreen();
        point.x += mouseEvent.getX();
        point.y += mouseEvent.getY();
        switch (this.cursorMode) {
            case 0: {
                this.setLocation(this.getLocation().x + point.x - this.mp.x, this.getLocation().y + point.y - this.mp.y);
                break;
            }
            case 1: {
                this.setBounds(this.getLocation().x + point.x - this.mp.x, this.getLocation().y + point.y - this.mp.y, this.getSize().width - point.x + this.mp.x, this.getSize().height - point.y + this.mp.y);
                break;
            }
            case 2: {
                this.setBounds(this.getLocation().x, this.getLocation().y + point.y - this.mp.y, this.getSize().width, this.getSize().height - point.y + this.mp.y);
                break;
            }
            case 3: {
                this.setBounds(this.getLocation().x, this.getLocation().y + point.y - this.mp.y, this.getSize().width + point.x - this.mp.x, this.getSize().height - point.y + this.mp.y);
                break;
            }
            case 4: {
                this.setBounds(this.getLocation().x, this.getLocation().y, this.getSize().width + point.x - this.mp.x, this.getSize().height);
                break;
            }
            case 5: {
                this.setSize(this.getSize().width + point.x - this.mp.x, this.getSize().height + point.y - this.mp.y);
                break;
            }
            case 6: {
                this.setSize(this.getSize().width, this.getSize().height + point.y - this.mp.y);
                break;
            }
            case 7: {
                this.setBounds(this.getLocation().x + point.x - this.mp.x, this.getLocation().y, this.getSize().width - point.x + this.mp.x, this.getSize().height + point.y - this.mp.y);
                break;
            }
            case 8: {
                this.setBounds(this.getLocation().x + point.x - this.mp.x, this.getLocation().y, this.getSize().width - point.x + this.mp.x, this.getSize().height);
            }
        }
        this.mp = point;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void invalidate() {
        super.invalidate();
        this.backImg2 = null;
    }

    public void paint(Graphics graphics) {
        if (this.backImg != null) {
            if (this.backImg2 == null) {
                this.backImg2 = this.createImage(this.getSize().width, this.getSize().height);
                Graphics graphics2 = this.backImg2.getGraphics();
                graphics2.drawImage(this.backImg, 0, 0, this.getSize().width, this.getSize().height, this);
                graphics2.dispose();
                this.backImg2 = GlasUtils.filter3D((Component)this, (Image)this.backImg2);
            }
            graphics.drawImage(this.backImg2, 0, 0, this);
        } else {
            Utils.draw3DRect(graphics, new Rectangle(0, 0, this.getSize().width, this.getSize().height), this.getBackground(), false);
            graphics.setColor(this.getBackground());
            graphics.fillRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
            if (this.isTitle) {
                int n = graphics.getFontMetrics().getHeight() + 4;
                Utils.draw3DRect(graphics, new Rectangle(2, 2, this.getSize().width - 4, n), this.getBackground(), true);
                graphics.setColor(this.getForeground());
                graphics.drawString(this.title, 6, 4 + graphics.getFontMetrics().getAscent());
            }
        }
        super.paint(graphics);
    }

    public ExtWindow(String string) {
        this(string, Utils.getStaticFrame());
    }

    public ExtWindow() {
        this(null, Utils.getStaticFrame());
    }

    public ExtWindow(Frame frame) {
        this(null, frame);
    }

    public ExtWindow(String string, Frame frame) {
        super(frame);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(SystemColor.control);
        this.cursor[0] = new Cursor(0);
        this.cursor[1] = new Cursor(6);
        this.cursor[2] = new Cursor(8);
        this.cursor[3] = new Cursor(7);
        this.cursor[4] = new Cursor(11);
        this.cursor[5] = new Cursor(5);
        this.cursor[6] = new Cursor(9);
        this.cursor[7] = new Cursor(4);
        this.cursor[8] = new Cursor(10);
        if (string != null) {
            this.setTitle(string);
        }
    }

    public Insets getInsets() {
        return new Insets(2 + (this.isTitle ? this.getFontMetrics(this.getFont()).getHeight() + 4 : 0), 2, 2, 2);
    }

    public static void showWin(Component component, int n, int n2, int n3, int n4) {
        ExtWindow.showWin(null, component, n, n2, n3, n4);
    }

    public static void showWin(Frame frame, Component component, int n, int n2, int n3, int n4) {
        ExtWindow extWindow = new ExtWindow(frame);
        extWindow.setLayout(new BorderLayout());
        extWindow.add((Component)new ControlPanel(component, 4), "Center");
        extWindow.setBounds(n, n2, n3, n4);
        extWindow.show();
    }

    public static void main(String[] stringArray) {
        ExtWindow extWindow = new ExtWindow();
        extWindow.setLayout(new FlowLayout());
        extWindow.add((Component)new Button("test"), "Center");
        extWindow.add(new Label("Hallo Welt"));
        extWindow.setBounds(10, 10, 400, 300);
        extWindow.show();
        extWindow.pack();
    }
}

