/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.StringInterpreter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.StringTokenizer;

public final class HotKey
implements Serializable {
    boolean[] alt = null;
    boolean[] ctrl = null;
    public boolean[] shift = null;
    public int[] keyCode = null;

    HotKey() {
    }

    public HotKey(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        this.alt = new boolean[stringTokenizer.countTokens()];
        this.ctrl = new boolean[stringTokenizer.countTokens()];
        this.shift = new boolean[stringTokenizer.countTokens()];
        this.keyCode = new int[stringTokenizer.countTokens()];
        int n = stringTokenizer.countTokens();
        int n2 = 0;
        while (n2 < n) {
            this.alt[n2] = false;
            this.ctrl[n2] = false;
            this.shift[n2] = false;
            this.keyCode[n2] = -1;
            String string2 = stringTokenizer.nextToken();
            StringInterpreter stringInterpreter = new StringInterpreter(string2);
            int n3 = 0;
            while (n3 < stringInterpreter.getValues()) {
                String string3 = stringInterpreter.getValueAt(n3);
                if (string3.length() == 1) {
                    if (!string3.toLowerCase().equals(string3)) {
                        this.shift[n2] = true;
                    }
                    this.keyCode[n2] = string3.toUpperCase().charAt(0);
                } else {
                    if ((string3 = string3.toLowerCase()).equals("shift")) {
                        this.shift[n2] = true;
                    }
                    if (string3.equals("alt")) {
                        this.alt[n2] = true;
                    }
                    if (string3.equals("ctrl")) {
                        this.ctrl[n2] = true;
                    }
                    if (string3.charAt(0) == 'f' & Character.isDigit(string3.charAt(1))) {
                        switch (Integer.parseInt(string3.substring(1))) {
                            case 1: {
                                this.keyCode[n2] = 112;
                                break;
                            }
                            case 2: {
                                this.keyCode[n2] = 113;
                                break;
                            }
                            case 3: {
                                this.keyCode[n2] = 114;
                                break;
                            }
                            case 4: {
                                this.keyCode[n2] = 115;
                                break;
                            }
                            case 5: {
                                this.keyCode[n2] = 116;
                                break;
                            }
                            case 6: {
                                this.keyCode[n2] = 117;
                                break;
                            }
                            case 7: {
                                this.keyCode[n2] = 118;
                                break;
                            }
                            case 8: {
                                this.keyCode[n2] = 119;
                                break;
                            }
                            case 9: {
                                this.keyCode[n2] = 120;
                                break;
                            }
                            case 10: {
                                this.keyCode[n2] = 121;
                                break;
                            }
                            case 11: {
                                this.keyCode[n2] = 122;
                                break;
                            }
                            case 12: {
                                this.keyCode[n2] = 123;
                            }
                        }
                    }
                    if (string3.equals("pgdn")) {
                        this.keyCode[n2] = 34;
                    }
                    if (string3.equals("esc")) {
                        this.keyCode[n2] = 27;
                    }
                    if (string3.equals("pgup")) {
                        this.keyCode[n2] = 33;
                    }
                    if (string3.equals("end")) {
                        this.keyCode[n2] = 35;
                    }
                    if (string3.equals("del")) {
                        this.keyCode[n2] = 127;
                    }
                    if (string3.equals("home")) {
                        this.keyCode[n2] = 36;
                    }
                    if (string3.equals("ins")) {
                        this.keyCode[n2] = 155;
                    }
                    if (string3.equals("left")) {
                        this.keyCode[n2] = 37;
                    }
                    if (string3.equals("right")) {
                        this.keyCode[n2] = 39;
                    }
                    if (string3.equals("up")) {
                        this.keyCode[n2] = 38;
                    }
                    if (string3.equals("down")) {
                        this.keyCode[n2] = 40;
                    }
                    if (string3.equals("enter")) {
                        this.keyCode[n2] = 10;
                    }
                    if (string3.equals("num0")) {
                        this.keyCode[n2] = 96;
                    }
                    if (string3.equals("num1")) {
                        this.keyCode[n2] = 97;
                    }
                    if (string3.equals("num2")) {
                        this.keyCode[n2] = 98;
                    }
                    if (string3.equals("num3")) {
                        this.keyCode[n2] = 99;
                    }
                    if (string3.equals("num4")) {
                        this.keyCode[n2] = 100;
                    }
                    if (string3.equals("num5")) {
                        this.keyCode[n2] = 101;
                    }
                    if (string3.equals("num6")) {
                        this.keyCode[n2] = 102;
                    }
                    if (string3.equals("num7")) {
                        this.keyCode[n2] = 103;
                    }
                    if (string3.equals("num8")) {
                        this.keyCode[n2] = 104;
                    }
                    if (string3.equals("num9")) {
                        this.keyCode[n2] = 105;
                    }
                    if (string3.equals("num*")) {
                        this.keyCode[n2] = 106;
                    }
                    if (string3.equals("num/")) {
                        this.keyCode[n2] = 111;
                    }
                    if (string3.equals("num+")) {
                        this.keyCode[n2] = 107;
                    }
                    if (string3.equals("num-")) {
                        this.keyCode[n2] = 109;
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    char ucase(char c) {
        if (c < '\u0000') {
            return '\u0000';
        }
        return Character.toUpperCase(c);
    }

    public boolean equals(KeyEvent keyEvent) {
        if (this.ctrl == null) {
            return false;
        }
        int n = 0;
        while (n < this.ctrl.length) {
            if ((this.ucase(keyEvent.getKeyChar()) == (char)this.keyCode[n] | keyEvent.getKeyCode() == this.keyCode[n]) & (!keyEvent.isShiftDown() ^ this.shift[n]) & (!keyEvent.isControlDown() ^ this.ctrl[n]) & (!keyEvent.isAltDown() ^ this.alt[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    String getCode(int n) {
        switch (this.keyCode[n]) {
            case -1: {
                return "";
            }
            case 155: {
                return "INS";
            }
            case 27: {
                return "ESC";
            }
            case 10: {
                return "RETURN";
            }
            case 34: {
                return "PGDN";
            }
            case 33: {
                return "PGUP";
            }
            case 127: {
                return "DEL";
            }
            case 36: {
                return "HOME";
            }
            case 35: {
                return "END";
            }
            case 38: {
                return "UP";
            }
            case 40: {
                return "DOWN";
            }
            case 37: {
                return "LEFT";
            }
            case 39: {
                return "RIGHT";
            }
            case 96: {
                return "NUM0";
            }
            case 97: {
                return "NUM1";
            }
            case 98: {
                return "NUM2";
            }
            case 99: {
                return "NUM3";
            }
            case 100: {
                return "NUM4";
            }
            case 101: {
                return "NUM5";
            }
            case 102: {
                return "NUM6";
            }
            case 103: {
                return "NUM7";
            }
            case 104: {
                return "NUM8";
            }
            case 105: {
                return "NUM9";
            }
            case 106: {
                return "NUM*";
            }
            case 111: {
                return "NUM/";
            }
            case 107: {
                return "NUM+";
            }
            case 109: {
                return "NUM-";
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: {
                return KeyEvent.getKeyText(this.keyCode[n]);
            }
        }
        return ("" + (char)this.keyCode[n]).toLowerCase();
    }

    public String toString() {
        if (this.ctrl == null) {
            return "";
        }
        String string = "";
        int n = 0;
        while (n < this.ctrl.length) {
            string = string + (n > 0 ? " " : "") + (this.alt[n] ? "alt;" : "") + (this.ctrl[n] ? "ctrl;" : "") + (this.shift[n] ? "shift;" : "") + this.getCode(n);
            ++n;
        }
        return string;
    }

    public String toBetterString() {
        if (this.ctrl == null) {
            return "";
        }
        String string = "";
        int n = 0;
        while (n < this.ctrl.length) {
            string = string + (n > 0 ? "   " : "") + (this.alt[n] ? "Alt+" : "") + (this.ctrl[n] ? "Ctrl+" : "") + (this.shift[n] ? "Shift+" : "") + KeyEvent.getKeyText(this.keyCode[n]);
            ++n;
        }
        return string;
    }
}

