/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.ExtGrid;
import auto.awt.ImageManager;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FilenameFilter;

public class ImageFileGrid
extends ExtGrid {
    Filter f = new Filter();
    String path = "";
    ImageLoadThread thread = null;
    Image dbImage;
    public int imageCount = 0;

    public Object getCell() {
        return ((ImgCell)super.getCell()).fn;
    }

    public int getCellHeight(FontMetrics fontMetrics) {
        return 50;
    }

    public ImageFileGrid() {
        this.setBackground(SystemColor.window);
        this.addCol();
        this.addCol();
    }

    public void setPath(String string) {
        this.clear();
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.stop();
        }
        if (System.getProperty("user.home").startsWith("/") & !string.startsWith("/")) {
            string = "/" + string;
        }
        this.path = string;
        String[] stringArray = new File(string).list(this.f);
        if (stringArray.length == 0) {
            this.setBackground(SystemColor.control);
        } else {
            this.setBackground(SystemColor.window);
        }
        this.imageCount = stringArray.length;
        this.processEvent(new ActionEvent(this, 0, "counted"));
        int n = 0;
        while (n < stringArray.length) {
            this.data(new ImgCell(stringArray[n]));
            ++n;
        }
        this.thread = new ImageLoadThread();
        this.thread.start();
        if (this.parentSP != null && this.parentSP.isShowing()) {
            this.parentSP.doLayout();
        }
    }

    public void update(Graphics graphics) {
        boolean bl = false;
        if (this.dbImage == null) {
            bl = true;
        } else if (this.dbImage.getWidth(this) != this.getSize().width | this.dbImage.getHeight(this) != this.getSize().height) {
            bl = true;
        }
        if (bl) {
            this.dbImage = this.createImage(this.getSize().width, this.getSize().height);
        }
        Graphics graphics2 = this.dbImage.getGraphics();
        graphics2.setColor(this.getBackground());
        graphics2.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics2.setColor(this.getForeground());
        this.paint(graphics2);
        graphics.drawImage(this.dbImage, 0, 0, this);
        graphics2.dispose();
    }

    public void drawCell(Object object, Graphics graphics, Rectangle rectangle, Point point, FontMetrics fontMetrics) {
        ImgCell imgCell = (ImgCell)object;
        if (imgCell.img != null) {
            graphics.drawImage(imgCell.img, rectangle.x + 1, rectangle.y + 1, rectangle.height - 2, rectangle.height - 2, this);
        }
        graphics.drawString(imgCell.fn, rectangle.x + rectangle.height + 5, rectangle.y + fontMetrics.getAscent());
    }

    class ImageLoadThread
    extends Thread {
        Point pos = new Point(0, 0);

        ImageLoadThread() {
        }

        public void run() {
            ImageFileGrid.this.processEvent(new ActionEvent(ImageFileGrid.this, 0, "start"));
            while (true) {
                ImgCell imgCell;
                if ((imgCell = (ImgCell)ImageFileGrid.this.getCell(this.pos.x, this.pos.y)) == null) break;
                imgCell.img = ImageManager.getImage(ImageFileGrid.this.path + "/" + imgCell.fn, ImageFileGrid.this, 5000);
                ImageFileGrid.this.repaint();
                ++this.pos.x;
                if (this.pos.x != ImageFileGrid.this.cols.size()) continue;
                this.pos.x = 0;
                ++this.pos.y;
            }
            ImageFileGrid.this.processEvent(new ActionEvent(ImageFileGrid.this, 0, "stop"));
        }
    }

    class ImgCell {
        Image img;
        String fn;

        public ImgCell(String string) {
            this.fn = string;
            this.img = null;
        }
    }

    class Filter
    implements FilenameFilter {
        Filter() {
        }

        public boolean accept(File file, String string) {
            if (string.toLowerCase().endsWith(".gif")) {
                return true;
            }
            return string.toLowerCase().endsWith(".jpg");
        }
    }
}

