/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.image.TgaConverter;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.FilteredImageSource;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Hashtable;

public final class ImagePool {
    Hashtable imgH = new Hashtable();
    Component co;

    public ImagePool(Component component) {
        this.co = component;
    }

    public static Image getResourceImage(String string, Component component) throws Exception {
        int n;
        Image image = null;
        InputStream inputStream = component.getClass().getResourceAsStream(string);
        if (string.endsWith("tga")) {
            return TgaConverter.load(inputStream, component);
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        byte[] byArray = new byte[50000];
        int n2 = 0;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) != -1) {
            n2 += n;
        }
        image = toolkit.createImage(byArray, 0, n2);
        while (!component.prepareImage(image, component)) {
            Thread.sleep(50L);
        }
        return image;
    }

    public Image getImg(String string, Component component) {
        return this.getImg(string, null, component);
    }

    public Image getImg(String string) {
        return this.getImg(string, null, null);
    }

    public Image getImg(String string, InputStream inputStream, Component component) {
        Image image = (Image)this.imgH.get(string);
        if (image == null) {
            block10: {
                if (inputStream != null) {
                    try {
                        int n;
                        if (string.endsWith(".tga")) {
                            image = TgaConverter.load(inputStream);
                            break block10;
                        }
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byte[] byArray = new byte[10000];
                        while ((n = inputStream.read(byArray)) >= 0) {
                            byteArrayOutputStream.write(byArray, 0, n);
                        }
                        byteArrayOutputStream.close();
                        byte[] byArray2 = byteArrayOutputStream.toByteArray();
                        image = Toolkit.getDefaultToolkit().createImage(byArray2, 0, byArray2.length);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    try {
                        image = ImagePool.getResourceImage("/" + string, component);
                    }
                    catch (Exception exception) {
                        image = Toolkit.getDefaultToolkit().getImage(string);
                    }
                }
            }
            if (component != null && !this.prepareImg(image, component)) {
                return null;
            }
            this.imgH.put(string, image);
        }
        return image;
    }

    boolean prepareImg(Image image, Component component) {
        int n = 50;
        int n2 = 0;
        while (!component.prepareImage(image, component)) {
            if ((n2 += n) > 5000) {
                return false;
            }
            try {
                Thread.sleep(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public Image getScaledImg(String string, Component component, float f) {
        String string2 = f + " &%\u00a7 " + string;
        Image image = (Image)this.imgH.get(string2);
        if (image != null) {
            return image;
        }
        image = this.getImg(string, null, component);
        if (f != 1.0f) {
            AreaAveragingScaleFilter areaAveragingScaleFilter = new AreaAveragingScaleFilter((int)((float)image.getWidth(component) * f), (int)((float)image.getHeight(component) * f));
            image = component.createImage(new FilteredImageSource(image.getSource(), areaAveragingScaleFilter));
            this.prepareImg(image, component);
        }
        this.imgH.put(string2, image);
        return image;
    }

    String keyScaledImg(String string, int n, int n2) {
        return n + " " + n2 + " &%\u00a7 " + string;
    }

    public Image getScaledImg(String string, Component component, int n, int n2) {
        String string2 = this.keyScaledImg(string, n, n2);
        Image image = (Image)this.imgH.get(string2);
        if (image != null) {
            return image;
        }
        image = this.getImg(string, null, component);
        if (image == null) {
            return null;
        }
        float f = (float)n / (float)image.getWidth(component);
        float f2 = (float)n2 / (float)image.getHeight(component);
        float f3 = Math.min(f, f2);
        AreaAveragingScaleFilter areaAveragingScaleFilter = new AreaAveragingScaleFilter((int)((float)image.getWidth(component) * f3), (int)((float)image.getHeight(component) * f3));
        Image image2 = component.createImage(new FilteredImageSource(image.getSource(), areaAveragingScaleFilter));
        if (!this.prepareImg(image2, component)) {
            return null;
        }
        image.flush();
        this.imgH.put(string2, image2);
        return image2;
    }

    public void flushScaledImage(String string, int n, int n2) {
        String string2 = this.keyScaledImg(string, n, n2);
        Image image = (Image)this.imgH.get(string2);
        if (image == null) {
            return;
        }
        this.imgH.remove(string2);
        image.flush();
    }
}

