/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.ComponentWatch;
import auto.awt.HotKey;
import auto.awt.KeyManagerAble;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;

public class KeyManager
extends ComponentWatch
implements KeyListener,
FocusListener {
    Component co = null;
    ActionListener actionListener;
    HotKey throwAction = new HotKey("ESC");
    boolean someWasPressed = false;
    boolean lightFlag;

    public KeyManager(Component component) {
        super(component);
        this.co = component;
    }

    public void register(Component component) {
        super.register(component);
    }

    public void deregister(Component component) {
        super.deregister(component);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed((ActionEvent)aWTEvent);
            }
            return;
        }
    }

    void checkHotKey(Component component, KeyEvent keyEvent) {
        Serializable serializable;
        if (component instanceof KeyManagerAble && (serializable = ((KeyManagerAble)((Object)component)).getHotKey()) != null && ((HotKey)serializable).equals(keyEvent)) {
            ((KeyManagerAble)((Object)component)).reactOnHotKey();
        }
        if (component instanceof Container) {
            serializable = (Container)component;
            int n = 0;
            while (n < ((Container)serializable).getComponentCount()) {
                this.checkHotKey(((Container)serializable).getComponent(n), keyEvent);
                ++n;
            }
        }
    }

    public void registerListeners(Component component) {
        component.addKeyListener(this);
        component.addFocusListener(this);
    }

    public void deregisterListeners(Component component) {
        component.removeKeyListener(this);
        component.removeFocusListener(this);
    }

    Component getFirstFocusComponent(Container container) {
        int n = 0;
        while (n < container.getComponentCount()) {
            Component component;
            Component component2 = container.getComponent(n);
            if (component2.isFocusTraversable()) {
                return component2;
            }
            if (component2 instanceof Container && (component = this.getFirstFocusComponent((Container)component2)) != null) {
                return component;
            }
            ++n;
        }
        return null;
    }

    public void focusGained(FocusEvent focusEvent) {
        Component component;
        if (focusEvent.getSource() instanceof Window && (component = this.getFirstFocusComponent((Container)focusEvent.getSource())) != null) {
            component.requestFocus();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.someWasPressed = true;
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.someWasPressed) {
            return;
        }
        this.someWasPressed = false;
        if (this.throwAction.equals(keyEvent)) {
            this.processEvent(new ActionEvent(this, 0, ""));
        }
        this.checkHotKey(this.co, keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

