/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.FocusDemon;
import auto.awt.MultiFrameAble;
import auto.awt.menu.MenuAble;
import java.awt.BorderLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;

public class MultiFrame
extends Frame
implements WindowListener,
ActionListener {
    Vector frames = new Vector();
    Vector entryC = new Vector();
    int index = -1;
    String waitS = "loading...";
    String sync = null;
    int maxEntries = 15;
    final String MF_ENTRY = "multiFrameEntry";
    final String MF_EXIT = "multiFrameExit";

    public MultiFrame(MultiFrameAble multiFrameAble) {
        this();
        this.addFrame(multiFrameAble);
    }

    public MultiFrame() {
        this.addWindowListener(this);
        this.setLayout(new BorderLayout());
        this.setBounds(50, 50, 600, 400);
        FocusDemon.register(this);
        this.setBackground(SystemColor.control);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exit();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void addFrame(MultiFrameAble multiFrameAble) {
        this.frames.addElement(multiFrameAble);
        this.entryC.addElement(new Integer(0));
        if (this.frames.size() == 1) {
            this.setFrame(0);
        } else {
            this.updateMenues();
        }
        MenuAble menuAble = multiFrameAble.getMenu();
        if (menuAble.exists("multiFrameExit")) {
            menuAble.addActionListener("multiFrameExit", this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("multiFrameExit")) {
            this.exit();
        }
        if (string.startsWith("multiFrameNr")) {
            this.setFrame(Integer.parseInt(string.substring(12)));
        }
        if (string.startsWith("multiFrameEntry")) {
            MultiFrameAble multiFrameAble = (MultiFrameAble)this.frames.elementAt(this.index);
            multiFrameAble.load((String)multiFrameAble.getEntries().elementAt(Integer.parseInt(string.substring("multiFrameEntry".length()))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void exit() {
        MultiFrameAble multiFrameAble;
        int n = 0;
        while (n < this.frames.size()) {
            multiFrameAble = (MultiFrameAble)this.frames.elementAt(n);
            if (n != this.index && !multiFrameAble.checkExitNotVisible()) {
                this.setFrame(n);
            }
            if (!multiFrameAble.checkExit()) {
                return;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.frames.size()) {
            multiFrameAble = (MultiFrameAble)this.frames.elementAt(n2);
            multiFrameAble.exit();
            ++n2;
        }
        this.setVisible(false);
        if (this.sync == null) {
            System.exit(0);
        } else {
            String string = this.sync;
            synchronized (string) {
                this.sync.notify();
            }
        }
    }

    public void manageEntry(String string) {
        MultiFrameAble multiFrameAble = (MultiFrameAble)this.frames.elementAt(this.index);
        Vector vector = multiFrameAble.getEntries();
        int n = vector.size() - 1;
        while (n >= 0) {
            if (vector.elementAt(n).equals(string)) {
                vector.removeElementAt(n);
            }
            --n;
        }
        vector.insertElementAt(string, 0);
        if (vector.size() > this.maxEntries) {
            vector.setSize(this.maxEntries);
        }
        this.checkEntryMenu();
    }

    void updateMenues() {
        MultiFrameAble multiFrameAble = (MultiFrameAble)this.frames.elementAt(this.index);
        MenuAble menuAble = multiFrameAble.getMenu();
        if (this.frames.size() == 1) {
            if (menuAble.exists("multiFrameMode")) {
                menuAble.setEnabled("multiFrameMode", false);
            }
        } else {
            int n = 0;
            while (n < this.frames.size()) {
                menuAble.removeActionListener("multiFrameNr" + n, this);
                ++n;
            }
            menuAble.removeAll("multiFrameMode");
            menuAble.selectItem("multiFrameMode");
            menuAble.setEnabled("multiFrameMode", true);
            int n2 = 0;
            while (n2 < this.frames.size()) {
                menuAble.addItem(this.frames.elementAt(n2).toString() + "," + "multiFrameNr" + n2 + ",ctrl;alt;F,," + (n2 == this.index ? "1" : "0"));
                menuAble.check("multiFrameNr" + n2, n2 == this.index);
                menuAble.addActionListener("multiFrameNr" + n2, this);
                ++n2;
            }
        }
        this.checkEntryMenu();
    }

    void checkEntryMenu() {
        MultiFrameAble multiFrameAble = (MultiFrameAble)this.frames.elementAt(this.index);
        MenuAble menuAble = multiFrameAble.getMenu();
        Vector vector = multiFrameAble.getEntries();
        if (vector != null) {
            int n;
            int n2 = (Integer)this.entryC.elementAt(this.index);
            if (n2 > 0) {
                menuAble.remove("multiFrameEntry");
                n = 0;
                while (n < n2) {
                    menuAble.removeActionListener("multiFrameEntry" + n, this);
                    menuAble.remove("multiFrameEntry" + n);
                    ++n;
                }
            }
            if (vector.size() > 0) {
                menuAble.selectItem("multiFrameEntries");
                menuAble.addItem("---,multiFrameEntry");
                n = 0;
                while (n < vector.size()) {
                    menuAble.addItem((n < 10 ? "&" + n + " " : "") + vector.elementAt(n) + "," + "multiFrameEntry" + n);
                    menuAble.addActionListener("multiFrameEntry" + n, this);
                    ++n;
                }
                this.entryC.setElementAt(new Integer(vector.size()), this.index);
            }
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Insets insets = this.getInsets();
        graphics.drawString(this.waitS, (this.getSize().width - fontMetrics.stringWidth(this.waitS)) / 2, insets.top + (this.getSize().height - insets.top - insets.bottom + fontMetrics.getAscent() - fontMetrics.getHeight()) / 2);
    }

    public void setFrame(int n) {
        MultiFrameAble multiFrameAble = null;
        if (this.index != -1) {
            multiFrameAble = (MultiFrameAble)this.frames.elementAt(this.index);
        }
        if (multiFrameAble != null && multiFrameAble.getMenu() != null) {
            multiFrameAble.getMenu().removeFromFrame(this);
        }
        this.removeAll();
        this.index = n;
        multiFrameAble = (MultiFrameAble)this.frames.elementAt(n);
        this.add(multiFrameAble.getComponent(), "Center");
        this.updateMenues();
        multiFrameAble.updateTitle();
        if (multiFrameAble.getMenu() != null) {
            multiFrameAble.getMenu().addToFrame(this);
        }
        if (this.isShowing()) {
            this.invalidate();
            this.validate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doIt() {
        String string = this.sync = "sync";
        synchronized (string) {
            try {
                this.sync.wait();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

