/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.ColorDialog;
import auto.awt.DataTextField;
import auto.awt.ExtGrid;
import auto.awt.ImageBrowser;
import auto.awt.TreeGrid;
import auto.awt.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Hashtable;

public class OptionGrid
extends TreeGrid {
    TreeGrid.Node currNode;
    public static final int BOOLEAN_OPTION = 0;
    public static final int STRING_OPTION = 1;
    public static final int CHOICE_OPTION = 2;
    public static final int FILE_OPTION = 3;
    public static final int IMAGEFILE_OPTION = 4;
    public static final int COLOR_OPTION = 5;
    Dimension boxDim;
    String dtfText;
    OptionNode lastDtfNode;
    OptionNode lastChanged;
    Hashtable nodes;
    public boolean startOpen;
    int hx;
    int hy;

    public OptionGrid() {
        this.currNode = this.mainNode;
        this.boxDim = new Dimension(13, 13);
        this.dtfText = "   ";
        this.nodes = new Hashtable();
        this.startOpen = true;
    }

    public void openGroup(String string) {
        TreeGrid.Node node = new TreeGrid.Node(this, string);
        this.currNode.add(node);
        this.currNode = node;
        this.currNode.open = this.startOpen;
    }

    public void doAction() {
        this.editNode((TreeGrid.Node)((ExtGrid.GridCol)this.cols.elementAt((int)0)).data.elementAt(this.cursor.y));
    }

    void fromTextField(int n) {
        this.requestFocus();
        if (n != 0) {
            this.moveCursor(0, n);
        }
    }

    void textFieldLeft() {
        OptionNode optionNode = this.lastDtfNode;
        optionNode.dtf.setVisible(false);
        optionNode.value = optionNode.dtf.getText();
        this.lastChanged = optionNode;
        this.processEvent(new ActionEvent(this, 0, optionNode.kurz));
    }

    void openNode(TreeGrid.Node node) {
        super.openNode(node);
        if (node.open & node.sub != null && this.isShowing()) {
            OptionNode optionNode;
            int n = -1;
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n2 = 0;
            while (n2 < node.sub.size()) {
                if (node.sub.elementAt(n2) instanceof OptionNode) {
                    int n3;
                    optionNode = (OptionNode)node.sub.elementAt(n2);
                    if (optionNode.typ == 1 && (n3 = fontMetrics.stringWidth(optionNode.name.toString())) > n) {
                        n = n3;
                    }
                }
                ++n2;
            }
            if (n > 0) {
                n += fontMetrics.stringWidth(this.dtfText);
                int n4 = 0;
                while (n4 < node.sub.size()) {
                    if (node.sub.elementAt(n4) instanceof OptionNode) {
                        optionNode = (OptionNode)node.sub.elementAt(n4);
                        if (optionNode.typ == 1) {
                            optionNode.dtfPos = n;
                        }
                    }
                    ++n4;
                }
            }
        }
    }

    void spacePressed() {
        this.doAction();
    }

    void editNode(TreeGrid.Node node) {
        if (node instanceof OptionNode) {
            OptionNode optionNode;
            this.lastChanged = optionNode = (OptionNode)node;
            switch (optionNode.typ) {
                case 4: {
                    String string = ImageBrowser.process((Frame)Utils.getStaticFrame(), null);
                    if (string == null) break;
                    optionNode.value = Utils.relativePath(string);
                    this.processEvent(new ActionEvent(this, 0, "check"));
                    this.repaint();
                    break;
                }
                case 3: {
                    String string = Utils.loadDlg(Utils.getStaticFrame(), optionNode.name.toString(), "");
                    String string2 = optionNode.value = string != null ? Utils.relativePath(string) : optionNode.value;
                    if (string == null) break;
                    this.processEvent(new ActionEvent(this, 0, "check"));
                    this.repaint();
                    break;
                }
                case 5: {
                    optionNode.cValue = ColorDialog.process(Utils.getParentFrame(this), optionNode.cValue);
                    this.processEvent(new ActionEvent(this, 0, "check"));
                    this.repaint();
                    break;
                }
                case 0: {
                    if (optionNode.typO.length() > 0) {
                        Enumeration enumeration = this.nodes.elements();
                        while (enumeration.hasMoreElements()) {
                            OptionNode optionNode2 = (OptionNode)enumeration.nextElement();
                            if (!optionNode.typO.equals(optionNode2.typO)) continue;
                            optionNode2.value = "0";
                        }
                        optionNode.value = "1";
                    } else {
                        optionNode.value = optionNode.value.charAt(0) == '0' ? "1" : "0";
                    }
                    this.processEvent(new ActionEvent(this, 0, "check"));
                    this.repaint();
                    break;
                }
                case 1: {
                    optionNode.dtf.setLocation(node.tiefe * this.left + this.left + optionNode.dtfPos, this.cursor.y * this.getCellHeight());
                    optionNode.dtf.setVisible(true);
                    optionNode.dtf.requestFocus();
                    this.lastDtfNode = optionNode;
                }
            }
        }
    }

    public void addOption(String string, boolean bl) {
        this.addOption(string, string, 0, bl ? "1" : "0", null);
    }

    public void addOption(String string, boolean bl, String string2) {
        this.addOption(string, string, 0, bl ? "1" : "0", string2);
    }

    public void addOption(String string, String string2, boolean bl) {
        this.addOption(string, string2, 0, bl ? "1" : "0", null);
    }

    public void addOption(String string, int n) {
        this.addOption(string, string, 1, String.valueOf(n), "numeric");
    }

    public void addOption(String string, String string2, int n) {
        this.addOption(string, string2, 1, String.valueOf(n), "numeric");
    }

    public void addOption(String string, String string2) {
        this.addOption(string, string, 1, string2, null);
    }

    public void addOption(String string, String string2, String string3) {
        this.addOption(string, string, 1, string2, string3);
    }

    public void addOption(String string, String string2, String string3, String string4) {
        this.addOption(string, string2, 1, string3, string4);
    }

    public void addOption(String string, int n, String string2, String string3) {
        this.addOption(string, string, n, string2, string3);
    }

    public void addOption(String string, String string2, int n, String string3, String string4) {
        OptionNode optionNode = new OptionNode(string, string2, n, string3, string4);
        this.currNode.add(optionNode);
        this.nodes.put(string, optionNode);
    }

    public void addOption(String string, String string2, Color color) {
        OptionNode optionNode = new OptionNode(string, string2, color);
        this.currNode.add(optionNode);
        this.nodes.put(string, optionNode);
    }

    String getKey(Hashtable hashtable, Object object) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (hashtable.get(string) != object) continue;
            return string;
        }
        return null;
    }

    public String choiceValue(String string) {
        Enumeration enumeration = this.nodes.elements();
        while (enumeration.hasMoreElements()) {
            OptionNode optionNode = (OptionNode)enumeration.nextElement();
            if (optionNode.typ != 0 || !optionNode.typO.equals(string) || optionNode.value.charAt(0) != '1') continue;
            return this.getKey(this.nodes, optionNode);
        }
        return null;
    }

    public String stringValue(String string) {
        return ((OptionNode)this.nodes.get((Object)string)).value;
    }

    public int intValue(String string) {
        return Integer.parseInt(this.stringValue(string));
    }

    public float floatValue(String string) {
        return new Float(this.stringValue(string)).floatValue();
    }

    public boolean booleanValue(String string) {
        return this.stringValue(string).charAt(0) == '1';
    }

    public Color colorValue(String string) {
        return ((OptionNode)this.nodes.get((Object)string)).cValue;
    }

    public void setValue(String string, String string2) {
        OptionNode optionNode = (OptionNode)this.nodes.get(string);
        optionNode.value = string2;
        switch (optionNode.typ) {
            case 1: {
                optionNode.dtf.setText(string2);
            }
        }
        this.repaint();
    }

    public String getLastChanged() {
        return Utils.getHashKey(this.lastChanged, this.nodes);
    }

    public void closeGroup() {
        this.currNode = this.currNode.papi;
    }

    public void clearTree() {
        super.clearTree();
        this.nodes.clear();
    }

    public void drawCell(Object object, Graphics graphics, Rectangle rectangle, Point point, FontMetrics fontMetrics) {
        this.hn = (TreeGrid.Node)object;
        this.drawLines(this.hn, graphics, rectangle, fontMetrics);
        if (this.hn instanceof OptionNode) {
            OptionNode optionNode = (OptionNode)this.hn;
            this.hx = rectangle.x + this.hn.tiefe * this.left + this.left;
            switch (optionNode.typ) {
                case 3: 
                case 4: {
                    this.hy = rectangle.y + rectangle.height / 2;
                    graphics.setColor(this.getBackground().brighter());
                    Polygon polygon = new Polygon();
                    polygon.addPoint(-4, -5);
                    polygon.addPoint(0, -5);
                    polygon.addPoint(0, -4);
                    polygon.addPoint(4, -4);
                    polygon.addPoint(4, 4);
                    polygon.addPoint(-4, 4);
                    polygon.translate(this.hx + 8, this.hy);
                    graphics.setColor(Color.yellow);
                    graphics.fillPolygon(polygon);
                    graphics.setColor(this.getForeground());
                    graphics.drawPolygon(polygon);
                    graphics.drawString(this.hn.name + "   " + optionNode.value, this.hx + 6 + this.boxDim.width, rectangle.y + fontMetrics.getAscent());
                    if (!(this.cursor.equals(point) & this.hasFocus)) break;
                    Utils.drawZebraRect(graphics, this.hx + 5 + this.boxDim.width, rectangle.y, fontMetrics.stringWidth(this.hn.name + "   " + optionNode.value) + 2, fontMetrics.getHeight() - 1);
                    break;
                }
                case 5: {
                    graphics.drawString(this.hn.name.toString(), this.hx + 1, rectangle.y + fontMetrics.getAscent());
                    if (this.cursor.equals(point) & this.hasFocus) {
                        Utils.drawZebraRect(graphics, this.hx, rectangle.y, fontMetrics.stringWidth(this.hn.name.toString()) + 6, fontMetrics.getHeight() - 1);
                    }
                    this.hx += fontMetrics.stringWidth(this.hn.name.toString()) + 6;
                    graphics.drawRect(this.hx, rectangle.y, fontMetrics.getHeight() * 3, fontMetrics.getHeight() - 1);
                    graphics.setColor(((OptionNode)this.hn).cValue);
                    graphics.fillRect(this.hx + 1, rectangle.y + 1, fontMetrics.getHeight() * 3 - 1, fontMetrics.getHeight() - 2);
                    break;
                }
                case 0: {
                    this.hy = rectangle.y + rectangle.height / 2 - this.boxDim.height / 2;
                    if (optionNode.typO.length() == 0) {
                        graphics.setColor(this.getBackground().brighter());
                        graphics.fillRect(this.hx + 3, this.hy, this.boxDim.width, this.boxDim.height);
                        Utils.draw3DRect(graphics, new Rectangle(this.hx + 3, this.hy, this.boxDim.width, this.boxDim.height), this.getBackground(), true);
                        if (optionNode.value.charAt(0) == '1') {
                            graphics.setColor(this.getForeground());
                            int n = 1;
                            while (n < 4) {
                                graphics.drawLine(this.hx + 2 + 4, this.hy - 2 + 5 + n, this.hx + 2 + 6, this.hy - 2 + 7 + n);
                                graphics.drawLine(this.hx + 2 + 6, this.hy - 2 + 7 + n, this.hx + 2 + 10, this.hy - 2 + 3 + n);
                                ++n;
                            }
                        }
                    } else {
                        int n = this.hx;
                        int n2 = this.hy;
                        graphics.setColor(Color.black);
                        graphics.drawArc(n + 1, n2 + 1, this.boxDim.width - 2, this.boxDim.height - 2, 225, -180);
                        graphics.setColor(this.getBackground().darker());
                        graphics.drawArc(n, n2, this.boxDim.width, this.boxDim.height, 225, -180);
                        graphics.setColor(this.getBackground());
                        graphics.drawArc(n + 1, n2 + 1, this.boxDim.width - 2, this.boxDim.height - 2, 225, 180);
                        graphics.setColor(this.getBackground().brighter());
                        graphics.drawArc(n, n2, this.boxDim.width, this.boxDim.height, 225, 180);
                        graphics.setColor(this.getBackground().brighter());
                        graphics.fillArc(n + 2, n2 + 2, this.boxDim.width - 4, this.boxDim.height - 4, 0, 360);
                        if (optionNode.value.charAt(0) == '1') {
                            graphics.setColor(this.getForeground());
                            graphics.fillArc(n + 4, n2 + 4, this.boxDim.width - 8, this.boxDim.height - 8, 0, 360);
                        }
                    }
                    graphics.setColor(this.getForeground());
                    graphics.drawString(this.hn.name.toString(), this.hx + 6 + this.boxDim.width, rectangle.y + fontMetrics.getAscent());
                    if (!(this.cursor.equals(point) & this.hasFocus)) break;
                    Utils.drawZebraRect(graphics, this.hx + 5 + this.boxDim.width, rectangle.y, fontMetrics.stringWidth(this.hn.name.toString()) + 2, fontMetrics.getHeight() - 1);
                    break;
                }
                case 1: {
                    graphics.drawString(this.hn.name + this.dtfText, this.hx + 1, rectangle.y + fontMetrics.getAscent());
                    if (this.cursor.equals(point) & this.hasFocus) {
                        Utils.drawZebraRect(graphics, this.hx, rectangle.y, fontMetrics.stringWidth(this.hn.name.toString()) + 6, fontMetrics.getHeight() - 1);
                    }
                    if (optionNode.dtfPos < 0) {
                        optionNode.dtfPos = 3 + fontMetrics.stringWidth(optionNode.name + this.dtfText);
                    }
                    this.hx += optionNode.dtfPos;
                    optionNode.dtf.setSize(fontMetrics.getHeight() * 7, fontMetrics.getHeight());
                    Shape shape = graphics.getClip();
                    graphics.translate(this.hx, rectangle.y);
                    optionNode.dtf.paint(graphics);
                    graphics.translate(-this.hx, -rectangle.y);
                    graphics.setClip(shape);
                }
            }
        } else {
            graphics.drawString(this.hn.name.toString(), rectangle.x + this.hn.tiefe * this.left + this.left + 3, rectangle.y + fontMetrics.getAscent());
            if (this.cursor.equals(point) & this.hasFocus) {
                Utils.drawZebraRect(graphics, rectangle.x + this.hn.tiefe * this.left + this.left + 1, rectangle.y, fontMetrics.stringWidth(this.hn.name.toString()) + 4, fontMetrics.getHeight() - 1);
            }
        }
    }

    public static void main(String[] stringArray) {
        OptionGrid optionGrid = new OptionGrid();
        Frame frame = Utils.mainFrame(optionGrid.withScrollPane(), false);
        optionGrid.openGroup("test");
        optionGrid.addOption("subtest", "hjhjh");
        optionGrid.closeGroup();
        optionGrid.openGroup("Optionen 1");
        optionGrid.openGroup("Optionen 2");
        optionGrid.openGroup("Optionen 3");
        optionGrid.closeGroup();
        optionGrid.closeGroup();
        optionGrid.addOption("datei:", 3, "datei.txt", null);
        optionGrid.addOption("bild:", 4, "datei.txt", null);
        optionGrid.addOption("neues Layout", 0, "1", null);
        optionGrid.addOption("Linie nach 80ster Zeile zeichnen", 0, "0", null);
        optionGrid.addOption("farb", "Farbe1:", Color.red);
        optionGrid.openGroup("Tastatur");
        optionGrid.addOption("Ende", 1, "ctrl;e", null);
        optionGrid.addOption("Editieren", 1, "ctrl;p,g", null);
        optionGrid.closeGroup();
        optionGrid.openGroup("Optionen 2");
        optionGrid.openGroup("3 arten");
        optionGrid.addOption("neu", 0, "1", "1");
        optionGrid.addOption("mittel", 0, "0", "1");
        optionGrid.addOption("alt", 0, "0", "1");
        optionGrid.closeGroup();
        optionGrid.calcStruktur();
        frame.show();
    }

    class GridField
    extends DataTextField {
        GridField() {
            super("", 30);
            this.addKeyListener(new KeyLis());
            this.addFocusListener(new FocLis());
        }

        class KeyLis
        extends KeyAdapter {
            KeyLis() {
            }

            public void keyReleased(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 38: {
                        OptionGrid.this.fromTextField(-1);
                        break;
                    }
                    case 40: {
                        OptionGrid.this.fromTextField(1);
                        break;
                    }
                    case 10: {
                        OptionGrid.this.fromTextField(0);
                    }
                }
            }
        }

        class FocLis
        implements FocusListener {
            FocLis() {
            }

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                OptionGrid.this.textFieldLeft();
            }
        }
    }

    class OptionNode
    extends TreeGrid.Node {
        int typ;
        String value;
        Color cValue;
        GridField dtf = null;
        int dtfPos = -1;
        String typO = "";
        String kurz;

        OptionNode(String string, String string2, Color color) {
            super(OptionGrid.this, string2);
            this.typ = 5;
            this.cValue = color;
            this.kurz = string;
        }

        OptionNode(String string, String string2, int n, String string3, String string4) {
            super(OptionGrid.this, string2);
            this.kurz = string;
            this.typ = n;
            String string5 = this.typO = string4 == null ? "" : string4;
            if (this.typ == 1) {
                this.dtf = new GridField();
                this.dtf.setText(string3);
                this.dtf.thinBorder = true;
                this.dtf.setText(string3);
                this.dtf.setVisible(false);
                OptionGrid.this.add(this.dtf);
            }
            this.value = string3;
        }
    }
}

