/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.DiaAble;
import auto.awt.ExtGrid;
import auto.awt.HotKey;
import auto.awt.Utils;
import auto.util.VectorTree;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class TreeGrid
extends ExtGrid
implements DiaAble {
    public boolean openOnStart = true;
    public Node mainNode;
    Node currNode = this.mainNode = new Node("Haupt");
    boolean selected = false;
    Vector lines = new Vector();
    Node lastNode = null;
    Node hn;
    int left = 10;
    int leftHalb = this.left / 2;
    Point hp = new Point(0, 0);

    public String getValue() {
        return "";
    }

    public void setValue(String string) {
    }

    public void setSelect(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    public String getOwnMenu() {
        return null;
    }

    public void reactOnHotKey() {
    }

    public void setHotKey(HotKey hotKey) {
    }

    public HotKey getHotKey() {
        return null;
    }

    public String getCaption() {
        return "";
    }

    public void setCaption(String string) {
    }

    public String getOptions() {
        return "";
    }

    public void setOptions(String string) {
    }

    public Object getObject() {
        return ((Node)this.getCell()).name;
    }

    public TreeGrid() {
        this.setBackground(SystemColor.window);
        this.setCursor(new Cursor(0));
        this.normCursor = false;
        this.colWidth = 50;
        this.addCol();
        this.mainNode.sub = new Vector();
        this.calcStruktur();
    }

    void calc(Node node, int n) {
        int n2 = 0;
        while (n2 < node.sub.size()) {
            Node node2 = (Node)node.sub.elementAt(n2);
            node2.tiefe = n;
            node2.last = n2 == node.sub.size() - 1;
            node2.lines.setSize(0);
            int n3 = 0;
            while (n3 < this.lines.size()) {
                node2.lines.addElement(this.lines.elementAt(n3));
                ++n3;
            }
            this.data(node2);
            int n4 = 0;
            while (n4 < this.cols.size() - 1) {
                this.data(node2);
                ++n4;
            }
            if (node2.sub != null & node2.open) {
                if (n2 < node.sub.size() - 1) {
                    this.lines.addElement(new Integer(n));
                }
                this.calc(node2, n + 1);
                if (n2 < node.sub.size() - 1) {
                    this.lines.removeElementAt(this.lines.size() - 1);
                }
            }
            ++n2;
        }
    }

    public void openGroup(Object object) {
        Node node = new Node(object);
        this.currNode.add(node);
        this.currNode = node;
        this.lastNode = node;
        this.currNode.open = this.openOnStart;
    }

    public void closeGroup() {
        this.currNode = this.currNode.papi;
    }

    public void addNode(String string, String string2) {
        this.addNode(new StringPair(string, string2));
    }

    public void addNode(Object object) {
        this.lastNode = new Node(object);
        this.currNode.add(this.lastNode);
    }

    public void clearTree() {
        this.mainNode.sub.setSize(0);
        this.currNode = this.mainNode;
    }

    public void doAction() {
        Object object = ((Node)this.getCell()).name;
        if (object instanceof StringPair) {
            object = ((StringPair)object).ret;
        }
        this.processEvent(new ActionEvent(this, 0, object.toString()));
    }

    public void calcStruktur() {
        this.clear();
        this.lines.setSize(0);
        this.calc(this.mainNode, 0);
        this.checkScrollers();
        this.invalidate();
    }

    void setCursor(Node node) {
        ExtGrid.GridCol gridCol = (ExtGrid.GridCol)this.cols.elementAt(0);
        int n = 0;
        while (n < gridCol.data.size()) {
            if (gridCol.data.elementAt(n) == node) {
                this.cursor.y = n;
            }
            ++n;
        }
    }

    public void openAll() {
        this.openAll(this.mainNode);
    }

    public void openAll(Node node) {
        if (node.sub == null) {
            return;
        }
        if (!node.open) {
            this.openNode(node);
        }
        int n = 0;
        while (n < node.sub.size()) {
            this.openAll((Node)node.sub.elementAt(n));
            ++n;
        }
    }

    void mousePressed(Object object, int n, int n2, MouseEvent mouseEvent) {
        super.mousePressed(object, n, n2, mouseEvent);
        Node node = (Node)object;
        if (new Rectangle(node.tiefe * this.left + 2, this.getFontMetrics(this.getFont()).getHeight() / 2 - this.leftHalb + 1, this.leftHalb * 2 - 2, this.leftHalb * 2 - 2).contains(new Point(n, n2))) {
            this.openNodeCalcStruktur(node);
        } else {
            this.clickNode(node);
        }
    }

    public void keyPressed(Object object, KeyEvent keyEvent) {
        Node node = (Node)object;
        switch (keyEvent.getKeyChar()) {
            case '+': {
                if (node.open) break;
                this.openNodeCalcStruktur(node);
                break;
            }
            case '-': {
                if (!node.open) break;
                this.openNodeCalcStruktur(node);
                break;
            }
            case '\n': 
            case ' ': {
                this.openNodeCalcStruktur(node);
            }
        }
    }

    protected void nodeOpened(Node node) {
    }

    void openNodeCalcStruktur(Node node) {
        this.openNode(node);
        int n = this.cursor.y;
        if (node.open) {
            this.currNode = node;
            this.nodeOpened(node);
        }
        this.calcStruktur();
        this.cursor.y = n;
        this.setCursor(node);
        this.repaint();
    }

    void openNode(Node node) {
        node.open = !node.open;
    }

    void clickNode(Node node) {
    }

    void drawLines(Node node, Graphics graphics, Rectangle rectangle, FontMetrics fontMetrics) {
        this.hp.x = rectangle.x + node.tiefe * this.left + this.leftHalb;
        this.hp.y = rectangle.y + fontMetrics.getHeight() / 2;
        int n = 0;
        while (n < node.lines.size()) {
            int n2 = (Integer)node.lines.elementAt(n);
            Utils.drawZebraLine(graphics, rectangle.x + n2 * this.left + this.leftHalb, rectangle.y, 1, fontMetrics.getHeight(), false);
            ++n;
        }
        Utils.drawZebraLine(graphics, this.hp.x, rectangle.y, 1, node.last ? fontMetrics.getHeight() / 2 : fontMetrics.getHeight(), false);
        Utils.drawZebraLine(graphics, this.hp.x, this.hp.y, this.leftHalb, 1, true);
        if (node.sub != null) {
            graphics.setColor(Color.white);
            graphics.fillRect(this.hp.x - this.leftHalb + 1, this.hp.y - this.leftHalb + 1, this.leftHalb * 2 - 2, this.leftHalb * 2 - 2);
            graphics.setColor(Color.black);
            graphics.drawRect(this.hp.x - this.leftHalb + 1, this.hp.y - this.leftHalb + 1, this.leftHalb * 2 - 2, this.leftHalb * 2 - 2);
            graphics.fillRect(this.hp.x - this.leftHalb + 3, this.hp.y, this.leftHalb * 2 - 5, 1);
            if (!node.open) {
                graphics.fillRect(this.hp.x, this.hp.y - this.leftHalb + 3, 1, this.leftHalb * 2 - 5);
            }
        }
    }

    public int depth(Node node) {
        int n = 0;
        while (node != this.mainNode) {
            node = node.papi;
            ++n;
        }
        return n;
    }

    public void drawCell(Object object, Graphics graphics, Rectangle rectangle, Point point, FontMetrics fontMetrics) {
        this.hn = (Node)object;
        this.drawLines(this.hn, graphics, rectangle, fontMetrics);
        graphics.setColor(this.getForeground());
        graphics.drawString(this.hn.name.toString(), rectangle.x + this.hn.tiefe * this.left + this.left + 3, rectangle.y + fontMetrics.getAscent());
        if (this.cursor.equals(point) & this.hasFocus) {
            Utils.drawZebraRect(graphics, rectangle.x + this.hn.tiefe * this.left + this.left + 1, rectangle.y, fontMetrics.stringWidth(this.hn.name.toString()) + 4, fontMetrics.getHeight() - 1);
        }
    }

    static void fillTg(Vector vector, TreeGrid treeGrid) {
        boolean bl = true;
        if (vector.size() == 0) {
            bl = false;
        } else if (vector.firstElement() instanceof Vector) {
            bl = false;
        }
        treeGrid.openGroup(bl ? vector.firstElement() : "");
        int n = bl ? 1 : 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof Vector) {
                TreeGrid.fillTg((Vector)e, treeGrid);
            } else {
                treeGrid.lastNode.name = treeGrid.lastNode.name + " " + e;
            }
            ++n;
        }
        treeGrid.closeGroup();
    }

    public static void main(String[] stringArray) {
        TreeGrid treeGrid = new TreeGrid();
        treeGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println(actionEvent);
            }
        });
        Frame frame = Utils.mainFrame(treeGrid.withScrollPane(), false);
        Vector vector = VectorTree.initNumbers((Vector)VectorTree.readFile((String)"data/test/ups.txt", (char)'(', (char)')', (boolean)true), (boolean)false);
        TreeGrid.fillTg(vector, treeGrid);
        treeGrid.calcStruktur();
        frame.show();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.selected) {
            Utils.drawSelectMarks(this, graphics);
        }
    }

    class StringPair {
        String titel;
        String ret;

        public StringPair(String string, String string2) {
            this.titel = string;
            this.ret = string2;
        }

        public String toString() {
            return this.titel;
        }
    }

    public class Node {
        public Object name = "";
        boolean open = false;
        public Vector sub = null;
        int tiefe;
        boolean last;
        Vector lines = new Vector();
        public Node papi = null;

        public Node(Object object) {
            this.name = object;
        }

        public void add(Node node) {
            if (this.sub == null) {
                this.sub = new Vector();
            }
            this.sub.addElement(node);
            node.papi = this;
        }
    }
}

