/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class TwoPanel
extends Container
implements MouseListener,
MouseMotionListener {
    public double zpro = 75.0;
    int zwidth = 10;
    int zmouse;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int typ = 0;
    Component co1 = null;
    Component co2 = null;
    Rectangle[] rec;
    Cursor wResizeCursor = new Cursor(10);
    Cursor nResizeCursor = new Cursor(8);
    Cursor defaultCursor = new Cursor(0);
    int down = -1;

    public TwoPanel() {
        this(0);
    }

    int proToAbs() {
        return (int)(this.zpro * (double)((this.typ == 0 ? this.getSize().height : this.getSize().width) - this.zwidth) / 100.0);
    }

    double absToPro(int n) {
        return (double)(100 * n) / (double)((this.typ == 0 ? this.getSize().height : this.getSize().width) - this.zwidth);
    }

    public TwoPanel(int n) {
        this.typ = n;
        if (this.typ == 1) {
            this.zpro = 50.0;
        }
        this.setLayout(null);
        this.setBackground(SystemColor.control);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(this.nResizeCursor);
        this.rec = new Rectangle[3];
        this.rec[0] = new Rectangle(0, 0, 10, 10);
        this.rec[1] = new Rectangle(0, 0, 10, 10);
        this.rec[2] = new Rectangle(0, 0, 10, 10);
    }

    public void invalidate() {
        super.invalidate();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = this.proToAbs();
        this.zmouse = n - (this.typ == 0 ? mouseEvent.getY() : mouseEvent.getX());
        int n2 = 0;
        while (n2 < this.rec.length) {
            if (this.rec[n2].contains(mouseEvent.getPoint())) {
                this.down = n2;
                this.repaint();
            }
            ++n2;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.down != -1) {
            this.zpro = this.down * 50;
            this.doLayout();
            this.validate();
        }
        this.down = -1;
        this.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setCursor(this.defaultCursor);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        boolean bl = false;
        int n = 0;
        while (n < this.rec.length) {
            if (this.rec[n].contains(mouseEvent.getPoint())) {
                bl = true;
            }
            ++n;
        }
        if (this.getComponentCount() < 2) {
            bl = true;
        } else if ((this.typ == 0 ? mouseEvent.getY() : mouseEvent.getX()) < (this.typ == 0 ? this.rec[0].y : this.rec[0].x) | (this.typ == 0 ? mouseEvent.getY() : mouseEvent.getX()) > (this.typ == 0 ? this.rec[0].y + this.rec[0].height : this.rec[0].x + this.rec[0].width)) {
            bl = true;
        }
        if (bl) {
            if (this.getCursor() != this.defaultCursor) {
                this.setCursor(this.defaultCursor);
            }
        } else {
            switch (this.typ) {
                case 0: {
                    if (this.getCursor() == this.nResizeCursor) break;
                    this.setCursor(this.nResizeCursor);
                    break;
                }
                case 1: {
                    if (this.getCursor() == this.wResizeCursor) break;
                    this.setCursor(this.wResizeCursor);
                }
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = this.down;
        this.down = -1;
        int n2 = 0;
        while (n2 < this.rec.length) {
            if (this.rec[n2].contains(mouseEvent.getPoint())) {
                this.down = n2;
            }
            ++n2;
        }
        if (this.down != n) {
            this.repaint();
        }
        if (this.down != -1) {
            return;
        }
        int n3 = this.zmouse + (this.typ == 0 ? mouseEvent.getY() : mouseEvent.getX());
        if (n3 < 30) {
            n3 = 0;
        }
        if ((this.typ == 0 ? this.getSize().height : this.getSize().width) - (n3 + this.zwidth) < 30) {
            n3 = (this.typ == 0 ? this.getSize().height : this.getSize().width) - this.zwidth;
        }
        this.zpro = this.absToPro(n3);
        this.doLayout();
        this.validate();
    }

    public void setComponents(Component component, Component component2) {
        int n = this.getComponentCount();
        this.removeAll();
        if (component != null) {
            this.add(component);
        }
        if (component2 != null) {
            this.add(component2);
        }
        this.co1 = component;
        this.co2 = component2;
        if (n != this.getComponentCount()) {
            if (!this.isShowing()) {
                this.invalidate();
            } else {
                this.doLayout();
                this.validate();
            }
        }
    }

    public void doLayout() {
        int n = this.proToAbs();
        int n2 = 20;
        switch (this.typ) {
            case 0: {
                int n3 = this.getSize().width / 2 - n2 * 3 / 2;
                int n4 = 0;
                while (n4 < this.rec.length) {
                    this.rec[n4].x = n3;
                    this.rec[n4].y = n;
                    this.rec[n4].width = n2;
                    this.rec[n4].height = this.zwidth;
                    n3 += n2;
                    ++n4;
                }
                break;
            }
            case 1: {
                int n5 = this.getSize().height / 2 - n2 * 3 / 2;
                int n6 = 0;
                while (n6 < this.rec.length) {
                    this.rec[n6].x = n;
                    this.rec[n6].y = n5;
                    this.rec[n6].width = this.zwidth;
                    this.rec[n6].height = n2;
                    n5 += n2;
                    ++n6;
                }
                break;
            }
        }
        if (this.co1 != null & this.co2 != null) {
            switch (this.typ) {
                case 0: {
                    this.co1.setBounds(0, 0, this.getSize().width, n);
                    this.co2.setBounds(0, n + this.zwidth - 1, this.getSize().width, this.getSize().height - this.zwidth - n);
                    break;
                }
                case 1: {
                    this.co1.setBounds(0, 0, n, this.getSize().height);
                    this.co2.setBounds(n + this.zwidth, 0, this.getSize().width - this.zwidth - n, this.getSize().height);
                }
            }
            return;
        }
        if (this.co1 != null) {
            this.co1.setBounds(0, 0, this.getSize().width, this.getSize().height);
        }
        if (this.co2 != null) {
            this.co2.setBounds(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.getComponentCount() < 2) {
            return;
        }
        graphics.setColor(SystemColor.control);
        graphics.fill3DRect(this.rec[0].x, this.rec[0].y, this.rec[0].width, this.rec[0].height, this.zpro != 0.0 & this.down != 0);
        graphics.fill3DRect(this.rec[1].x, this.rec[1].y, this.rec[1].width, this.rec[1].height, this.down != 1);
        graphics.fill3DRect(this.rec[2].x, this.rec[2].y, this.rec[2].width, this.rec[2].height, this.zpro != 100.0 & this.down != 2);
        graphics.setColor(Color.black);
        int n = this.zwidth - 6;
        switch (this.typ) {
            case 0: {
                int n2 = 0;
                while (n2 < n) {
                    graphics.drawLine(this.rec[0].x + this.rec[0].width / 2 - n2, this.rec[0].y + 3 + n2, this.rec[0].x + this.rec[0].width / 2 + 1 + n2, this.rec[0].y + 3 + n2);
                    if (n2 > 1 & n2 < 4) {
                        graphics.drawLine(this.rec[1].x + 3, this.rec[1].y + 3 + n2, this.rec[1].x + this.rec[1].width - 4, this.rec[1].y + 3 + n2);
                    }
                    graphics.drawLine(this.rec[2].x + this.rec[2].width / 2 - (n - 1 - n2), this.rec[2].y + 3 + n2, this.rec[2].x + this.rec[2].width / 2 + 1 + (n - 1 - n2), this.rec[2].y + 3 + n2);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < n) {
                    graphics.drawLine(this.rec[0].x + 3 + n3, this.rec[0].y + this.rec[0].height / 2 - n3, this.rec[0].x + 3 + n3, this.rec[0].y + this.rec[0].height / 2 + 1 + n3);
                    if (n3 > 1 & n3 < 4) {
                        graphics.drawLine(this.rec[1].x + 3 + n3, this.rec[1].y + 3, this.rec[1].x + 3 + n3, this.rec[1].y + this.rec[1].height - 4);
                    }
                    graphics.drawLine(this.rec[2].x + 3 + n3, this.rec[2].y + this.rec[2].height / 2 - (n - 1 - n3), this.rec[2].x + 3 + n3, this.rec[2].y + this.rec[2].height / 2 + 1 + (n - 1 - n3));
                    ++n3;
                }
                break;
            }
        }
    }
}

