/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.ExtScrollPane;
import auto.awt.MessageDlg;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public final class Utils {
    static Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
    static final Color BLACK = new Color(0, 0, 0);
    static final Color RED = new Color(200, 50, 50);
    static final Color GREEN = new Color(50, 200, 50);
    static final Color YELLOW = new Color(200, 200, 50);
    static final Color BLUE = new Color(50, 50, 200);
    static final Color CYAN = new Color(50, 200, 200);
    static final Color MAGENTA = new Color(200, 50, 200);
    static final Color GRAY = new Color(192, 192, 192);
    static Window cfWin;
    static Component cfCom;
    static int cfZeit;
    static int lastAp;
    static final int[] apostA;
    static final int[] apostE;
    static final int[] apostU;
    static final int[] apostO;
    static final int[] apostI;
    static final int[] apost;
    static final int[] linuxUml;
    public static String oldPath;
    public static final boolean javaPc;
    public static final boolean isLinux;
    public static final boolean isMicrosoft;
    static Frame staticFrame;

    public static final boolean checkLinuxUml(KeyEvent keyEvent) {
        if (isLinux && keyEvent.getKeyCode() == 0) {
            boolean bl = false;
            int n = 0;
            while (n < linuxUml.length) {
                if (keyEvent.getKeyChar() == linuxUml[n]) {
                    bl = true;
                }
                ++n;
            }
            if (bl) {
                return true;
            }
        }
        return false;
    }

    public static final KeyEvent checkApostroph(KeyEvent keyEvent) {
        if (lastAp != -1) {
            switch (keyEvent.getKeyCode()) {
                case 65: {
                    keyEvent.setKeyChar((char)apostA[lastAp + (keyEvent.isShiftDown() ? 3 : 0)]);
                    break;
                }
                case 69: {
                    keyEvent.setKeyChar((char)apostE[lastAp + (keyEvent.isShiftDown() ? 3 : 0)]);
                    break;
                }
                case 85: {
                    keyEvent.setKeyChar((char)apostU[lastAp + (keyEvent.isShiftDown() ? 3 : 0)]);
                    break;
                }
                case 79: {
                    keyEvent.setKeyChar((char)apostO[lastAp + (keyEvent.isShiftDown() ? 3 : 0)]);
                    break;
                }
                case 73: {
                    keyEvent.setKeyChar((char)apostI[lastAp + (keyEvent.isShiftDown() ? 3 : 0)]);
                    break;
                }
                case 16: {
                    return null;
                }
                default: {
                    keyEvent.setKeyCode(apost[lastAp * 2]);
                    keyEvent.setKeyChar((char)apost[lastAp * 2 + 1]);
                }
            }
            lastAp = -1;
            return keyEvent;
        }
        int n = keyEvent.getKeyCode();
        char c = keyEvent.getKeyChar();
        int n2 = 0;
        while (n2 < 3) {
            if (n == apost[n2 * 2] & c == apost[n2 * 2 + 1]) {
                lastAp = n2;
            }
            ++n2;
        }
        if (lastAp != -1) {
            return null;
        }
        return keyEvent;
    }

    public static final String[] getTokens(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static final void checkFocus(Window window, Component component, int n) {
        cfWin = window;
        cfCom = component;
        cfZeit = n;
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(cfZeit);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (cfWin != null) {
                    cfWin.toFront();
                }
                cfCom.requestFocus();
            }

            public String toString() {
                return "Utils.checkFocus";
            }
        };
        thread.start();
    }

    public static final ExtScrollPane withScrollPane(Component component) {
        ExtScrollPane extScrollPane = new ExtScrollPane();
        extScrollPane.addElement(component);
        return extScrollPane;
    }

    public static final Panel panelNorth(Component component) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add("North", component);
        return panel;
    }

    private static final void drawFract(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color[] colorArray, int n9) {
        int n10 = (n5 + n6 + n7 + n8) / 4 + (int)(Math.random() * (double)(n7 - n5) - (double)((n7 - n5) / 2));
        if (n9 == 5) {
            graphics.setColor(colorArray[50 + n10 / 2]);
            graphics.fillRect(n, n2, n3, n4);
            return;
        }
        int n11 = n3 / 2 + n;
        int n12 = n + n3;
        int n13 = n4 / 2 + n2;
        int n14 = n2 + n4;
        int n15 = (n5 + n8) / 2;
        int n16 = (n5 + n6) / 2;
        int n17 = (n6 + n7) / 2;
        int n18 = (n7 + n8) / 2;
        Utils.drawFract(graphics, n, n2, n11 - n, n13 - n2, n5, n16, n10, n15, colorArray, n9 + 1);
        Utils.drawFract(graphics, n, n13, n11 - n, n14 - n13, n16, n6, n17, n10, colorArray, n9 + 1);
        Utils.drawFract(graphics, n11, n13, n12 - n11, n14 - n13, n10, n17, n7, n18, colorArray, n9 + 1);
        Utils.drawFract(graphics, n11, n2, n12 - n11, n13 - n2, n15, n10, n18, n8, colorArray, n9 + 1);
    }

    public static final void drawFractal(Graphics graphics, Rectangle rectangle, Color color, Color color2, Color color3) {
        Color[] colorArray = new Color[100];
        int n = colorArray.length / 2;
        int n2 = 0;
        while (n2 < n) {
            colorArray[n2] = new Color(color.getRed() * (n - n2) / n + color2.getRed() * n2 / n, color.getGreen() * (n - n2) / n + color2.getGreen() * n2 / n, color.getBlue() * (n - n2) / n + color2.getBlue() * n2 / n);
            ++n2;
        }
        int n3 = n;
        while (n3 < colorArray.length) {
            colorArray[n3] = new Color(color2.getRed() * (n + n - n3) / n + color3.getRed() * (n3 - n) / n, color2.getGreen() * (n + n - n3) / n + color3.getGreen() * (n3 - n) / n, color2.getBlue() * (n + n - n3) / n + color3.getBlue() * (n3 - n) / n);
            ++n3;
        }
        Utils.drawFract(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, -50, 0, 50, 0, colorArray, 0);
    }

    public static final String checkJavaVersion() {
        String string = System.getProperty("java.vendor").toLowerCase();
        String string2 = System.getProperty("java.version").toLowerCase();
        if (string.indexOf("sun") != -1 && string2.compareTo("1.1.7") <= 0) {
            return "You're using an old Java-VM. Please update your System !";
        }
        return null;
    }

    public static final String space(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(string);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static final String str(int n) {
        return String.valueOf(n);
    }

    public static final String str(int n, int n2) {
        String string = Utils.str(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public static final void draw3DRect(Graphics graphics, Rectangle rectangle, Color color, boolean bl) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        if (!bl) {
            graphics.setColor(color);
            graphics.drawLine(n, n2, n, n4);
            graphics.drawLine(n, n2, n3, n4);
            graphics.setColor(color.brighter());
            graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 1);
            graphics.drawLine(n + 1, n2 + 1, n3 - 1, n2 + 1);
            graphics.setColor(Color.black);
            graphics.drawLine(n, n4, n3, n4);
            graphics.drawLine(n3, n2, n3, n4);
            graphics.setColor(color.darker());
            graphics.drawLine(n + 1, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, n2 + 2, n3 - 1, n4 - 1);
        } else {
            graphics.setColor(Color.black);
            graphics.drawLine(n, n2, n, n4);
            graphics.drawLine(n, n2, n3, n2);
            graphics.setColor(color.darker());
            graphics.drawLine(n + 1, n2 + 1, n + 1, n4 - 1);
            graphics.drawLine(n + 1, n2 + 1, n3 - 1, n2 + 1);
            graphics.setColor(color.brighter());
            graphics.drawLine(n, n4, n3, n4);
            graphics.drawLine(n3, n2, n3, n4);
            graphics.setColor(color);
            graphics.drawLine(n + 1, n4 - 1, n3 - 1, n4 - 1);
            graphics.drawLine(n3 - 1, n2 + 2, n3 - 1, n4 - 1);
        }
    }

    public static final void drawZebraLine(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (bl) {
            int n5 = 0;
            while (n5 < n3) {
                if ((n5 + n) % 2 == 0) {
                    graphics.drawLine(n + n5, n2, n + n5, n2);
                }
                ++n5;
            }
        } else {
            int n6 = 0;
            while (n6 < n4) {
                if ((n6 + n2) % 2 == 0) {
                    graphics.drawLine(n, n2 + n6, n, n2 + n6);
                }
                ++n6;
            }
        }
    }

    public static final void drawZebraRect(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = 0;
        while (n5 < n3) {
            if ((n5 + n) % 2 == 0) {
                graphics.drawLine(n + n5, n2, n + n5, n2);
                graphics.drawLine(n + n5, n2 + n4, n + n5, n2 + n4);
            }
            ++n5;
        }
        int n6 = 0;
        while (n6 < n4) {
            if ((n6 + n2) % 2 == 0) {
                graphics.drawLine(n, n2 + n6, n, n2 + n6);
                graphics.drawLine(n + n3, n2 + n6, n + n3, n2 + n6);
            }
            ++n6;
        }
    }

    public static final String toHex2(int n) {
        String string = Integer.toHexString(n);
        while (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    public static final Color stringToColor(String string) {
        return new Color(Integer.parseInt(string.substring(0, 2), 16), Integer.parseInt(string.substring(2, 4), 16), Integer.parseInt(string.substring(4, 6), 16));
    }

    public static final String colorToString(Color color) {
        return Utils.toHex2(color.getRed()) + Utils.toHex2(color.getGreen()) + Utils.toHex2(color.getBlue());
    }

    public static final int stringToFontStyle(String string) {
        if (string.equals("BOLD")) {
            return 1;
        }
        if (string.equals("ITALIC")) {
            return 2;
        }
        if (string.equals("BOLD+ITALIC")) {
            return 3;
        }
        return 0;
    }

    public static final String fontStyleToString(int n) {
        if (n == 1) {
            return "BOLD";
        }
        if (n == 2) {
            return "ITALIC";
        }
        if (n == 3) {
            return "BOLD+ITALIC";
        }
        return "PLAIN";
    }

    public static final float valf(String string) {
        return Float.valueOf(string).floatValue();
    }

    public static final int val(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            n = -1;
        }
        return n;
    }

    public static String loadDlg(Frame frame, String string, String string2) {
        if (oldPath == null) {
            oldPath = System.getProperty("user.dir");
        }
        FileDialog fileDialog = new FileDialog(frame, string, 0);
        if (string2 != null) {
            fileDialog.setFile(string2);
        }
        fileDialog.setDirectory(oldPath);
        fileDialog.show();
        fileDialog.dispose();
        if (fileDialog.getDirectory() != null) {
            oldPath = fileDialog.getDirectory();
        }
        if (fileDialog.getFile() == null) {
            return null;
        }
        return (fileDialog.getDirectory() + fileDialog.getFile()).replace('\\', '/');
    }

    public static String saveDlg(Frame frame, String string, String string2) {
        if (oldPath == null) {
            oldPath = System.getProperty("user.dir");
        }
        FileDialog fileDialog = new FileDialog(frame, string, 1);
        if (string2 != null) {
            fileDialog.setFile(string2);
        }
        fileDialog.setDirectory(oldPath);
        fileDialog.show();
        fileDialog.dispose();
        if (fileDialog.getDirectory() != null) {
            oldPath = fileDialog.getDirectory();
        }
        if (fileDialog.getFile() == null) {
            return null;
        }
        return (fileDialog.getDirectory() + fileDialog.getFile()).replace('\\', '/');
    }

    public static boolean checkWindowOnScreen(Window window, boolean bl) {
        boolean bl2 = false;
        Rectangle rectangle = window.getBounds();
        Dimension dimension = defaultToolkit.getScreenSize();
        if (rectangle.y + rectangle.height > dimension.height) {
            window.setSize(window.getSize().width, dimension.height - rectangle.y);
            bl2 = true;
        }
        if (rectangle.x + rectangle.width > dimension.width) {
            window.setSize(dimension.width - rectangle.x, window.getSize().height);
            bl2 = true;
        }
        return bl2;
    }

    public static void centerWindow(Window window) {
        Dimension dimension = window.getSize();
        Dimension dimension2 = defaultToolkit.getScreenSize();
        int n = 0;
        if (dimension.width < dimension2.width) {
            n = (dimension2.width - dimension.width) / 2;
        }
        int n2 = 0;
        if (dimension.height < dimension2.height) {
            n2 = (dimension2.height - dimension.height) / 2;
        }
        window.setLocation(n, n2);
    }

    public static void centerWindow(Window window, Window window2) {
        Dimension dimension = window.getSize();
        Dimension dimension2 = window2.getSize();
        Point point = window2.getLocation();
        int n = (dimension2.width - dimension.width) / 2 + point.x;
        int n2 = (dimension2.height - dimension.height) / 2 + point.y;
        window.setLocation(n, n2);
    }

    public static String relativePath(String string) {
        string = Utils.slashSeparators(string);
        String string2 = Utils.slashSeparators(System.getProperty("user.dir")) + '/';
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        while ((n = string2.indexOf("/", n)) != -1) {
            if (!string.startsWith(string2.substring(0, n + 1))) {
                if (bl) {
                    return string;
                }
                ++n2;
            } else {
                n3 = n;
            }
            bl = false;
            ++n;
        }
        string = string.substring(n3 + 1);
        while (n2 > 0) {
            --n2;
            string = "../" + string;
        }
        return string;
    }

    public static String absolutePath(String string) {
        if ((string = Utils.slashSeparators(string)).startsWith("/")) {
            return string;
        }
        if (string.length() > 2 && string.charAt(1) == ':') {
            return string;
        }
        String string2 = Utils.slashSeparators(System.getProperty("user.dir")) + '/';
        String string3 = string;
        try {
            while (string.startsWith("../")) {
                string = string.substring(3);
                string2 = string2.substring(0, string2.substring(0, string2.length() - 1).lastIndexOf("/") + 1);
            }
            if (string.startsWith("./")) {
                string = string.substring(2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string3;
        }
        string = string2 + string;
        return string;
    }

    public static Color calcDEMColor(int n) {
        Color color = Color.black;
        switch (n) {
            case 1: {
                color = BLACK;
                break;
            }
            case 2: {
                color = RED;
                break;
            }
            case 3: {
                color = GREEN;
                break;
            }
            case 4: {
                color = YELLOW;
                break;
            }
            case 5: {
                color = BLUE;
                break;
            }
            case 6: {
                color = CYAN;
                break;
            }
            case 7: {
                color = MAGENTA;
                break;
            }
            case 8: {
                color = GRAY;
            }
        }
        return color;
    }

    public static Object createObject(String string, Object[] objectArray, String[] stringArray) throws Exception {
        Object var3_3 = null;
        Class<?> clazz = Class.forName(string);
        Class[] classArray = new Class[stringArray.length];
        int n = 0;
        while (n < classArray.length) {
            classArray[n] = Class.forName(stringArray[n]);
            ++n;
        }
        var3_3 = clazz.getConstructor(classArray).newInstance(objectArray);
        return var3_3;
    }

    public static Object createObject(String string, Object[] objectArray) throws Exception {
        Object var2_2 = null;
        Class<?> clazz = Class.forName(string);
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            classArray[n] = objectArray[n].getClass();
            System.out.println(classArray[n]);
            ++n;
        }
        var2_2 = clazz.getConstructor(classArray).newInstance(objectArray);
        return var2_2;
    }

    public static Object doMethod(Object object, String string, Object[] objectArray, String[] stringArray) throws Exception {
        Object object2 = null;
        Class[] classArray = new Class[stringArray.length];
        int n = 0;
        while (n < classArray.length) {
            classArray[n] = Class.forName(stringArray[n]);
            ++n;
        }
        object2 = object.getClass().getMethod(string, classArray).invoke(object, objectArray);
        return object2;
    }

    public static Object doMethod(Object object, String string, Object[] objectArray) throws Exception {
        Object object2 = null;
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            classArray[n] = objectArray[n].getClass();
            ++n;
        }
        object2 = object.getClass().getMethod(string, classArray).invoke(object, objectArray);
        return object2;
    }

    public static void drawViewText(Graphics graphics, Point point, String string, Color color, Color color2, Font font, Dimension dimension) {
        point.x *= dimension.width;
        point.y *= dimension.height;
        graphics.setColor(color);
        graphics.fillRect(point.x, point.y, string.length() * dimension.width, dimension.height);
        graphics.setColor(color2);
        graphics.setFont(font);
        graphics.drawString(string, point.x, point.y + dimension.height * 3 / 4);
        graphics.setColor(Color.black);
        graphics.drawRect(point.x, point.y, string.length() * dimension.width, dimension.height);
    }

    public static void drawSelectMarks(Component component, Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.setPaintMode();
        Point point = new Point(component.getSize().width, component.getSize().height);
        graphics.fillRect(0, 0, 5, 5);
        graphics.fillRect(point.x / 2 - 2, 0, 5, 5);
        graphics.fillRect(point.x - 5, 0, 5, 5);
        graphics.fillRect(0, point.y / 2 - 2, 5, 5);
        graphics.fillRect(point.x - 5, point.y / 2 - 2, 5, 5);
        graphics.fillRect(0, point.y - 5, 5, 5);
        graphics.fillRect(point.x / 2 - 2, point.y - 5, 5, 5);
        graphics.fillRect(point.x - 5, point.y - 5, 5, 5);
    }

    public static Panel addTitle2(String string, Component component) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        panel2.add(new Label(string));
        panel2.add(component);
        panel.add((Component)panel2, "North");
        return panel;
    }

    public static Panel addTitle(String string, Component component) {
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)new Label(string), "West");
        panel.add(component, "Center");
        return panel;
    }

    public static Panel addPanel(Component component) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout());
        panel.add(component);
        return panel;
    }

    public static Panel addPanel2(Component component) {
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        panel.add(component);
        return panel;
    }

    public static Frame appletFrame(Applet applet) {
        return Utils.appletFrame("", applet, 600, 400);
    }

    public static Frame appletFrame(String string, Applet applet) {
        return Utils.appletFrame(string, applet, 600, 400);
    }

    public static Frame appletFrame(Applet applet, int n, int n2) {
        return Utils.appletFrame("", applet, n, n2);
    }

    public static Frame appletFrame(String string, Applet applet, int n, int n2) {
        Frame frame = Utils.mainFrame(string, applet, false);
        frame.setSize(n, n2);
        applet.init();
        frame.setVisible(true);
        applet.start();
        return frame;
    }

    public static Frame mainFrame(Component component, int n, int n2) {
        return Utils.mainFrame("", component, n, n2);
    }

    public static Frame mainFrame(String string, Component component, int n, int n2) {
        Frame frame = Utils.mainFrame(string, component, false);
        frame.setSize(n, n2);
        frame.setVisible(true);
        return frame;
    }

    public static Frame mainFrame(Component component) {
        return Utils.mainFrame("", component, true);
    }

    public static Frame mainFrame(Component component, boolean bl) {
        return Utils.mainFrame("", component, true);
    }

    public static Frame mainFrame(String string, Component component, boolean bl) {
        Frame frame = new Frame(string);
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (windowEvent.getWindow().getComponent(0) instanceof Applet) {
                    ((Applet)windowEvent.getWindow().getComponent(0)).stop();
                }
                windowEvent.getWindow().setVisible(false);
                System.exit(0);
            }
        };
        frame.addWindowListener(windowAdapter);
        frame.setLayout(new BorderLayout());
        frame.add(component, "Center");
        frame.setBounds(50, 50, 600, 400);
        if (bl) {
            frame.show();
        }
        return frame;
    }

    public static void msg(String string) {
        new MessageDlg(Utils.getStaticFrame(), "", string).show();
    }

    public static Component getLastParent(Component component) {
        if (component.getParent() == null) {
            return component;
        }
        return Utils.getLastParent(component.getParent());
    }

    public static Window getParentWin(Component component) {
        if (component instanceof Window) {
            return (Window)component;
        }
        if (component.getParent() == null) {
            return null;
        }
        return Utils.getParentWin(component.getParent());
    }

    public static Frame getStaticFrame() {
        if (staticFrame == null) {
            staticFrame = new Frame();
        }
        return staticFrame;
    }

    public static Frame getParentFrame(Component component) {
        Window window = Utils.getParentWin(component);
        if (window == null) {
            window = Utils.getStaticFrame();
        }
        if (!(window instanceof Frame)) {
            window = Utils.getStaticFrame();
        }
        return (Frame)window;
    }

    public static String slashSeparators(String string) {
        string = string.replace(File.separator.charAt(0), '/');
        return string;
    }

    public static String rightSeparators(String string) {
        if (File.separator.equals("/")) {
            return string;
        }
        string = string.replace('/', File.separator.charAt(0));
        return string;
    }

    public static String getName(String string) {
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static String getPath(String string) {
        int n = string.lastIndexOf("/");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String combinePath(String string, String string2) {
        return string + "/" + string2;
    }

    public static String getHashKey(Object object, Hashtable hashtable) {
        int n = 0;
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            if (enumeration.nextElement() == object) break;
            ++n;
        }
        Enumeration enumeration2 = hashtable.keys();
        int n2 = 0;
        while (n2 < n) {
            enumeration2.nextElement();
            ++n2;
        }
        return (String)enumeration2.nextElement();
    }

    public static void main(String[] stringArray) {
        System.out.println(isLinux);
        String string = "../../Images/me/bild.gif";
        System.out.println(string);
        string = Utils.absolutePath(string);
        System.out.println(string);
        string = Utils.relativePath(string);
        System.out.println(string);
    }

    static {
        lastAp = -1;
        apostA = new int[]{224, 225, 226, 192, 193, 194};
        apostE = new int[]{232, 233, 234, 200, 201, 202};
        apostU = new int[]{249, 250, 251, 217, 218, 219};
        apostO = new int[]{242, 243, 244, 210, 211, 212};
        apostI = new int[]{236, 237, 238, 204, 205, 206};
        apost = new int[]{93, 96, 93, 180, 92, 94};
        linuxUml = new int[]{246, 214, 228, 196, 252, 220, 223};
        oldPath = null;
        javaPc = System.getProperty("os.name").toLowerCase().indexOf("java") != -1;
        isLinux = System.getProperty("os.name").toLowerCase().equals("linux");
        isMicrosoft = System.getProperty("java.vendor").toLowerCase().indexOf("microsoft") != -1;
        staticFrame = null;
    }
}

