/*
 * Decompiled with CFR 0.152.
 */
package auto.awt;

import auto.awt.Utils;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public final class WindowHeader
extends Window
implements ComponentListener,
MouseListener,
MouseMotionListener {
    Window w;
    Dimension dim = new Dimension(200, 20);
    String text = "";
    Point mp;
    Point wp;

    public WindowHeader(Window window, Frame frame) {
        super(frame);
        this.w = window;
        SystemColor systemColor = SystemColor.control;
        this.setFont(new Font("Sansserif", 1, 12));
        this.setBackground(systemColor);
        this.setSize(this.dim);
        this.winLocation();
        this.w.addComponentListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setText(String string) {
        this.text = string;
        this.setSize(this.getFontMetrics(this.getFont()).stringWidth(string) + 10, this.dim.height);
        this.dim = this.getSize();
        this.repaint();
    }

    void winLocation() {
        Rectangle rectangle = this.w.getBounds();
        this.setLocation(rectangle.x + 20, rectangle.y - this.dim.height);
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.winLocation();
    }

    public void componentResized(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mp = this.getLocationOnScreen();
        this.mp.x += mouseEvent.getX();
        this.mp.y += mouseEvent.getY();
        this.wp = this.w.getLocationOnScreen();
        this.wp.x += mouseEvent.getX();
        this.wp.y += mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Point point = this.getLocationOnScreen();
        point.x += mouseEvent.getX();
        point.y += mouseEvent.getY();
        this.setLocation(this.getLocation().x + point.x - this.mp.x, this.getLocation().y + point.y - this.mp.y);
        this.mp = point;
        point = this.w.getLocationOnScreen();
        point.x += mouseEvent.getX();
        point.y += mouseEvent.getY();
        this.w.setLocation(this.w.getLocation().x + point.x - this.wp.x, this.w.getLocation().y + point.y - this.wp.y);
        this.wp = point;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.black);
        graphics.drawLine(0, 0, this.dim.width, 0);
        graphics.drawLine(0, 0, 0, this.dim.height);
        graphics.drawLine(this.dim.width - 1, 0, this.dim.width - 1, this.dim.height);
        graphics.setColor(this.getBackground().brighter());
        graphics.drawLine(1, 1, this.dim.width - 2, 1);
        graphics.drawLine(1, 1, 1, this.dim.height - 1);
        graphics.setColor(this.getBackground().darker());
        graphics.drawLine(this.dim.width - 2, 1, this.dim.width - 2, this.dim.height - 1);
        graphics.drawLine(1, this.dim.height - 1, this.dim.width - 2, this.dim.height - 1);
        graphics.setColor(Color.black);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(this.text, 5, fontMetrics.getAscent() + 2);
    }

    public static void main(String[] stringArray) {
        Frame frame = Utils.mainFrame(new Button("ulu"), 200, 200);
        new WindowHeader((Window)frame, frame).show();
    }
}

