/*
 * Decompiled with CFR 0.152.
 */
package auto.awt.fold;

import auto.awt.fold.Fold;
import auto.awt.teimfold.TfEdit;
import auto.util.io.TextUtils;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;

public class IO {
    static final char openBlock = '{';
    static final char closeBlock = '}';

    static boolean noSlash(String string, int n) {
        int n2 = 0;
        while (n - n2 >= 0 && string.charAt(n - n2) == '\\') {
            ++n2;
        }
        return n2 % 2 == 0;
    }

    public static String space(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n2 = n - 1;
        while (n2 >= 0) {
            stringBuffer.append(" ");
            --n2;
        }
        return stringBuffer.toString();
    }

    public static int countSpace(String string) {
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != ' ') break;
            ++n;
        }
        return n;
    }

    static String preTrim(String string, int n) {
        while (--n >= 0 && string.startsWith(" ")) {
            string = string.substring(1);
        }
        return string;
    }

    static void jumpWhiteToLineEnd(PushbackInputStream pushbackInputStream) throws IOException {
        int n;
        do {
            if ((n = pushbackInputStream.read()) != 10) continue;
            return;
        } while (!(n != 32 & n != 13 & n != 8));
        pushbackInputStream.unread(n);
    }

    static void jumpToNoWhite(PushbackInputStream pushbackInputStream) throws IOException {
        int n;
        while ((n = pushbackInputStream.read()) == 32 | n == 13 | n == 10 | n == 8) {
        }
        pushbackInputStream.unread(n);
    }

    static String stringToWhite(PushbackInputStream pushbackInputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("");
        while (true) {
            char c;
            if (!(Character.isLetter(c = (char)(n = pushbackInputStream.read())) | Character.isDigit(c))) break;
            stringBuffer.append(c);
        }
        pushbackInputStream.unread(n);
        return stringBuffer.toString();
    }

    public static String stringToChar(PushbackInputStream pushbackInputStream, char c, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer("");
        while (true) {
            int n;
            char c2;
            if ((c2 = (char)(n = pushbackInputStream.read())) == c) {
                if (bl) {
                    stringBuffer.append(c2);
                    break;
                }
                pushbackInputStream.unread(c2);
                break;
            }
            if (n == 10) break;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static Fold loadJava(String string, PushbackInputStream pushbackInputStream) throws IOException {
        Fold fold = new Fold();
        fold.title = string;
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        int n = 0;
        int n2 = -1;
        while (bl3) {
            int n3 = pushbackInputStream.read();
            switch (n3) {
                case 125: {
                    if (bl | bl2) {
                        string2 = string2 + (char)n3;
                        break;
                    }
                    if (n > 0) {
                        --n;
                        string2 = string2 + (char)n3;
                        break;
                    }
                    IO.jumpWhiteToLineEnd(pushbackInputStream);
                }
                case -1: {
                    Fold fold2;
                    if (string2.trim().length() > 0) {
                        fold2 = new Fold(string2.trim());
                        fold.add(fold2);
                    }
                    bl3 = false;
                    break;
                }
                case 39: {
                    string2 = string2 + '\'';
                    String string3 = "";
                    do {
                        if ((n3 = pushbackInputStream.read()) == 13 | n3 == 10 | n3 == -1) {
                            int n4 = string3.length() - 1;
                            while (n4 >= 0) {
                                pushbackInputStream.unread(string3.charAt(n4));
                                --n4;
                            }
                            string3 = "";
                            break;
                        }
                        string3 = string3 + (char)n3;
                    } while (n3 != 39 || !IO.noSlash(string3, string3.length() - 2));
                    string2 = string2 + string3;
                    break;
                }
                case 34: {
                    string2 = string2 + '\"';
                    String string3 = "";
                    do {
                        if ((n3 = pushbackInputStream.read()) == 13 | n3 == 10 | n3 == -1) {
                            int n5 = string3.length() - 1;
                            while (n5 >= 0) {
                                pushbackInputStream.unread(string3.charAt(n5));
                                --n5;
                            }
                            string3 = "";
                            break;
                        }
                        string3 = string3 + (char)n3;
                    } while (n3 != 34 || !IO.noSlash(string3, string3.length() - 2));
                    string2 = string2 + string3;
                    break;
                }
                case 10: {
                    bl = false;
                    if (n2 == -1) {
                        n2 = IO.countSpace(string2);
                    }
                    Fold fold2 = new Fold(IO.preTrim(string2, n2));
                    fold.add(fold2);
                    string2 = "";
                    break;
                }
                case 123: {
                    boolean bl4 = bl | bl2;
                    int n6 = pushbackInputStream.read();
                    if ((char)n6 == '}') {
                        string2 = string2 + (char)n3 + "" + '}';
                        break;
                    }
                    pushbackInputStream.unread(n6);
                    if (!bl4) {
                        bl4 = true;
                        if (string2.indexOf("class") != -1) {
                            bl4 = false;
                        } else if (string2.indexOf("throws") != -1) {
                            bl4 = false;
                        } else if (string2.indexOf("if ") != -1) {
                            bl4 = true;
                        } else if (string2.indexOf("catch ") != -1) {
                            bl4 = true;
                        } else if (string2.indexOf("while") != -1) {
                            bl4 = true;
                        } else if (string2.indexOf("for ") != -1) {
                            bl4 = true;
                        } else if (string2.trim().endsWith(")")) {
                            bl4 = false;
                        }
                        if (bl4) {
                            ++n;
                        }
                    }
                    if (bl4) {
                        string2 = string2 + (char)n3;
                        break;
                    }
                    IO.jumpWhiteToLineEnd(pushbackInputStream);
                    fold.add(IO.loadJava(string2.trim(), pushbackInputStream));
                    string2 = "";
                    break;
                }
                case 47: {
                    string2 = string2 + (char)n3;
                    int n7 = pushbackInputStream.read();
                    if (n7 == 47) {
                        bl = true;
                    }
                    if (n7 == 42 && !bl) {
                        bl2 = true;
                    }
                    pushbackInputStream.unread(n7);
                    break;
                }
                case 42: {
                    string2 = string2 + (char)n3;
                    int n7 = pushbackInputStream.read();
                    if (n7 == 47) {
                        bl2 = false;
                    }
                    pushbackInputStream.unread(n7);
                    break;
                }
                default: {
                    string2 = string2 + (char)n3;
                }
            }
        }
        return fold;
    }

    public static Fold loadLiva(String string, PushbackInputStream pushbackInputStream) throws IOException {
        Fold fold = new Fold();
        fold.title = string;
        char c = '(';
        char c2 = ')';
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        int n2 = -1;
        while (true) {
            int n3;
            char c3;
            if ((c3 = (char)(n3 = pushbackInputStream.read())) == c) {
                IO.jumpToNoWhite(pushbackInputStream);
                String string2 = IO.stringToWhite(pushbackInputStream);
                if (string2.equals("func") | string2.equals("progn") | string2.equals("do")) {
                    if (string2.equals("func")) {
                        string2 = string2 + IO.stringToChar(pushbackInputStream, ')', true);
                    }
                    IO.jumpWhiteToLineEnd(pushbackInputStream);
                    if (stringBuffer.length() > 0 && n2 <= 1) {
                        n2 = IO.countSpace(stringBuffer.toString());
                    }
                    fold.add(IO.loadLiva((stringBuffer.length() > 0 ? IO.preTrim(stringBuffer.toString(), n2) : "") + c + string2, pushbackInputStream));
                    stringBuffer.setLength(0);
                    continue;
                }
                ++n;
                stringBuffer.append(c + string2);
                continue;
            }
            if (c3 == c2) {
                if (n > 0) {
                    --n;
                    stringBuffer.append(c3);
                    continue;
                }
                IO.jumpWhiteToLineEnd(pushbackInputStream);
                if (stringBuffer.toString().trim().length() <= 0) break;
                fold.add(new Fold(stringBuffer.toString()));
                break;
            }
            if (c3 == '\n') {
                if (n2 <= 1) {
                    n2 = IO.countSpace(stringBuffer.toString());
                }
                fold.add(new Fold(IO.preTrim(stringBuffer.toString(), n2)));
                stringBuffer.setLength(0);
                continue;
            }
            if (c3 == '\"') {
                stringBuffer.append(c3 + IO.stringToChar(pushbackInputStream, '\"', true));
                continue;
            }
            if (c3 == '/') {
                int n4 = pushbackInputStream.read();
                if (n4 != 47) {
                    pushbackInputStream.unread(n4);
                    stringBuffer.append(c3);
                    continue;
                }
                stringBuffer.append("//" + IO.stringToChar(pushbackInputStream, '\n', false));
                continue;
            }
            if (n3 == -1) {
                if (stringBuffer.length() <= 0) break;
                fold.add(new Fold(stringBuffer.toString()));
                break;
            }
            stringBuffer.append(c3);
        }
        return fold;
    }

    public static void saveText(Fold fold, PrintWriter printWriter) throws IOException {
        if (fold.fV != null) {
            printWriter.print("<b>");
        }
        printWriter.println(fold.title);
        if (fold.fV != null) {
            int n = 0;
            while (n < fold.fV.size()) {
                IO.saveText(fold.at(n), printWriter);
                ++n;
            }
        }
        if (fold.fV != null) {
            printWriter.print("</b>");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Fold loadText(String string, PushbackInputStream pushbackInputStream) throws IOException {
        Fold fold = new Fold(string);
        StringBuffer stringBuffer = new StringBuffer("");
        while (true) {
            int n;
            char c;
            if ((c = (char)(n = pushbackInputStream.read())) == '\n') {
                fold.add(new Fold(stringBuffer.toString()));
                stringBuffer.setLength(0);
            } else if (c == '\"') {
                stringBuffer.append(c + IO.stringToChar(pushbackInputStream, '\"', true));
            } else if (c == '/') {
                int n2 = pushbackInputStream.read();
                if (n2 != 47) {
                    pushbackInputStream.unread(n2);
                    stringBuffer.append(c);
                } else {
                    stringBuffer.append("//" + IO.stringToChar(pushbackInputStream, '\n', false));
                }
            } else {
                if (n == -1) {
                    if (stringBuffer.length() <= 0) return fold;
                    fold.add(new Fold(stringBuffer.toString()));
                    return fold;
                }
                stringBuffer.append(c);
            }
            if (stringBuffer.toString().endsWith("<b>")) {
                String string2 = IO.stringToChar(pushbackInputStream, '\n', false);
                pushbackInputStream.read();
                fold.add(IO.loadText(string2, pushbackInputStream));
                stringBuffer.setLength(0);
                continue;
            }
            if (stringBuffer.toString().endsWith("</b>")) return fold;
        }
    }

    public static Fold loadTex(int n, String string, PushbackInputStream pushbackInputStream) throws IOException {
        Fold fold = new Fold();
        fold.title = string;
        StringBuffer stringBuffer = new StringBuffer("");
        while (true) {
            String string2;
            int n2;
            char c;
            if ((c = (char)(n2 = pushbackInputStream.read())) == '\n') {
                fold.add(new Fold(stringBuffer.toString()));
                stringBuffer.setLength(0);
            } else if (c == '$') {
                stringBuffer.append(c + IO.stringToChar(pushbackInputStream, '$', true));
            } else if (c == '%') {
                stringBuffer.append("%" + IO.stringToChar(pushbackInputStream, '\n', false));
            } else {
                if (n2 == -1) {
                    if (stringBuffer.length() <= 0) break;
                    fold.add(new Fold(stringBuffer.toString()));
                    break;
                }
                stringBuffer.append(c);
            }
            if (stringBuffer.toString().endsWith("\\section{")) {
                string2 = TextUtils.readToChar(pushbackInputStream, '}');
                if (n > 0) {
                    pushbackInputStream.unread(("\\section{" + string2 + "}").getBytes());
                    return fold;
                }
                fold.add(IO.loadTex(n + 1, string2, pushbackInputStream));
                stringBuffer.setLength(0);
            }
            if (stringBuffer.toString().endsWith("\\subsection{")) {
                string2 = TextUtils.readToChar(pushbackInputStream, '}');
                if (n > 1) {
                    pushbackInputStream.unread(("\\subsection{" + string2 + "}").getBytes());
                    return fold;
                }
                fold.add(IO.loadTex(n + 1, string2, pushbackInputStream));
                stringBuffer.setLength(0);
            }
            if (!stringBuffer.toString().endsWith("\\subsubsection{")) continue;
            string2 = TextUtils.readToChar(pushbackInputStream, '}');
            if (n > 2) {
                pushbackInputStream.unread(("\\subsubsection{" + string2 + "}").getBytes());
                return fold;
            }
            fold.add(IO.loadTex(n + 1, string2, pushbackInputStream));
            stringBuffer.setLength(0);
        }
        return fold;
    }

    public static Fold load(InputStream inputStream, String string) throws IOException {
        Fold fold = null;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(new BufferedInputStream(inputStream), 300);
        fold = string.endsWith(".java") ? IO.loadJava(string, pushbackInputStream) : (string.endsWith(".t.txt") ? IO.loadText(string, pushbackInputStream) : (string.endsWith(".tex") ? IO.loadTex(0, string, pushbackInputStream) : IO.loadLiva(string, pushbackInputStream)));
        pushbackInputStream.close();
        return fold;
    }

    public static void saveFoldOpenComments(Fold fold, int n, PrintWriter printWriter, int[] nArray) throws IOException {
        if (fold.fV == null) {
            return;
        }
        if (n >= 0 & fold.open) {
            StringBuffer stringBuffer = new StringBuffer("//fr o");
            int n2 = 0;
            while (n2 <= n) {
                stringBuffer.append("," + nArray[n2]);
                ++n2;
            }
            printWriter.println(stringBuffer.toString());
        }
        int n3 = 0;
        while (n3 < fold.fV.size()) {
            nArray[n + 1] = n3;
            IO.saveFoldOpenComments(fold.at(n3), n + 1, printWriter, nArray);
            ++n3;
        }
    }

    public static void save(Fold fold, PrintWriter printWriter, String string, TfEdit tfEdit) throws IOException {
        if (string.endsWith(".t.txt")) {
            int n = 0;
            while (n < fold.fV.size()) {
                IO.saveText(fold.at(n), printWriter);
                ++n;
            }
        } else {
            throw new Error("IO.save: unknown filetyp:" + string);
        }
        IO.saveFoldOpenComments(fold, -1, printWriter, new int[1000]);
        printWriter.println("//fr p," + tfEdit.xC + "," + tfEdit.yC);
    }

    public static Fold load(String string) {
        Fold fold = null;
        try {
            fold = IO.load(new FileInputStream(string), string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return fold;
    }

    public static void saveFile(Fold fold, String string, TfEdit tfEdit) {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            IO.save(fold, printWriter, string, tfEdit);
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        Fold fold = IO.load("Test.java");
        System.out.println(fold);
    }
}

