/*
 * Decompiled with CFR 0.152.
 */
package auto.awt.menu;

import auto.awt.Utils;
import auto.awt.menu.ExtMenuItem;
import auto.awt.menu.MenuAble;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExtMenuBar
extends Panel
implements MenuAble,
WindowListener,
ComponentListener,
MouseListener,
ContainerListener,
KeyListener {
    ActionListener actionListener;
    boolean fastOpen = false;
    Vector mis = new Vector(20, 20);
    ExtMenuItem selected = null;
    Vector cur;
    boolean popup = false;
    Component popupComponent;
    boolean dialogMenu = false;
    boolean windowsFronted = false;

    public void windowOpened(WindowEvent windowEvent) {
        this.closeAll();
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.closeAll();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.closeAll();
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.closeAll();
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.closeAll();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.closeAll();
    }

    public void componentMoved(ComponentEvent componentEvent) {
        this.closeAll();
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.closeAll();
    }

    public void componentShown(ComponentEvent componentEvent) {
        this.closeAll();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.closeAll();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (keyEvent.getSource() == this | keyEvent.getSource() instanceof ExtMenuItem) {
            if (keyEvent.getKeyCode() == 27) {
                this.exit();
            }
            if (this.selected != null) {
                this.selected.handleKey(keyEvent);
            }
        } else {
            ExtMenuItem extMenuItem;
            int n = 0;
            while (n < this.mis.size()) {
                extMenuItem = (ExtMenuItem)this.mis.elementAt(n);
                if (extMenuItem.enabled && extMenuItem.hotkey != null && extMenuItem.hotkey.equals(keyEvent)) {
                    keyEvent.consume();
                    extMenuItem.push();
                }
                ++n;
            }
            if (keyEvent.isAltDown() & !keyEvent.isControlDown() & !keyEvent.isShiftDown()) {
                int n2 = 0;
                while (n2 < this.getComponentCount()) {
                    extMenuItem = (ExtMenuItem)this.getComponent(n2);
                    if (extMenuItem.keyPos != -1 && keyEvent.getKeyChar() > '\u0000' && Character.toLowerCase(extMenuItem.text.charAt(extMenuItem.keyPos)) == Character.toLowerCase(keyEvent.getKeyChar())) {
                        extMenuItem.requestFocus();
                        extMenuItem.select();
                    }
                    ++n2;
                }
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.addListeners(containerEvent.getChild());
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.removeListeners(containerEvent.getChild());
    }

    void addListeners(Component component) {
        if (component == this) {
            return;
        }
        component.addMouseListener(this);
        component.addKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this);
            int n = 0;
            while (n < container.getComponentCount()) {
                this.addListeners(container.getComponent(n));
                ++n;
            }
        }
    }

    void removeListeners(Component component) {
        if (component == this) {
            return;
        }
        component.removeMouseListener(this);
        component.removeKeyListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            int n = 0;
            while (n < container.getComponentCount()) {
                this.removeListeners(container.getComponent(n));
                ++n;
            }
        }
    }

    public ExtMenuBar(boolean bl) {
        this.popup = bl;
        this.cur = new Vector();
        this.cur.addElement(this);
        if (!this.popup) {
            this.setBackground(SystemColor.control);
            this.setLayout(null);
            this.addKeyListener(this);
        } else {
            ExtMenuItem extMenuItem = new ExtMenuItem("", "", "", "");
            this.cur.addElement(extMenuItem);
            this.add(extMenuItem);
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed((ActionEvent)aWTEvent);
            }
            return;
        }
    }

    void push(ExtMenuItem extMenuItem) {
        if (this.popup) {
            this.closePopup();
        } else {
            this.exit();
        }
        if (extMenuItem.checkAble) {
            extMenuItem.checked = !extMenuItem.checked;
        }
        this.processEvent(new ActionEvent(this, 0, extMenuItem.action));
    }

    void exit() {
        this.closeAll();
        if (this.windowsFronted) {
            this.transferFocus();
        }
        this.windowsFronted = false;
        this.deselectAll();
    }

    void deselectAll() {
        int n = 0;
        while (n < this.getComponentCount()) {
            ExtMenuItem extMenuItem = (ExtMenuItem)this.getComponent(n);
            extMenuItem.mouseOver = false;
            extMenuItem.setColors();
            ++n;
        }
    }

    public void setStructure(String string) {
        if (!this.popup) {
            this.removeAll();
            this.mis.setSize(0);
            this.cur.setSize(0);
            this.cur.addElement(this);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", true);
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl = false;
            int n = 0;
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            if (!string3.equals("|")) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    string3 = stringTokenizer2.nextToken();
                    if (string3.equals("B")) {
                        bl = true;
                    }
                    if (!string3.equals("E")) continue;
                    ++n;
                }
                stringTokenizer.nextToken();
            }
            this.addItem(string2, bl);
            if (bl) {
                this.cur.addElement(this.mis.lastElement());
            }
            if (n <= 0) continue;
            this.cur.setSize(this.cur.size() - n);
        }
    }

    public void addItem(String string) {
        this.addItem(string, false);
    }

    void addItem(String string, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        if (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals(",")) {
            string2 = string;
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
        }
        if (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals(",")) {
            string3 = string;
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
        }
        if (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals(",")) {
            string4 = string;
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
        }
        if (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals(",")) {
            string5 = string;
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
        }
        ExtMenuItem extMenuItem = new ExtMenuItem(string2, string3, string4, string5);
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equals("-")) {
                bl4 = false;
            }
            if (string.equals("1")) {
                extMenuItem.checkAble = true;
                extMenuItem.checked = true;
            }
            if (!string.equals("0")) continue;
            extMenuItem.checkAble = true;
            extMenuItem.checked = false;
        }
        this.mis.addElement(extMenuItem);
        extMenuItem.addKeyListener(this);
        extMenuItem.setEnabled(bl4);
        if (string2.equals("---")) {
            extMenuItem.separator = true;
        }
        if (this.cur.lastElement() instanceof ExtMenuBar) {
            ((ExtMenuBar)this.cur.lastElement()).add(extMenuItem);
        } else {
            ((ExtMenuItem)this.cur.lastElement()).addMenuItem(extMenuItem);
            extMenuItem.parentMenuItem = (ExtMenuItem)this.cur.lastElement();
        }
    }

    public void openGroup(String string) {
        this.addItem(string, true);
        this.cur.addElement(this.mis.lastElement());
    }

    public void closeGroup() {
        this.cur.setSize(this.cur.size() - 1);
    }

    public void select(String string) {
        this.cur.setSize(0);
        this.cur.addElement(this.searchItemParent(string));
    }

    public void selectItem(String string) {
        this.cur.setSize(0);
        this.cur.addElement(this.searchItem(string));
    }

    public void removeAll(String string) {
        this.removeAll(this.searchItem(string));
    }

    public void remove(String string) {
        this.remove(this.searchItem(string));
    }

    void remove(ExtMenuItem extMenuItem) {
        extMenuItem.parentMenuItem.sub.removeElement(extMenuItem);
        if (extMenuItem.parentMenuItem.window != null) {
            extMenuItem.parentMenuItem.window.remove(extMenuItem);
        }
        this.mis.removeElement(extMenuItem);
    }

    void removeAll(ExtMenuItem extMenuItem) {
        int n = 0;
        while (n < extMenuItem.sub.size()) {
            ExtMenuItem extMenuItem2 = (ExtMenuItem)extMenuItem.sub.elementAt(n);
            this.mis.removeElement(extMenuItem2);
            if (extMenuItem2.sub != null) {
                this.removeAll(extMenuItem2);
            }
            ++n;
        }
        extMenuItem.sub = null;
        if (extMenuItem.window != null) {
            extMenuItem.window.removeAll();
        }
    }

    public void check(String string, boolean bl) {
        ExtMenuItem extMenuItem = this.searchItem(string);
        extMenuItem.checkAble = true;
        extMenuItem.checked = bl;
    }

    public boolean exists(String string) {
        return this.searchItem(string) != null;
    }

    public void setEnabled(String string, boolean bl) {
        this.searchItem(string).setEnabled(bl);
    }

    public void addActionListener(String string, ActionListener actionListener) {
        ExtMenuItem extMenuItem = this.searchItem(string);
        extMenuItem.addActionListener(actionListener);
    }

    public void removeActionListener(String string, ActionListener actionListener) {
        ExtMenuItem extMenuItem = this.searchItem(string);
        if (extMenuItem != null) {
            extMenuItem.removeActionListener(actionListener);
        }
    }

    ExtMenuItem searchItem(String string) {
        int n = 0;
        while (n < this.mis.size()) {
            if (((ExtMenuItem)this.mis.elementAt((int)n)).action.equals(string)) {
                return (ExtMenuItem)this.mis.elementAt(n);
            }
            ++n;
        }
        return null;
    }

    Object searchItemParent(String string) {
        int n = 0;
        while (n < this.mis.size()) {
            if (((ExtMenuItem)this.mis.elementAt((int)n)).action.equals(string)) {
                ExtMenuItem extMenuItem = (ExtMenuItem)this.mis.elementAt(n);
                if (extMenuItem.getParent() instanceof ExtMenuBar) {
                    return extMenuItem.getParent();
                }
                return extMenuItem.parentMenuItem;
            }
            ++n;
        }
        return null;
    }

    public void addNotify() {
        super.addNotify();
        Window window = Utils.getParentWin(this);
        this.dialogMenu = window instanceof Dialog;
        this.addListeners(window);
        window.addWindowListener(this);
        window.addComponentListener(this);
    }

    public void removeNotify() {
        Window window = Utils.getParentWin(this);
        this.removeListeners(window);
        window.removeWindowListener(this);
        window.removeComponentListener(this);
        super.removeNotify();
    }

    public void addToFrame(Frame frame) {
        this.addToFrame(frame, null);
    }

    public void addToFrame(Frame frame, Component component) {
        Component component2 = null;
        if (frame.getComponentCount() > 0) {
            component2 = frame.getComponent(0);
            frame.removeAll();
        }
        frame.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this, "West");
        if (component != null) {
            panel.add(component, "Center");
        }
        frame.add((Component)panel, "North");
        if (component2 != null) {
            frame.add(component2, "Center");
        }
        if (frame.isShowing()) {
            frame.validate();
        }
    }

    public void removeFromFrame(Frame frame) {
        frame.remove(this);
    }

    void closeAll() {
        if (this.popup) {
            this.closePopup();
        } else {
            int n = 0;
            while (n < this.getComponentCount()) {
                ExtMenuItem extMenuItem = (ExtMenuItem)this.getComponent(n);
                if (extMenuItem.opened) {
                    extMenuItem.close();
                }
                ++n;
            }
            this.fastOpen = false;
        }
    }

    public void showPopup(Component component, int n, int n2) {
        this.popupComponent = component;
        Window window = Utils.getParentWin(component);
        this.addListeners(window);
        window.addWindowListener(this);
        window.addComponentListener(this);
        ExtMenuItem extMenuItem = (ExtMenuItem)this.cur.elementAt(1);
        if (extMenuItem.window == null) {
            extMenuItem.window = extMenuItem.newWindow(Utils.getParentFrame(component));
            extMenuItem.window.addKeyListener(this);
            int n3 = 0;
            while (n3 < extMenuItem.sub.size()) {
                extMenuItem.window.add((ExtMenuItem)extMenuItem.sub.elementAt(n3));
                ++n3;
            }
        }
        Point point = component.getLocationOnScreen();
        extMenuItem.window.setLocation(point.x + n, point.y + n2);
        extMenuItem.window.pack();
        extMenuItem.window.show();
    }

    void closePopup() {
        ((ExtMenuItem)this.cur.elementAt(1)).close();
        Frame frame = Utils.getParentFrame(this.popupComponent);
        frame.addWindowListener(this);
        frame.addComponentListener(this);
        this.removeListeners(frame);
    }

    public void doLayout() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.getComponentCount()) {
            Dimension dimension = this.getComponent(n2).getPreferredSize();
            this.getComponent(n2).setBounds(n, 0, dimension.width, dimension.height);
            n += dimension.width;
            ++n2;
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        int n2 = 0;
        while (n2 < this.getComponentCount()) {
            Dimension dimension2 = this.getComponent(n2).getPreferredSize();
            if (dimension2.height > dimension.height) {
                dimension.height = dimension2.height;
            }
            n += dimension2.width;
            ++n2;
        }
        dimension.width = n;
        return dimension;
    }
}

