/*
 * Decompiled with CFR 0.152.
 */
package auto.awt.menu;

import auto.awt.HotKey;
import auto.awt.Utils;
import auto.awt.menu.ExtMenuBar;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class ExtMenuItem
extends Canvas
implements MouseListener,
MouseMotionListener {
    ItemWindow window;
    boolean opened = false;
    boolean mouseOver = false;
    Color activColor = Color.cyan.darker().darker();
    Vector sub;
    Insets insets = new Insets(1, 5, 2, 5);
    int pfeilWidth = 20;
    boolean useZoom = false;
    boolean separator = false;
    int bildWidth = 10;
    String text = "";
    int keyPos = -1;
    String action = "";
    HotKey hotkey;
    Image image;
    boolean enabled = true;
    ExtMenuItem parentMenuItem;
    boolean checkAble = false;
    boolean checked = false;
    static final Color hotkeyColor = Color.blue.darker().darker();
    ActionListener actionListener;
    int richtung = 0;

    public ExtMenuItem(String string, String string2, String string3, String string4) {
        this.action = string2;
        if (string3 != null && string3.length() > 0) {
            this.hotkey = new HotKey(string3);
        }
        if (string4 != null && string4.length() > 0) {
            this.image = Toolkit.getDefaultToolkit().getImage(string4);
            if (this.image != null) {
                int n = 0;
                while (!this.prepareImage(this.image, null) & n < 50) {
                    try {
                        Thread.sleep(10L);
                        n += 10;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        this.keyPos = string.indexOf("&");
        if (this.keyPos != -1) {
            string = string.substring(0, this.keyPos) + string.substring(this.keyPos + 1);
        }
        this.text = string;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed((ActionEvent)aWTEvent);
            }
            return;
        }
        super.processEvent(aWTEvent);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        this.repaint();
    }

    int getComponentNr(Container container, Component component) {
        int n = 0;
        while (n < container.getComponentCount()) {
            if (container.getComponent(n) == component) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    void selectNext(int n) {
        ExtMenuItem extMenuItem = this;
        Container container = this.getParent();
        do {
            extMenuItem = (ExtMenuItem)container.getComponent((this.getComponentNr(container, extMenuItem) + n + container.getComponentCount()) % container.getComponentCount());
        } while (extMenuItem.separator);
        extMenuItem.select();
    }

    void push() {
        this.getParentMenuBar().push(this);
        this.processEvent(new ActionEvent(this, 0, this.action));
    }

    void handleKey(KeyEvent keyEvent) {
        ExtMenuItem extMenuItem;
        switch (keyEvent.getKeyCode()) {
            case 10: 
            case 32: {
                if (!(this.sub == null & !this.separator & this.enabled)) break;
                this.push();
            }
        }
        boolean bl = false;
        if (this.getParent() == null) {
            return;
        }
        int n = 0;
        while (n < this.getParent().getComponentCount()) {
            extMenuItem = (ExtMenuItem)this.getParent().getComponent(n);
            if (extMenuItem != this && extMenuItem.keyPos != -1 && Character.toLowerCase(extMenuItem.text.charAt(extMenuItem.keyPos)) == Character.toLowerCase(keyEvent.getKeyChar())) {
                this.deselect();
                extMenuItem.select();
                if (extMenuItem.sub == null) {
                    extMenuItem.push();
                }
                bl = true;
            }
            ++n;
        }
        if (!bl && this.sub != null) {
            int n2 = 0;
            while (n2 < this.sub.size()) {
                extMenuItem = (ExtMenuItem)this.sub.elementAt(n2);
                if (extMenuItem.keyPos != -1 && Character.toLowerCase(extMenuItem.text.charAt(extMenuItem.keyPos)) == Character.toLowerCase(keyEvent.getKeyChar())) {
                    extMenuItem.select();
                    if (extMenuItem.sub == null) {
                        extMenuItem.push();
                    }
                }
                ++n2;
            }
        }
        if (this.getParent() instanceof ExtMenuBar) {
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    this.deselect();
                    this.selectNext(-1);
                    break;
                }
                case 39: {
                    this.deselect();
                    this.selectNext(1);
                    break;
                }
                case 40: {
                    if (this.sub == null) break;
                    ((ExtMenuItem)this.sub.elementAt(0)).select();
                }
            }
        } else {
            switch (keyEvent.getKeyCode()) {
                case 38: {
                    this.deselect();
                    this.selectNext(-1);
                    break;
                }
                case 40: {
                    this.deselect();
                    this.selectNext(1);
                    break;
                }
                case 39: {
                    if (this.sub != null) {
                        ((ExtMenuItem)this.sub.elementAt(0)).select();
                        break;
                    }
                    extMenuItem = this.parentMenuItem;
                    if (!(extMenuItem.getParent() instanceof ExtMenuBar)) break;
                    this.deselect();
                    extMenuItem.selectNext(1);
                    break;
                }
                case 37: {
                    this.deselect();
                    extMenuItem = this.parentMenuItem;
                    if (extMenuItem.getParent() instanceof ExtMenuBar) {
                        extMenuItem.selectNext(-1);
                        break;
                    }
                    extMenuItem.select();
                }
            }
        }
    }

    ExtMenuBar getParentMenuBar() {
        if (this.getParent() instanceof ExtMenuBar) {
            return (ExtMenuBar)this.getParent();
        }
        return this.parentMenuItem.getParentMenuBar();
    }

    public void paint(Graphics graphics) {
        Object object;
        int n;
        if (this.separator) {
            graphics.setColor(this.getBackground().darker());
            graphics.drawLine(2, this.insets.top - 1, this.getSize().width - 4, this.insets.top - 1);
            graphics.setColor(this.getBackground().brighter());
            graphics.drawLine(2, this.insets.top, this.getSize().width - 4, this.insets.top);
            return;
        }
        int n2 = this.insets.left;
        if (this.checked) {
            n = 1;
            while (n < 4) {
                graphics.drawLine(4, 5 + n, 6, 7 + n);
                graphics.drawLine(6, 7 + n, 10, 3 + n);
                ++n;
            }
        }
        if (this.image != null) {
            graphics.drawImage(this.image, n2, this.insets.top, null);
            n = this.image.getWidth(null) + 4;
            if (this.getParent() instanceof ItemWindow) {
                n = Math.max(n, this.bildWidth);
            }
            n2 += n;
        } else if (this.getParent() instanceof ItemWindow) {
            n2 += this.bildWidth;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (this.enabled) {
            graphics.drawString(this.text, n2, this.insets.top + fontMetrics.getAscent());
        } else {
            graphics.setColor(this.getBackground().brighter());
            graphics.drawString(this.text, n2 + 1, this.insets.top + fontMetrics.getAscent() + 1);
            graphics.setColor(this.getBackground().darker());
            graphics.drawString(this.text, n2, this.insets.top + fontMetrics.getAscent());
        }
        if (this.keyPos != -1) {
            graphics.drawLine(n2 + fontMetrics.stringWidth(this.text.substring(0, this.keyPos)), this.insets.top + fontMetrics.getAscent() + 2, n2 + fontMetrics.stringWidth(this.text.substring(0, this.keyPos + 1)), this.insets.top + fontMetrics.getAscent() + 2);
        }
        if (this.hotkey != null) {
            object = this.hotkey.toBetterString();
            graphics.setColor(hotkeyColor);
            graphics.drawString((String)object, this.getSize().width - fontMetrics.stringWidth((String)object) - 10, this.insets.top + fontMetrics.getAscent());
        }
        if (this.sub != null && this.getParent() instanceof ItemWindow) {
            object = new Point(this.getSize().width - 7, this.getSize().height / 2);
            int n3 = 0;
            while (n3 < 4) {
                graphics.drawLine(((Point)object).x + n3, ((Point)object).y - (3 - n3), ((Point)object).x + n3, ((Point)object).y + (3 - n3));
                ++n3;
            }
        }
        if (this.mouseOver & this.getParent() instanceof ExtMenuBar) {
            graphics.setColor(this.getBackground());
            graphics.draw3DRect(0, 0, this.getSize().width - 1, this.getSize().height - 1, !this.opened);
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension(this.insets.left + this.insets.right, this.insets.top + this.insets.bottom);
        if (this.separator) {
            return dimension;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        dimension.width += fontMetrics.stringWidth(this.text);
        boolean bl = this.getParent() instanceof ExtMenuBar;
        if (this.hotkey != null) {
            dimension.width += fontMetrics.stringWidth(this.hotkey.toBetterString()) + 20;
        }
        if (this.image != null) {
            int n = this.image.getWidth(null) + 4;
            if (!bl) {
                n = Math.max(n, this.bildWidth);
            }
            dimension.width += n;
        } else if (!bl) {
            dimension.width += this.bildWidth;
        }
        dimension.height += fontMetrics.getHeight();
        if (this.sub != null & !bl) {
            dimension.width += this.pfeilWidth;
        }
        return dimension;
    }

    void frontWindows() {
        this.window.toFront();
        this.getParentMenuBar().windowsFronted = true;
        int n = 0;
        while (n < this.sub.size()) {
            ExtMenuItem extMenuItem = (ExtMenuItem)this.sub.elementAt(n);
            if (extMenuItem.opened) {
                extMenuItem.frontWindows();
            }
            ++n;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.getParent() instanceof ExtMenuBar) {
            this.requestFocus();
            if (!this.getParentMenuBar().fastOpen) {
                this.getParentMenuBar().fastOpen = true;
                this.select();
            }
        }
        if (this.sub != null & this.getParent() instanceof ItemWindow & this.enabled) {
            this.frontWindows();
        }
        if (this.sub == null & !this.separator & this.enabled) {
            this.push();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.mouseOver) {
            this.mouseEntered(mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.getParent() instanceof ExtMenuBar) {
            this.mouseOver = true;
            this.repaint();
            if (!this.getParentMenuBar().fastOpen) {
                return;
            }
        }
        this.select();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseOver = false;
        if (this.getParent() instanceof ExtMenuBar) {
            this.repaint();
        }
        this.setColors();
    }

    void setColors() {
        if (this.opened | this.mouseOver) {
            this.setBackground(this.activColor);
            this.setForeground(Color.white);
        } else {
            this.setBackground(SystemColor.menu);
            this.setForeground(SystemColor.menuText);
        }
    }

    void close() {
        int n = 0;
        while (n < this.window.getComponentCount()) {
            ExtMenuItem extMenuItem = (ExtMenuItem)this.window.getComponent(n);
            if (extMenuItem.opened) {
                extMenuItem.close();
            }
            if (extMenuItem.mouseOver) {
                extMenuItem.mouseOver = false;
                extMenuItem.setColors();
            }
            ++n;
        }
        if (this.useZoom) {
            this.window.zoom(false);
        } else {
            this.window.setVisible(false);
        }
        this.opened = false;
        this.setColors();
    }

    void deselect() {
        if (this.opened) {
            this.close();
        }
        this.mouseOver = false;
        if (this.getParent() instanceof ExtMenuBar) {
            this.repaint();
        }
        this.setColors();
    }

    void select() {
        this.mouseOver = true;
        this.getParentMenuBar().selected = this;
        Container container = this.getParent();
        int n = 0;
        while (n < container.getComponentCount()) {
            ExtMenuItem extMenuItem = (ExtMenuItem)container.getComponent(n);
            if (extMenuItem != this && extMenuItem.mouseOver) {
                extMenuItem.deselect();
            }
            ++n;
        }
        if (!this.separator) {
            this.setColors();
        }
        if (!this.opened) {
            if (this.getParent() instanceof ItemWindow) {
                ((ItemWindow)this.getParent()).closeAll();
            } else {
                ((ExtMenuBar)this.getParent()).closeAll();
                ((ExtMenuBar)this.getParent()).fastOpen = true;
            }
            if (this.enabled) {
                this.open();
            }
        }
    }

    ItemWindow newWindow(Frame frame) {
        return new ItemWindow(frame);
    }

    Point calcLocation(int n) {
        Point point = this.getLocationOnScreen();
        if (this.getParent() instanceof ExtMenuBar) {
            switch (n) {
                case 0: {
                    point.y += this.getSize().height;
                    break;
                }
                case 1: {
                    point.y += this.getSize().height;
                    point.x -= this.window.getSize().width - this.getSize().width;
                    break;
                }
                case 2: {
                    point.y -= this.window.getSize().height;
                    point.x -= this.window.getSize().width - this.getSize().width;
                    break;
                }
                case 3: {
                    point.y -= this.window.getSize().height;
                }
            }
        } else {
            switch (n) {
                case 0: {
                    point.x += this.getSize().width;
                    break;
                }
                case 1: {
                    point.x -= this.window.getSize().width;
                    break;
                }
                case 2: {
                    point.x -= this.window.getSize().width;
                    point.y -= this.window.getSize().height - this.getSize().height;
                    break;
                }
                case 3: {
                    point.x += this.getSize().width;
                    point.y -= this.window.getSize().height - this.getSize().height;
                }
            }
        }
        return point;
    }

    boolean isPlace(int n) {
        Point point = this.calcLocation(n);
        if (point.x < 0 | point.y < 0) {
            return false;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        return !(point.x + this.window.getSize().width > dimension.width | point.y + this.window.getSize().height > dimension.height);
    }

    void open() {
        int n;
        if (this.sub == null) {
            return;
        }
        this.opened = true;
        if (this.window == null) {
            this.window = new ItemWindow(Utils.getParentFrame(this.getParentMenuBar()));
            this.window.addKeyListener(this.getParentMenuBar());
            n = 0;
            while (n < this.sub.size()) {
                this.window.add((ExtMenuItem)this.sub.elementAt(n));
                ++n;
            }
        }
        this.window.pack();
        this.richtung = this.getParent() instanceof ExtMenuBar ? 0 : ((ItemWindow)this.getParent()).getParentItem().richtung;
        n = this.richtung;
        boolean bl = false;
        while (!this.isPlace(n % 4) & n - this.richtung < 4) {
            ++n;
        }
        this.richtung = n % 4;
        this.window.setLocation(this.calcLocation(this.richtung));
        if (this.useZoom) {
            this.window.zoom(true);
        } else {
            this.window.show();
            if (this.getParentMenuBar().dialogMenu) {
                this.window.toFront();
                this.window.invalidate();
                this.window.repaint();
                this.window.validate();
            }
        }
    }

    public void addMenuItem(ExtMenuItem extMenuItem) {
        if (this.sub == null) {
            this.sub = new Vector();
        }
        this.sub.addElement(extMenuItem);
        if (this.window != null) {
            this.window.add(extMenuItem);
        }
    }

    public String toString() {
        return this.text + "," + this.action;
    }

    class ItemWindow
    extends Window
    implements Runnable {
        int border = 4;
        boolean zoomAuf = true;
        int zoomZ = 1;
        boolean zooming = false;
        Rectangle zoomR;

        ExtMenuItem getParentItem() {
            return ExtMenuItem.this;
        }

        public ItemWindow(Frame frame) {
            super(frame);
            this.setBackground(SystemColor.control);
            this.setLayout(null);
        }

        void zoom(boolean bl) {
            this.zoomAuf = bl;
            if (!this.zooming) {
                this.zoomZ = bl ? 1 : 99;
                this.zoomR = this.getBounds();
                new Thread(this).start();
            }
        }

        public void run() {
            this.zooming = true;
            while (this.zoomZ < 100 & this.zoomZ > 0) {
                this.zoomZ += this.zoomAuf ? 5 : -5;
                this.setBounds(this.zoomR.x, this.zoomR.y, this.zoomR.width * this.zoomZ / 100, this.zoomR.height * this.zoomZ / 100);
                if (this.zoomAuf && !this.isShowing()) {
                    this.show();
                }
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.zooming = false;
            if (!this.zoomAuf) {
                this.setVisible(false);
            }
        }

        void closeAll() {
            int n = 0;
            while (n < this.getComponentCount()) {
                ExtMenuItem extMenuItem = (ExtMenuItem)this.getComponent(n);
                if (extMenuItem.opened) {
                    extMenuItem.close();
                }
                ++n;
            }
        }

        public Dimension getPreferredSize() {
            Dimension dimension = new Dimension(0, 0);
            int n = 0;
            int n2 = 0;
            while (n2 < this.getComponentCount()) {
                Dimension dimension2 = this.getComponent(n2).getPreferredSize();
                if (dimension2.width > dimension.width) {
                    dimension.width = dimension2.width;
                }
                n += dimension2.height;
                ++n2;
            }
            dimension.width += 2 * this.border;
            dimension.height = n + 2 * this.border;
            return dimension;
        }

        public void doLayout() {
            int n = this.border;
            int n2 = this.getPreferredSize().width;
            int n3 = 0;
            while (n3 < this.getComponentCount()) {
                Dimension dimension = this.getComponent(n3).getPreferredSize();
                this.getComponent(n3).setBounds(this.border, n, n2 - this.border * 2, dimension.height);
                n += dimension.height;
                ++n3;
            }
        }

        public void paint(Graphics graphics) {
            Utils.draw3DRect(graphics, new Rectangle(0, 0, this.getSize().width, this.getSize().height), this.getBackground(), false);
            Utils.draw3DRect(graphics, new Rectangle(2, 2, this.getSize().width - 4, this.getSize().height - 4), this.getBackground(), true);
        }
    }
}

