/*
 * Decompiled with CFR 0.152.
 */
package auto.awt.menu;

import auto.awt.HotKey;
import auto.awt.menu.MenuAble;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import java.util.Vector;

public class NativeMenuBar
implements MenuAble,
ActionListener,
ItemListener {
    MenuBar mb;
    Vector miv = new Vector();
    ActionListener actionListener;
    Vector cur;

    public NativeMenuBar(boolean bl) {
        if (!bl) {
            this.mb = new MenuBar();
            this.cur = new Vector();
            this.cur.addElement(this.mb);
        } else {
            this.cur = new Vector();
            this.cur.addElement(new PopupMenu());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.actionPerformed(new ActionEvent(itemEvent.getSource(), 0, ""));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = "";
        int n = 0;
        while (n < this.miv.size()) {
            MenuItemCont menuItemCont = (MenuItemCont)this.miv.elementAt(n);
            if (menuItemCont.mi == actionEvent.getSource()) {
                string = menuItemCont.ret;
                break;
            }
            ++n;
        }
        this.processEvent(new ActionEvent(this, 0, string));
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed((ActionEvent)aWTEvent);
            }
            return;
        }
    }

    String noAnd(String string) {
        int n;
        while ((n = string.indexOf("&")) != -1) {
            string = string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    public void setStructure(String string) {
        if (this.mb != null) {
            while (this.mb.getMenuCount() > 0) {
                this.mb.remove(0);
            }
        }
        this.miv.setSize(0);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|", true);
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl = false;
            int n = 0;
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            string3 = stringTokenizer.nextToken();
            if (!string3.equals("|")) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
                while (stringTokenizer2.hasMoreTokens()) {
                    string3 = stringTokenizer2.nextToken();
                    if (string3.equals("B")) {
                        bl = true;
                    }
                    if (!string3.equals("E")) continue;
                    ++n;
                }
                stringTokenizer.nextToken();
            }
            this.addItem(string2, bl);
            if (bl) {
                this.cur.addElement(((MenuItemCont)this.miv.lastElement()).mi);
            }
            if (n <= 0) continue;
            this.cur.setSize(this.cur.size() - n);
        }
    }

    public void addToFrame(Frame frame) {
        frame.setMenuBar(this.mb);
        if (frame.isShowing()) {
            frame.validate();
        }
    }

    public void removeFromFrame(Frame frame) {
        frame.setMenuBar(null);
        if (frame.isShowing()) {
            frame.validate();
        }
    }

    public void addItem(String string) {
        this.addItem(string, false);
    }

    void addItem(String string, boolean bl) {
        MenuItem menuItem;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        int n = 0;
        if (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals(",")) {
            string2 = this.noAnd(string);
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
        }
        if (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals(",")) {
            string3 = string;
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
        }
        if (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals(",")) {
            string4 = string;
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
        }
        if (stringTokenizer.hasMoreTokens() && !(string = stringTokenizer.nextToken()).equals(",")) {
            string5 = string;
            if (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
            }
        }
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (string.equals("-")) {
                bl4 = false;
            }
            if (string.equals("1")) {
                n = 1;
            }
            if (!string.equals("0")) continue;
            n = 2;
        }
        if (string2.equals("---")) {
            menuItem = new MenuItem("-");
        } else if (bl) {
            menuItem = new Menu(string2);
        } else if (n == 0) {
            menuItem = new MenuItem(string2);
        } else {
            menuItem = new CheckboxMenuItem(string2, n == 1);
            ((CheckboxMenuItem)menuItem).addItemListener(this);
        }
        if (string4.length() > 0) {
            HotKey hotKey = new HotKey(string4);
            menuItem.setShortcut(new MenuShortcut(hotKey.keyCode[0], hotKey.shift[0]));
        }
        this.miv.addElement(new MenuItemCont(menuItem, string3, (MenuComponent)this.cur.lastElement()));
        menuItem.addActionListener(this);
        menuItem.setEnabled(bl4);
        if (this.cur.lastElement() instanceof MenuBar) {
            ((MenuBar)this.cur.lastElement()).add((Menu)menuItem);
        } else {
            ((Menu)this.cur.lastElement()).add(menuItem);
        }
    }

    public void openGroup(String string) {
        this.addItem(string, true);
        this.cur.addElement(((MenuItemCont)this.miv.lastElement()).mi);
    }

    public void closeGroup() {
        this.cur.setSize(this.cur.size() - 1);
    }

    public void select(String string) {
        this.cur.setSize(0);
        this.cur.addElement(this.searchItemParent(string));
    }

    public void selectItem(String string) {
        this.cur.setSize(0);
        this.cur.addElement(this.searchItem(string));
    }

    public void addActionListener(String string, ActionListener actionListener) {
        int n = this.searchNr(string);
        if (n == -1) {
            return;
        }
        MenuItemCont menuItemCont = (MenuItemCont)this.miv.elementAt(n);
        if (menuItemCont.mi instanceof CheckboxMenuItem) {
            menuItemCont.ita = new ItemToAction((CheckboxMenuItem)menuItemCont.mi);
            menuItemCont.ita.addActionListener(actionListener);
        } else {
            new ActionToAction(menuItemCont.mi).addActionListener(actionListener);
        }
    }

    public void removeActionListener(String string, ActionListener actionListener) {
        int n = this.searchNr(string);
        if (n == -1) {
            return;
        }
        MenuItemCont menuItemCont = (MenuItemCont)this.miv.elementAt(n);
        if (menuItemCont.mi instanceof CheckboxMenuItem) {
            menuItemCont.ita.removeActionListener(actionListener);
            menuItemCont.ita = null;
        } else {
            menuItemCont.mi.removeActionListener(actionListener);
        }
    }

    public void check(String string, boolean bl) {
        ((CheckboxMenuItem)this.searchItem(string)).setState(bl);
    }

    public boolean exists(String string) {
        return this.searchItem(string) != null;
    }

    public void setEnabled(String string, boolean bl) {
        ((MenuItem)this.searchItem(string)).setEnabled(bl);
    }

    public void removeAll(String string) {
        this.removeAll((Menu)this.searchItem(string));
    }

    public void remove(String string) {
        this.remove((MenuItem)this.searchItem(string));
    }

    void remove(MenuItem menuItem) {
        int n = this.miv.size() - 1;
        while (n >= 0) {
            if (((MenuItemCont)this.miv.elementAt((int)n)).mi == menuItem) {
                ((Menu)((MenuItemCont)this.miv.elementAt((int)n)).parent).remove(menuItem);
                this.miv.removeElementAt(n);
            }
            --n;
        }
    }

    void removeAll(Menu menu) {
        int n = menu.getItemCount() - 1;
        while (n >= 0) {
            MenuItem menuItem = menu.getItem(n);
            int n2 = this.miv.size() - 1;
            while (n2 >= 0) {
                if (((MenuItemCont)this.miv.elementAt((int)n2)).mi == menuItem) {
                    this.miv.removeElementAt(n2);
                }
                --n2;
            }
            if (menuItem instanceof Menu) {
                this.removeAll((Menu)menuItem);
            }
            --n;
        }
        menu.removeAll();
    }

    MenuComponent searchItemParent(String string) {
        int n = 0;
        while (n < this.miv.size()) {
            if (((MenuItemCont)this.miv.elementAt((int)n)).ret.equals(string)) {
                return ((MenuItemCont)this.miv.elementAt((int)n)).parent;
            }
            ++n;
        }
        return null;
    }

    public void showPopup(Component component, int n, int n2) {
        component.add((PopupMenu)this.cur.firstElement());
        ((PopupMenu)this.cur.firstElement()).show(component, n, n2);
    }

    MenuComponent searchItem(String string) {
        int n = this.searchNr(string);
        if (n == -1) {
            return null;
        }
        return ((MenuItemCont)this.miv.elementAt((int)n)).mi;
    }

    int searchNr(String string) {
        int n = 0;
        while (n < this.miv.size()) {
            if (((MenuItemCont)this.miv.elementAt((int)n)).ret.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static void main(String[] stringArray) {
    }

    class MenuItemCont {
        MenuComponent parent;
        MenuItem mi;
        String ret;
        ItemToAction ita;

        MenuItemCont(MenuItem menuItem, String string, MenuComponent menuComponent) {
            this.mi = menuItem;
            this.ret = string;
            this.parent = menuComponent;
        }
    }

    class ItemToAction
    implements ItemListener {
        ActionListener actionListener;

        public ItemToAction(CheckboxMenuItem checkboxMenuItem) {
            checkboxMenuItem.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            int n = 0;
            while (n < NativeMenuBar.this.miv.size()) {
                if (((MenuItemCont)NativeMenuBar.this.miv.elementAt((int)n)).mi == itemEvent.getSource() && this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(itemEvent.getSource(), 0, ((MenuItemCont)NativeMenuBar.this.miv.elementAt((int)n)).ret));
                }
                ++n;
            }
        }

        public void addActionListener(ActionListener actionListener) {
            this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
        }
    }

    class ActionToAction
    implements ActionListener {
        ActionListener actionListener;

        public ActionToAction(MenuItem menuItem) {
            menuItem.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            int n = 0;
            while (n < NativeMenuBar.this.miv.size()) {
                MenuItemCont menuItemCont = (MenuItemCont)NativeMenuBar.this.miv.elementAt(n);
                if (menuItemCont.mi == actionEvent.getSource()) {
                    string = menuItemCont.ret;
                    break;
                }
                ++n;
            }
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(actionEvent.getSource(), 0, string));
            }
        }

        public void addActionListener(ActionListener actionListener) {
            this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
        }
    }
}

