/*
 * Decompiled with CFR 0.152.
 */
package auto.awt.teim;

import auto.awt.ColorDialog;
import auto.awt.ExtScrollPane;
import auto.awt.Utils;
import auto.awt.teim.Line;
import auto.awt.teim.Obj;
import auto.awt.teim.Teim;
import auto.awt.teim.TeimUtils;
import auto.awt.teim.Text;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;

public final class TeimEditor
implements Runnable,
KeyListener,
MouseListener,
ActionListener,
ItemListener,
FocusListener {
    Teim teim;
    int xC;
    int yC;
    int cX;
    int cY;
    int cW = 2;
    int cH = 10;
    boolean isCursor = false;
    Button colB;
    Button saveB;
    Checkbox boldC;
    Checkbox italicC;
    TextField nameT;
    TextField sizeT;
    Color newCol;
    Font newFont;
    String fn;
    private Line curLine;
    private Text curText;
    private int curTextPos;
    private int curTextI;

    public TeimEditor(Teim teim) {
        this.teim = teim;
        this.teim.addKeyListener(this);
        this.teim.addMouseListener(this);
        Dialog dialog = new Dialog(Utils.getParentFrame(teim), "Text Format", false);
        dialog.setLayout(new FlowLayout(0));
        dialog.add(new Label("Name:"));
        this.nameT = new TextField(5);
        dialog.add(this.nameT);
        this.nameT.addFocusListener(this);
        this.boldC = new Checkbox("Bold");
        dialog.add(this.boldC);
        this.boldC.addItemListener(this);
        this.italicC = new Checkbox("Italic");
        dialog.add(this.italicC);
        this.italicC.addItemListener(this);
        dialog.add(new Label("Size:"));
        this.sizeT = new TextField(5);
        dialog.add(this.sizeT);
        this.sizeT.addFocusListener(this);
        this.colB = new Button("Color");
        dialog.add(this.colB);
        this.colB.addActionListener(this);
        this.saveB = new Button("Save");
        dialog.add(this.saveB);
        this.saveB.addActionListener(this);
        ((Component)dialog).setBackground(Color.lightGray);
        dialog.pack();
        ((Component)dialog).setLocation(100, 10);
        dialog.show();
        this.setCursor(0, 0, false);
    }

    public void setFn(String string) {
        this.fn = string;
        Utils.getParentFrame(this.teim).setTitle(string);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        ((Component)Utils.getParentFrame(this.teim)).setBounds(n, n2, n3, n4);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.colB) {
            this.newCol = this.teim.getCol(ColorDialog.process(Utils.getParentFrame(this.teim), this.colB.getBackground()));
            this.colB.setBackground(this.newCol);
        }
        if (actionEvent.getSource() == this.saveB) {
            try {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.fn)));
                Rectangle rectangle = Utils.getParentFrame(this.teim).getBounds();
                printWriter.println("(do");
                printWriter.println("(set t (new \"auto.awt.teim.Teim\"))");
                printWriter.println("(set tu (new \"auto.awt.teim.TeimUtils\"))");
                printWriter.println("(set esp (tu.showWindow t))");
                int n = 0;
                while (n < this.teim.lines.size()) {
                    Line line = (Line)this.teim.lines.elementAt(n);
                    int n2 = 0;
                    while (n2 < line.objects.size()) {
                        Obj obj = (Obj)line.objects.elementAt(n2);
                        if (obj instanceof Text) {
                            Text text = (Text)obj;
                            if (!(text.text.length() == 0 & n2 < line.objects.size() - 1)) {
                                Color color = text.col;
                                Font font = text.font;
                                printWriter.println("(tu.appendText \"" + text.text + (n2 == line.objects.size() - 1 ? "\r\n" : "") + "\" t esp " + color.getRed() + " " + color.getGreen() + " " + color.getBlue() + " \"" + font.getName() + "\" " + font.getStyle() + " " + font.getSize() + ")");
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
                printWriter.println("(set te (new \"auto.awt.teim.TeimEditor\" t))");
                printWriter.println("(te.start esp)");
                printWriter.println("(te.setFn \"" + this.fn + "\")");
                printWriter.println("(te.setBounds " + rectangle.x + " " + rectangle.y + " " + rectangle.width + " " + rectangle.height + ")");
                printWriter.println(")");
                printWriter.close();
                System.out.println("saved " + this.fn + ".");
                return;
            }
            catch (Exception exception) {
                System.out.println(exception);
                return;
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.calcNewFont();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.calcNewFont();
        this.teim.requestFocus();
    }

    void calcNewFont() {
        this.newFont = this.teim.getFon(this.nameT.getText(), (this.boldC.getState() ? 1 : 0) | (this.italicC.getState() ? 2 : 0), Integer.parseInt(this.sizeT.getText()));
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 39: {
                this.setCursor(this.xC + 1, this.yC, true);
                return;
            }
            case 37: {
                this.setCursor(this.xC - 1, this.yC, true);
                return;
            }
            case 38: {
                this.setCursor(this.xC, this.yC - 1, true);
                return;
            }
            case 40: {
                this.setCursor(this.xC, this.yC + 1, true);
                return;
            }
            case 10: {
                this.lineBreak();
                return;
            }
            case 8: {
                this.backChar();
                return;
            }
            default: {
                char c = keyEvent.getKeyChar();
                if (c == '\u0000') break;
                this.insertChar(c);
            }
            case 127: 
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.teim.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    void calcLine(int n, boolean bl) {
        int n2 = bl ? this.teim.lines.size() - 1 : n;
        int n3 = this.teim.getLine((int)n).y;
        int n4 = n;
        while (n4 <= n2) {
            Line line = this.teim.getLine(n4);
            line.y = n3;
            int n5 = 5;
            int n6 = 0;
            int n7 = 0;
            while (n7 < line.objects.size()) {
                Obj obj = (Obj)line.objects.elementAt(n7);
                obj.x = n5;
                n5 += obj.w;
                n6 = Math.max(n6, obj.h);
                ++n7;
            }
            n3 += n6 - 3;
            ++n4;
        }
    }

    void calcCurEnv() {
        this.curText = null;
        this.curLine = (Line)this.teim.lines.elementAt(this.yC);
        int n = this.xC;
        int n2 = 0;
        while (n2 < this.curLine.objects.size()) {
            int n3;
            Obj obj = (Obj)this.curLine.objects.elementAt(n2);
            int n4 = n3 = obj instanceof Text ? ((Text)obj).text.length() : 1;
            if (n > n3) {
                n -= n3;
            } else {
                if (!(obj instanceof Text)) {
                    return;
                }
                this.curText = (Text)obj;
                this.curTextPos = n;
                this.curTextI = n2;
                return;
            }
            ++n2;
        }
    }

    void lineBreak() {
        this.calcCurEnv();
        if (this.curText == null) {
            System.out.println("kein text..");
            return;
        }
        Text text = new Text(this.curText.text.substring(this.curTextPos), this.curText.font, this.curText.col, this.teim, 0, 0);
        this.curText.setText(this.curText.text.substring(0, this.curTextPos));
        Line line = new Line(this.curLine.y + 20);
        line.objects.addElement(text);
        int n = this.curTextI + 1;
        while (n < this.curLine.objects.size()) {
            line.objects.addElement(this.curLine.objects.elementAt(n));
            ++n;
        }
        this.curLine.objects.setSize(this.curTextI + 1);
        this.teim.lines.insertElementAt(line, this.yC + 1);
        this.calcLine(this.yC, true);
        this.setCursor(0, this.yC + 1, false);
        this.teim.repaint();
    }

    void backChar() {
        this.calcCurEnv();
        if (this.curText == null) {
            System.out.println("kein text..");
            return;
        }
        if (this.curTextPos > 0) {
            this.curText.setText(String.valueOf(this.curText.text.substring(0, this.curTextPos - 1)) + this.curText.text.substring(this.curTextPos));
            this.calcLine(this.yC, false);
            this.setCursor(this.xC - 1, this.yC, false);
        }
        this.teim.repaint();
    }

    void insertChar(char c) {
        this.calcCurEnv();
        if (this.curText == null) {
            System.out.println("kein text..");
            return;
        }
        String string = this.curText.text.substring(0, this.curTextPos);
        String string2 = this.curText.text.substring(this.curTextPos);
        boolean bl = false;
        if (this.newCol != null && this.curText.col != this.newCol) {
            bl = true;
        }
        if (this.newFont != null && this.curText.font != this.newFont) {
            bl = true;
        }
        if (bl) {
            if (this.newFont == null) {
                this.newFont = this.curText.font;
            }
            if (this.newCol == null) {
                this.newCol = this.curText.col;
            }
            Text text = new Text(string2, this.curText.font, this.curText.col, this.teim, 0, 0);
            this.curLine.objects.insertElementAt(text, this.curTextI + 1);
            text = new Text(String.valueOf(c), this.newFont, this.newCol, this.teim, 0, 0);
            this.curLine.objects.insertElementAt(text, this.curTextI + 1);
            this.curText.setText(string);
            this.calcLine(this.yC, true);
        } else {
            this.curText.setText(String.valueOf(string) + c + string2);
            this.calcLine(this.yC, false);
        }
        this.setCursor(this.xC + 1, this.yC, false);
        this.teim.repaint();
    }

    void guiUpdate() {
        this.newCol = null;
        this.newFont = null;
        this.calcCurEnv();
        if (this.curText == null) {
            return;
        }
        this.colB.setBackground(this.curText.col);
        ((TextComponent)this.nameT).setText(String.valueOf(this.curText.font.getName()));
        ((TextComponent)this.sizeT).setText(String.valueOf(this.curText.font.getSize()));
        this.boldC.setState((this.curText.font.getStyle() & 1) > 0);
        this.italicC.setState((this.curText.font.getStyle() & 2) > 0);
    }

    void setCursor(int n, int n2, boolean bl) {
        n = Math.max(n, 0);
        n2 = Math.max(n2, 0);
        n2 = Math.min(this.teim.lines.size() - 1, n2);
        Line line = (Line)this.teim.lines.elementAt(n2);
        int n3 = 0;
        int n4 = 0;
        while (n4 < line.objects.size()) {
            Obj obj = (Obj)line.objects.elementAt(n4);
            n3 += obj instanceof Text ? ((Text)obj).text.length() : 1;
            ++n4;
        }
        int n5 = n = Math.min(n, n3);
        int n6 = 5;
        int n7 = line.y;
        int n8 = 10;
        int n9 = 2;
        int n10 = 0;
        while (n10 < line.objects.size()) {
            int n11;
            Obj obj = (Obj)line.objects.elementAt(n10);
            int n12 = n11 = obj instanceof Text ? ((Text)obj).text.length() : 1;
            if (n5 > n11) {
                n5 -= n11;
                n6 += obj.w;
            } else {
                if (obj instanceof Text) {
                    Text text = (Text)obj;
                    n6 += text.fm.stringWidth(text.text.substring(0, n5));
                } else {
                    n6 += obj.w / 2;
                }
                n8 = obj.h;
                n9 = n8 / 6 + 1;
                break;
            }
            ++n10;
        }
        if (this.isCursor) {
            this.drawCursor();
        }
        this.xC = n;
        this.yC = n2;
        this.cX = n6;
        this.cY = n7;
        this.cH = n8;
        this.cW = n9;
        if (bl) {
            this.drawCursor();
        }
        this.guiUpdate();
    }

    synchronized void drawCursor() {
        Graphics graphics = this.teim.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        graphics.fillRect(this.cX + this.teim.gX, this.cY + this.teim.gY, this.cW, this.cH);
        graphics.dispose();
        this.isCursor = !this.isCursor;
    }

    public void start(ExtScrollPane extScrollPane) {
        new Thread(this).start();
        this.teim.requestFocus();
        extScrollPane.setScrollPosition(new Point(0, 0));
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {}
            this.drawCursor();
        }
    }

    public static void main(String[] stringArray) {
        Teim teim = new Teim();
        ExtScrollPane extScrollPane = TeimUtils.showWindow((Teim)teim);
        TeimUtils.appendText("Hello ", teim, extScrollPane, Color.white, new Font("Dialog", 0, 11));
        TeimUtils.appendText("World", teim, extScrollPane, Color.yellow, new Font("Dialog", 0, 20));
        TeimUtils.appendText(" wazzup", teim, extScrollPane, Color.white, new Font("Dialog", 0, 11));
        TeimUtils.appendText(" fett ", teim, extScrollPane, Color.white, new Font("Dialog", 1, 11));
        TeimUtils.appendText("wazzup\nnice lallal allall alalla lal\nuiui iuuiuiui", teim, extScrollPane, Color.white, new Font("Dialog", 0, 11));
        TeimUtils.appendText(" fett ", teim, extScrollPane, Color.red, new Font("Dialog", 1, 11));
        TeimUtils.appendText("wazzup\nnice lallal allall alalla lal\nuiui iuuiuiui uiuiu iuiu uiuiiu", teim, extScrollPane, Color.white, new Font("Dialog", 0, 11));
        TeimUtils.appendText("wazzup\n\n", teim, extScrollPane, Color.white, new Font("Dialog", 0, 11));
        TeimUtils.appendText("\n\nwazzup nice lallal kdfjgkljdfgkjdlj\nlfj glj fjdgj jdfljdj ljkldfkj ld\njslj lj ljgkfjdlsfdgjlfd jdfkjgldfj\nldjf fldjljldfj gkldfj ldfjl\n\n", teim, extScrollPane, Color.white, new Font("Dialog", 0, 11));
        TeimUtils.appendText("\n\nwazzup nice lallal kdfjgkljdfgkjdlj\nlfj glj fjdgj jdfljdj ljkldfkj ld\njslj lj ljgkfjdlsfdgjlfd jdfkjgldfj\nldjf fldjljldfj gkldfj ldfjl\n\n", teim, extScrollPane, Color.white, new Font("Dialog", 0, 11));
        TeimUtils.appendText("\n\nwazzup nice lallal kdfjgkljdfgkjdlj\nlfj glj fjdgj jdfljdj ljkldfkj ld\njslj lj ljgkfjdlsfdgjlfd jdfkjgldfj\nldjf fldjljldfj gkldfj ldfjl\n\n", teim, extScrollPane, Color.white, new Font("Dialog", 0, 11));
        TeimEditor teimEditor = new TeimEditor(teim);
        teimEditor.start(extScrollPane);
    }
}

