/*
 * Decompiled with CFR 0.152.
 */
package auto.awt.teim;

import auto.awt.ExtScrollPane;
import auto.awt.ImageManager;
import auto.awt.teim.Img;
import auto.awt.teim.Line;
import auto.awt.teim.Obj;
import auto.awt.teim.Teim;
import auto.awt.teim.Text;
import auto.util.awt.MainFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.FileReader;

public final class TeimUtils {
    static Font shellFont = new Font("Dialog", 0, 10);

    public static int getLineW(Line line, int n) {
        if (line.objects.size() > 0) {
            Obj obj = (Obj)line.objects.lastElement();
            return obj.x + obj.w;
        }
        return n;
    }

    public static int getLineH(Line line) {
        int n = 0;
        int n2 = line.objects.size() - 1;
        while (n2 >= 0) {
            Obj obj = (Obj)line.objects.elementAt(n2);
            n = Math.max(obj.h + obj.y, n);
            --n2;
        }
        return n;
    }

    public static void appendImg(String string, Teim teim, ExtScrollPane extScrollPane, int n, int n2, int n3) {
        Object object;
        if (teim.lines.size() == 0) {
            teim.lines.addElement(new Line(0));
        }
        Line line = (Line)teim.lines.lastElement();
        int n4 = 5;
        if (line.objects.size() > 0) {
            object = (Obj)line.objects.lastElement();
            n4 = ((Obj)object).x + ((Obj)object).w;
        }
        line.objects.addElement(new Img(teim.getImg(string), teim, n4, n3, n, n2));
        teim.gH = line.y + TeimUtils.getLineH(line);
        teim.repaint();
        if (extScrollPane != null) {
            object = teim.getGraphicsSize();
            Dimension dimension = teim.getSize();
            extScrollPane.setScrollPosition(new Point(0, Math.max(0, ((Dimension)object).height - dimension.height)));
        }
    }

    public static void appendText(String string, Teim teim, ExtScrollPane extScrollPane, Color color) {
        TeimUtils.appendText(string, teim, extScrollPane, color, shellFont);
    }

    public static void appendText(String string, Teim teim, ExtScrollPane extScrollPane, int n, int n2, int n3, String string2, int n4, int n5) {
        TeimUtils.appendText(string, teim, extScrollPane, teim.getCol(new Color(n, n2, n3)), teim.getFon(string2, n4, n5));
    }

    public static void appendText(String string, Teim teim, ExtScrollPane extScrollPane, Color color, Font font) {
        TeimUtils.appendText(string, teim, extScrollPane, color, font, 3);
    }

    public static Text appendText(String string, Teim teim, ExtScrollPane extScrollPane, Color color, Font font, int n) {
        Object e;
        String string2;
        if (teim.lines.size() == 0) {
            teim.lines.addElement(new Line(0));
        }
        Line line = (Line)teim.lines.lastElement();
        int n2 = string.indexOf("\n");
        if (n2 == -1) {
            string2 = string;
            string = null;
        } else {
            string2 = string.substring(0, n2);
            if (string2.endsWith("\r")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            string = string.substring(n2 + 1);
        }
        Text text = null;
        if (line.objects.size() > 0 && (e = line.objects.lastElement()) instanceof Text) {
            text = (Text)e;
        }
        if (text != null && text.col != color | text.font != font) {
            text = null;
        }
        if (text != null) {
            text.setText(text.text + string2);
        } else {
            text = new Text(string2, font, color, teim, TeimUtils.getLineW(line, 5), 0, 3, true);
            line.objects.addElement(text);
        }
        teim.gW = Math.max(teim.gW, text.w + text.x);
        while (string != null) {
            if (string.length() == 0) {
                line = new Line(line.y + TeimUtils.getLineH(line));
                teim.lines.addElement(line);
                break;
            }
            n2 = string.indexOf("\n");
            if (n2 == -1) {
                string2 = string;
                string = null;
            } else {
                string2 = string.substring(0, n2);
                if (string2.endsWith("\r")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                string = string.substring(n2 + 1);
            }
            line = new Line(line.y + TeimUtils.getLineH(line));
            text = new Text(string2, font, color, teim, 5, 0, 3, true);
            line.objects.addElement(text);
            teim.lines.addElement(line);
            teim.gW = Math.max(teim.gW, text.w + text.x);
        }
        teim.gH = line.y + TeimUtils.getLineH(line);
        teim.repaint();
        if (extScrollPane != null) {
            int n3 = line.y + TeimUtils.getLineH(line) + 20;
            Dimension dimension = teim.getSize();
            extScrollPane.setScrollPosition(new Point(0, Math.max(0, n3 - dimension.height)));
        }
        return text;
    }

    public static void appendTextAsync(String string, Teim teim, ExtScrollPane extScrollPane, Color color, Font font) {
        if (font == null) {
            font = shellFont;
        }
        if (teim.thread == null) {
            teim.thread = new Thread(teim);
            teim.thread.start();
        }
        teim.appendV.addElement(new Object[]{string, extScrollPane, color, font});
    }

    public static Line appendLine(Teim teim, int n) {
        Line line;
        if (teim.lines.size() > 0) {
            line = (Line)teim.lines.lastElement();
            n = line.y + TeimUtils.getLineH(line);
        }
        line = new Line(n);
        teim.lines.addElement(line);
        return line;
    }

    public static ExtScrollPane showWindow(Teim teim, String string) {
        ExtScrollPane extScrollPane = teim.withScrollPane();
        extScrollPane.setBackground(Color.black);
        Frame frame = MainFrame.mainFrame((String)string, (Component)extScrollPane, (boolean)true);
        frame.setIconImage(ImageManager.getImage("auto/awt/teim/icon.jpg", frame));
        return extScrollPane;
    }

    public static void textFileToTeim(String string, Teim teim) {
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            int n = 0;
            Font font = new Font("Dialog", 0, 9);
            Color[] colorArray = new Color[]{Color.yellow, Color.white, Color.lightGray, Color.gray};
            int n2 = 0;
            Image image = teim.getImg("jediBg_.jpg");
            while ((string2 = bufferedReader.readLine()) != null) {
                Line line = new Line(n);
                if (++n2 % 30 == 0) {
                    line.objects.addElement(new Img(image, teim, 60, 0));
                    n += 100;
                }
                Text text = new Text(string2, font, colorArray[n2 / 3 % colorArray.length], teim, 5, 0);
                line.objects.addElement(text);
                n += text.h;
                teim.lines.addElement(line);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }
}

