/*
 * Decompiled with CFR 0.152.
 */
package auto.awt.teim.bg;

import auto.awt.teim.Teim;
import auto.awt.teim.TeimBgAble;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.PixelGrabber;

public class ImgFlow
implements TeimBgAble,
Runnable,
KeyListener {
    int w = 100;
    int h = 100;
    int x;
    int y;
    Color[] d = new Color[this.w * this.h];
    Teim teim;
    Color col = new Color(200, 200, 150);
    long lastKeyTime = System.currentTimeMillis();
    int iw;
    int ih;
    Color[] ca;

    public void draw(Graphics graphics) {
        Dimension dimension = this.teim.getSize();
        int n = dimension.width / this.w + 1;
        int n2 = dimension.height / this.h + 1;
        int n3 = 0;
        while (n3 < this.h) {
            int n4 = 0;
            while (n4 < this.w) {
                graphics.setColor(this.d[n3 * this.w + n4]);
                graphics.fillRect(n4 * n, n3 * n2, n, n2);
                ++n4;
            }
            ++n3;
        }
    }

    void makeRaster() {
        int n = 0;
        while (n < this.h) {
            int n2 = 0;
            while (n2 < this.w) {
                this.d[n * this.w + n2] = this.ca[(n + this.y) * this.iw + n2 + this.x];
                ++n2;
            }
            ++n;
        }
    }

    public ImgFlow(Teim teim) {
        Image image = teim.getImg("d:/grafik/ref/151.jpe");
        try {
            while (!teim.prepareImage(image, teim)) {
                Thread.sleep(50L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.iw = image.getWidth(teim);
        this.ih = image.getHeight(teim);
        int[] nArray = new int[this.iw * this.ih];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.iw, this.ih, nArray, 0, this.iw);
        try {
            pixelGrabber.grabPixels();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.ca = new Color[nArray.length];
        int n = nArray.length - 1;
        while (n >= 0) {
            int n2 = nArray[n];
            this.ca[n] = teim.getCol(n2 >> 16 & 0xFF, n2 >> 8 & 0xFF, n2 & 0xFF);
            --n;
        }
        this.makeRaster();
        this.teim = teim;
        this.teim.addKeyListener(this);
        new Thread(this).start();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.lastKeyTime = System.currentTimeMillis();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void run() {
        while (true) {
            if (this.teim.isShowing()) {
                ++this.y;
                if (this.y > this.ih - this.h) {
                    this.y = 0;
                    this.x += this.w;
                    if (this.x > this.iw - this.w) {
                        this.x = 0;
                    }
                }
                this.makeRaster();
                this.teim.repaint();
            }
            int n = (int)(System.currentTimeMillis() - this.lastKeyTime);
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
            }
        }
    }
}

