/*
 * Decompiled with CFR 0.152.
 */
package auto.awt.teimfold;

import auto.awt.ExtScrollPane;
import auto.awt.Utils;
import auto.awt.fold.Fold;
import auto.awt.teim.Img;
import auto.awt.teim.Line;
import auto.awt.teim.Obj;
import auto.awt.teim.Rect;
import auto.awt.teim.Teim;
import auto.awt.teim.TeimMouseAble;
import auto.awt.teim.TeimUtils;
import auto.awt.teim.Text;
import auto.awt.teimfold.RenderData;
import auto.awt.teimfold.TfEdit;
import auto.awt.teimfold.TfEnv;
import auto.awt.teimfold.TfFormat;
import auto.awt.teimfold.TfJavaEnv;
import auto.awt.teimfold.TfLivaEnv;
import auto.awt.teimfold.TfTexEnv;
import auto.awt.teimfold.TfTextEnv;
import java.awt.Color;
import java.awt.Font;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public final class TeimFold
implements TeimMouseAble {
    public Fold fold;
    public Teim teim;
    ExtScrollPane esp;
    Font rdFont;
    Color col;
    Color lastDepthCol;
    Color[] depthCol;
    Hashtable iconFoldH = new Hashtable();
    public TfEnv env;
    public TfEdit edit;
    public String fn;
    public String lastEnding = "*";
    public char[] passwd = null;
    public String descr = null;
    public Properties properties = new Properties();
    int fmtPos;

    public TeimFold(Teim teim, ExtScrollPane extScrollPane, String string, boolean bl) {
        this.teim = teim;
        this.esp = extScrollPane;
        this.depthCol = new Color[]{this.teim.getCol(235, 235, 225), this.teim.getCol(250, 250, 240), this.teim.getCol(240, 240, 220)};
        this.rdFont = this.teim.getFon("Sansserif", 2, 9);
        this.col = this.teim.getCol(20, 20, 0);
        this.esp.setBackground(teim.getCol(220, 220, 210));
        this.teim.tma = this;
        if (bl) {
            this.edit = new TfEdit(this);
        }
        if (string != null) {
            this.loadFile(string, null);
        } else {
            this.env = new TfJavaEnv();
            this.newOne();
        }
    }

    void initNewLoad() {
        this.properties.clear();
        this.teim.rV2.setSize(0);
    }

    public void newOne() {
        this.initNewLoad();
        this.fold = this.env.newOne();
        this.renderAll();
        this.edit.setCursor(0, 0);
        this.fn = null;
    }

    public void setFn(String string) {
        this.fn = string;
        if (this.fn == null) {
            return;
        }
        int n = this.fn.indexOf(".");
        if (n != -1) {
            this.lastEnding = this.fn.substring(n + 1);
        }
    }

    public void loadFile(String string, InputStream inputStream) {
        Object object;
        this.setFn(string);
        String string2 = string;
        if (string2 != null && string2.endsWith(".cr")) {
            string2 = string2.substring(0, string2.length() - 3);
        }
        this.env = string2 == null ? new TfJavaEnv() : (string2.endsWith(".java") ? new TfJavaEnv() : (string2.endsWith(".t.txt") ? new TfTextEnv() : (string2.endsWith(".tex") ? new TfTexEnv() : new TfLivaEnv())));
        try {
            this.fold = this.env.load(inputStream);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initNewLoad();
        if (this.fold.fV == null) {
            System.err.println("fold.fV is null");
            return;
        }
        int n = this.fold.fV.size();
        int n2 = 0;
        int n3 = 0;
        String string3 = this.env.lineComment + "fr";
        while (((String)(object = this.fold.at((int)(--n)).title)).startsWith(string3)) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)(object = ((String)object).substring(string3.length() + 1)), ",");
            String string4 = stringTokenizer.nextToken();
            if (string4.equals("o")) {
                this.openFolder(this.fold, stringTokenizer);
            }
            if (string4.equals("p")) {
                n2 = Integer.parseInt(stringTokenizer.nextToken().trim());
                n3 = Integer.parseInt(stringTokenizer.nextToken().trim());
            }
            if (string4.equals("x")) {
                this.properties.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
            }
            this.fold.fV.setSize(n);
        }
        if (n == this.fold.fV.size() - 1) {
            n = 0;
            while (n < this.fold.fV.size()) {
                object = this.fold.at(n);
                if (((Fold)object).fV != null) {
                    ((Fold)object).open = true;
                    break;
                }
                ++n;
            }
        }
        if ((object = (String)this.properties.get("teimtext.right")) != null) {
            this.teim.rV2.addElement(new Text((String)object, this.teim.getFon("Dialog", 1, 15), this.teim.getCol(100, 100, 100), this.teim, 0, 0));
        }
        this.fold.open = true;
        this.renderAll();
        if (this.edit != null) {
            this.edit.wasChange = false;
            this.edit.calcLineNr(this.fold, 0);
            this.edit.setCursor(n2, n3);
        }
    }

    void openFolder(Fold fold, StringTokenizer stringTokenizer) {
        if (fold.fV == null) {
            return;
        }
        if (!stringTokenizer.hasMoreTokens()) {
            fold.open = true;
            return;
        }
        int n = Integer.parseInt(stringTokenizer.nextToken().trim());
        if (fold.fV.size() <= n) {
            return;
        }
        this.openFolder(fold.at(n), stringTokenizer);
    }

    public void start() {
        if (this.edit != null) {
            this.edit.start();
        }
    }

    public void stop() {
        if (this.edit != null) {
            this.edit.stop();
        }
    }

    public static int addToLine(Teim teim, Line line, String string, TfFormat tfFormat, int n, int n2) {
        Text text = new Text(string, teim.getFon(tfFormat.fontName, tfFormat.fontStyle, tfFormat.fontSize), teim.getCol(tfFormat.red, tfFormat.green, tfFormat.blue), teim, n, n2, tfFormat.dH, false);
        line.objects.addElement(text);
        return n += text.w;
    }

    int countBackSlash(String string, int n) {
        int n2 = 0;
        while (n >= 0 && string.charAt(n) == '\\') {
            --n;
            ++n2;
        }
        return n2;
    }

    int formatToLine(String string, int n, int n2, Line line) {
        if (string.trim().length() == 0) {
            n = TeimFold.addToLine(this.teim, line, string, this.env.emptyLineFmt, n, n2);
        } else {
            int n3 = 0;
            StringBuffer stringBuffer = new StringBuffer("");
            int n4 = this.env.genFmts.size() - 1;
            while (n4 >= 0) {
                ((TfFormat)this.env.genFmts.elementAt(n4)).checkInitLine();
                --n4;
            }
            while (n3 < string.length()) {
                Object object;
                int n5;
                Object object2;
                int n6;
                char c = string.charAt(n3);
                boolean bl = false;
                int n7 = 0;
                while (n7 < this.env.keyFormats.size()) {
                    TfFormat tfFormat = (TfFormat)this.env.keyFormats.elementAt(n7);
                    n6 = tfFormat.keys.length - 1;
                    while (n6 >= 0) {
                        object2 = tfFormat.keys[n6];
                        if (!(!string.substring(n3).startsWith((String)object2) || n3 > 0 && Character.isLetter(string.charAt(n3)) && Character.isLetter(string.charAt(n3 - 1)) || (n5 = n3 + ((String)object2).length()) < string.length() && Character.isLetter(string.charAt(n5 - 1)) && Character.isLetter(string.charAt(n5)))) {
                            if (stringBuffer.length() > 0) {
                                n = TeimFold.addToLine(this.teim, line, stringBuffer.toString(), this.env.defFormat, n, n2);
                                stringBuffer.setLength(0);
                            }
                            n = TeimFold.addToLine(this.teim, line, (String)object2, tfFormat, n, n2);
                            n3 += ((String)object2).length();
                            bl = true;
                            break;
                        }
                        --n6;
                    }
                    if (bl) break;
                    ++n7;
                }
                if (bl) continue;
                if (this.env.commentLineFmt != null && string.substring(n3).startsWith(this.env.commentLineFmt.key)) {
                    if (stringBuffer.length() > 0) {
                        n = TeimFold.addToLine(this.teim, line, stringBuffer.toString(), this.env.defFormat, n, n2);
                        stringBuffer.setLength(0);
                    }
                    n = TeimFold.addToLine(this.teim, line, string.substring(n3), this.env.commentLineFmt, n, n2);
                    n3 = string.length();
                    continue;
                }
                boolean bl2 = false;
                n6 = this.env.stringFmts.size() - 1;
                while (n6 >= 0) {
                    object2 = (TfFormat)this.env.stringFmts.elementAt(n6);
                    if (string.substring(n3).startsWith(((TfFormat)object2).key)) {
                        n5 = n3;
                        while (++n5 < string.length()) {
                            if (!string.substring(n5).startsWith(((TfFormat)object2).key) || this.countBackSlash(string, n5 - 1) % 2 == 1) continue;
                            n5 += ((TfFormat)object2).key.length();
                            break;
                        }
                        object = string.substring(n3, n5);
                        if (stringBuffer.length() > 0) {
                            n = TeimFold.addToLine(this.teim, line, stringBuffer.toString(), this.env.defFormat, n, n2);
                            stringBuffer.setLength(0);
                        }
                        n = TeimFold.addToLine(this.teim, line, (String)object, (TfFormat)object2, n, n2);
                        n3 = n5;
                        bl2 = true;
                        break;
                    }
                    --n6;
                }
                if (bl2) continue;
                if (this.env.numericFmt != null) {
                    boolean bl3 = false;
                    if (n3 > 0) {
                        bl3 = Character.isLetter(string.charAt(n3 - 1)) | Character.isDigit(string.charAt(n3 - 1));
                    }
                    if (Character.isDigit(c) & !bl3) {
                        char c2;
                        n5 = n3;
                        while (++n5 < string.length() && (Character.isDigit(c2 = string.charAt(n5)) || c2 == '.')) {
                        }
                        object = string.substring(n3, n5);
                        if (stringBuffer.length() > 0) {
                            n = TeimFold.addToLine(this.teim, line, stringBuffer.toString(), this.env.defFormat, n, n2);
                            stringBuffer.setLength(0);
                        }
                        n = TeimFold.addToLine(this.teim, line, (String)object, this.env.numericFmt, n, n2);
                        n3 = n5;
                        continue;
                    }
                }
                boolean bl4 = false;
                n5 = this.env.genFmts.size() - 1;
                while (n5 >= 0) {
                    object = (TfFormat)this.env.genFmts.elementAt(n5);
                    if (((TfFormat)object).check(string, n3, this)) {
                        if (stringBuffer.length() > 0) {
                            n = TeimFold.addToLine(this.teim, line, stringBuffer.toString(), this.env.defFormat, n, n2);
                            stringBuffer.setLength(0);
                        }
                        n = ((TfFormat)object).format(this.teim, line, n, n2);
                        n3 = this.fmtPos;
                        bl4 = true;
                        break;
                    }
                    --n5;
                }
                if (bl4) continue;
                stringBuffer.append(c);
                ++n3;
            }
            if (stringBuffer.length() > 0) {
                n = TeimFold.addToLine(this.teim, line, stringBuffer.toString(), this.env.defFormat, n, n2);
                stringBuffer.setLength(0);
            }
        }
        return n;
    }

    void renderFold(Fold fold, int n, Vector vector) {
        int n2;
        Img img;
        RenderData renderData;
        int n3;
        Line line = TeimUtils.appendLine(this.teim, n == 0 ? this.env.yD : 0);
        line.o = fold;
        boolean bl = false;
        if (this.env.doLastOpen) {
            if (fold.fV != null) {
                bl = true;
                int n4 = fold.fV.size() - 1;
                while (n4 >= 0) {
                    if (fold.at((int)n4).fV != null) {
                        bl = false;
                        break;
                    }
                    --n4;
                }
            }
            if (bl) {
                fold.open = true;
            }
        }
        String string = fold.title + (fold.fV == null ? "" : (fold.open ? this.env.openS : this.env.openCloseS));
        int n5 = fold.open ? this.env.yTop : 0;
        int n6 = n3 = this.env.xD + n * this.env.xDepth;
        if (fold.open) {
            int n7 = this.env.genFmts.size() - 1;
            while (n7 >= 0) {
                ((TfFormat)this.env.genFmts.elementAt(n7)).checkEnterFold();
                --n7;
            }
        }
        n3 = this.formatToLine(string, n3, n5, line);
        int n8 = n3 - n6;
        int n9 = TeimUtils.getLineH(line);
        if (fold.open) {
            if (vector.size() > 0) {
                ((RenderData)vector.lastElement()).hasSubOpens = true;
            }
            renderData = new RenderData();
            renderData.text = fold.title;
            vector.addElement(renderData);
            if (!bl) {
                img = new Img(this.teim.imgPool.getImg("auto/awt/teimfold/minus.gif", this.teim), this.teim, this.env.xD + n * this.env.xDepth - 11 - this.env.xBorder, n9 / 2 - 4, 9, 9);
                line.objects.addElement(img);
                this.iconFoldH.put(img, fold);
            }
        } else {
            if (fold.fV != null) {
                img = new Img(this.teim.imgPool.getImg("auto/awt/teimfold/plus.gif", this.teim), this.teim, this.env.xD + n * this.env.xDepth - 11 - this.env.xBorder, n9 / 2 - 4, 9, 9);
                line.objects.addElement(img);
                this.iconFoldH.put(img, fold);
            }
            renderData = (RenderData)vector.lastElement();
        }
        int n10 = 0;
        while (n10 < vector.size()) {
            ((RenderData)vector.elementAt((int)n10)).lines.addElement(line);
            ++n10;
        }
        renderData.w = Math.max(renderData.w, n8 + (fold.open ? 0 : this.env.xDepth));
        if (fold.open) {
            Line line2;
            n2 = 0;
            while (n2 < fold.fCount()) {
                this.renderFold(fold.at(n2), n + 1, vector);
                ++n2;
            }
            line = TeimUtils.appendLine(this.teim, 0);
            int n11 = 0;
            while (n11 < vector.size()) {
                ((RenderData)vector.elementAt((int)n11)).lines.addElement(line);
                ++n11;
            }
            n6 = this.env.xD + n * this.env.xDepth;
            n3 = this.formatToLine(this.env.closeS, n6, 0, line);
            n9 = TeimUtils.getLineH(line);
            renderData.w = Math.max(renderData.w, n3 - n6);
            vector.setSize(vector.size() - 1);
            Color color = this.depthCol[n % this.depthCol.length];
            renderData.w += 20;
            int n12 = 0;
            while (n12 < renderData.lines.size()) {
                line2 = (Line)renderData.lines.elementAt(n12);
                int n13 = TeimUtils.getLineH(line2) + (n12 == renderData.lines.size() - 1 ? this.env.yBorder : 0) - (n12 == 0 ? this.env.yTop - this.env.yTopBorder : 0);
                int n14 = n12 == 0 ? this.env.yTop - this.env.yTopBorder : 0;
                line2.objects.insertElementAt(new Rect(this.teim.getCol(0, 0, 0), this.env.xD - this.env.xBorder + n * this.env.xDepth, n14, 1, n13), 0);
                line2.objects.insertElementAt(new Rect(this.teim.getCol(0, 0, 0), this.env.xD + this.env.xBorder + n * this.env.xDepth + renderData.w, n14, 1, n13), 0);
                this.teim.gW = Math.max(this.teim.gW, this.env.xD + this.env.xBorder + n * this.env.xDepth + renderData.w + 5);
                line2.objects.insertElementAt(new Rect(color, this.env.xD - this.env.xBorder + n * this.env.xDepth, n14, renderData.w + 2 * this.env.xBorder, n13), 0);
                ++n12;
            }
            line2 = (Line)renderData.lines.firstElement();
            line2.objects.insertElementAt(new Rect(this.teim.getCol(0, 0, 0), this.env.xD - this.env.xBorder + n * this.env.xDepth, this.env.yTop - this.env.yTopBorder, renderData.w + 2 * this.env.xBorder, 1), 1);
            line2 = (Line)renderData.lines.lastElement();
            line2.objects.insertElementAt(new Rect(this.teim.getCol(0, 0, 0), this.env.xD - this.env.xBorder + n * this.env.xDepth, n9 - 1 + this.env.yBorder, renderData.w + 2 * this.env.xBorder, 1), 1);
            Text text = new Text(".. " + renderData.text, this.rdFont, this.teim.getCol(color.getRed() - 50, color.getGreen() - 50, color.getBlue() - 50), this.teim, 0, 0);
            text.real = false;
            text.x = this.env.xD + n * this.env.xDepth + renderData.w - text.w;
            text.y = n9 - text.h - 2 + this.env.yBorder;
            line2.objects.insertElementAt(text, 1);
        }
        if (fold.open) {
            n2 = this.env.genFmts.size() - 1;
            while (n2 >= 0) {
                ((TfFormat)this.env.genFmts.elementAt(n2)).checkExitFold();
                --n2;
            }
        }
    }

    public void renderAll() {
        Object object;
        this.teim.gW = 0;
        this.teim.clear();
        this.iconFoldH.clear();
        int n = this.env.genFmts.size() - 1;
        while (n >= 0) {
            ((TfFormat)this.env.genFmts.elementAt(n)).checkInit();
            --n;
        }
        int n2 = 0;
        while (n2 < this.fold.fV.size()) {
            object = new Vector<RenderData>();
            ((Vector)object).addElement(new RenderData());
            this.renderFold(this.fold.at(n2), 0, (Vector)object);
            ++n2;
        }
        object = (Line)this.teim.lines.lastElement();
        this.teim.gH = ((Line)object).y + TeimUtils.getLineH((Line)object);
        this.teim.repaint();
        this.teim.getParent().getParent().doLayout();
    }

    int getLineNr(Fold fold) {
        int n = this.teim.lines.size() - 1;
        while (n >= 0) {
            Line line = this.teim.getLine(n);
            if (line.o == fold) {
                return n;
            }
            --n;
        }
        return -1;
    }

    void toggleFolder(Fold fold) {
        fold.open = !fold.open;
        Fold fold2 = this.edit != null ? this.edit.getFold(this.edit.yC, true) : null;
        this.renderAll();
        if (!fold.open && this.edit != null) {
            this.edit.folderClosed(fold2);
        }
    }

    public void mousePressed(Obj obj, int n, int n2) {
        if (obj instanceof Img) {
            this.toggleFolder((Fold)this.iconFoldH.get(obj));
        }
    }

    public void mouseMoved(Obj obj, int n, int n2) {
    }

    public void selectPos(int n, int n2, int n3) {
        if (this.edit != null) {
            this.edit.selectPos(n, n2, n3);
        }
    }

    public static TeimFold teimInit(Teim teim, ExtScrollPane extScrollPane) {
        TeimFold teimFold = new TeimFold(teim, extScrollPane, "data/test/text.t.txt", true);
        teimFold.start();
        return teimFold;
    }

    public static void main(String[] stringArray) {
        Teim teim = new Teim();
        ExtScrollPane extScrollPane = teim.withScrollPane();
        Utils.mainFrame(extScrollPane);
        TeimFold.teimInit(teim, extScrollPane);
    }
}

