/*
 * Decompiled with CFR 0.152.
 */
package auto.awt.teimfold;

import auto.anim.outlay.Outlay;
import auto.awt.teim.Img;
import auto.awt.teim.Line;
import auto.awt.teim.Obj;
import auto.awt.teim.Rect;
import auto.awt.teim.Teim;
import auto.awt.teim.Text;
import auto.awt.teimfold.FormObj;
import auto.awt.teimfold.TeimFold;
import auto.awt.teimfold.TfFormat;
import java.awt.Image;
import java.util.Stack;
import java.util.StringTokenizer;

class TextFormat
extends TfFormat {
    TfFormat defFmt;
    Object fmtO;
    boolean isBold = false;
    boolean isItalic = false;
    static int testW;
    static int testH;
    static int testLen;
    static int testR;
    static int testG;
    static int testB;
    static int testSi;
    static String testS;
    static Outlay outlay;
    static final String FORM_S = "$";
    Stack stack = new Stack();

    public TextFormat(String string, int n, int n2, int n3, int n4, int n5, int n6) {
        super(string, n, n2, n3, n4, n5, n6);
        this.defFmt = new TfFormat(string, n, n2, n3, n4, n5, n6);
    }

    static boolean testRect(String string, int n) {
        if (!string.startsWith("\\r{")) {
            return false;
        }
        int n2 = string.indexOf("}", n);
        if (n2 == -1) {
            return false;
        }
        String string2 = string.substring(n + 3, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        try {
            testW = Integer.parseInt(stringTokenizer.nextToken());
            testH = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            return false;
        }
        if (testW <= 0 | testH <= 0) {
            return false;
        }
        testLen = n2 - n + 1;
        return true;
    }

    static boolean testForm(String string, int n) {
        if (!string.startsWith(FORM_S)) {
            return false;
        }
        int n2 = string.indexOf(FORM_S, n + 1);
        if (n2 == -1) {
            return false;
        }
        testS = string.substring(n + FORM_S.length(), n2);
        testLen = n2 - n + FORM_S.length();
        return true;
    }

    static boolean testCol(String string, int n) {
        if (!string.startsWith("\\c{")) {
            return false;
        }
        int n2 = string.indexOf("}", n);
        if (n2 == -1) {
            return false;
        }
        String string2 = string.substring(n + 3, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (stringTokenizer.countTokens() != 3) {
            return false;
        }
        try {
            testR = Integer.parseInt(stringTokenizer.nextToken());
            testG = Integer.parseInt(stringTokenizer.nextToken());
            testB = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            return false;
        }
        if (testR < 0 | testG < 0 | testB < 0 | testR > 255 | testG > 255 | testB > 255) {
            return false;
        }
        testLen = n2 - n + 1;
        return true;
    }

    static boolean testSize(String string, int n) {
        if (!string.startsWith("\\s{")) {
            return false;
        }
        int n2 = string.indexOf("}", n);
        if (n2 == -1) {
            return false;
        }
        String string2 = string.substring(n + 3, n2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        if (stringTokenizer.countTokens() != 1) {
            return false;
        }
        try {
            testSi = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (Exception exception) {
            return false;
        }
        if (testSi <= 0) {
            return false;
        }
        testLen = n2 - n + 1;
        return true;
    }

    static boolean testImg(String string, int n) {
        if (!string.startsWith("\\i{")) {
            return false;
        }
        int n2 = string.indexOf("}", n);
        if (n2 == -1) {
            return false;
        }
        testS = string.substring(n + 3, n2);
        testLen = n2 - n + 1;
        return true;
    }

    public void checkInit() {
        this.isBold = false;
        this.isItalic = false;
        this.fontSize = this.defFmt.fontSize;
        this.fontStyle = this.defFmt.fontStyle;
        this.fontName = this.defFmt.fontName;
        this.red = this.defFmt.red;
        this.blue = this.defFmt.blue;
        this.green = this.defFmt.green;
    }

    public void checkInitLine() {
    }

    public void checkEnterFold() {
        this.stack.push(new TfFormat(this.fontName, this.fontStyle, this.fontSize, this.red, this.green, this.blue, this.dH));
    }

    public void checkExitFold() {
        TfFormat tfFormat = (TfFormat)this.stack.pop();
        this.fontName = tfFormat.fontName;
        this.fontStyle = tfFormat.fontStyle;
        this.fontSize = tfFormat.fontSize;
        this.red = tfFormat.red;
        this.green = tfFormat.green;
        this.blue = tfFormat.blue;
        this.dH = tfFormat.dH;
        this.isBold = (this.fontStyle & 1) > 0;
        this.isItalic = (this.fontStyle & 2) > 0;
    }

    int iof(String string, String string2, int n) {
        int n2 = string.indexOf(string2, n + 1);
        if (n2 == -1) {
            n2 = Integer.MAX_VALUE;
        }
        return n2;
    }

    public static int jumpControls(String string, int n) {
        while (true) {
            String string2 = string.substring(n);
            String string3 = "\\b ";
            if (string2.startsWith("\\b ")) {
                n += string3.length();
                continue;
            }
            string3 = "\\i ";
            if (string2.startsWith("\\i ")) {
                n += string3.length();
                continue;
            }
            if (string2.startsWith("\\\\")) {
                n += 2;
                continue;
            }
            if (string2.startsWith("\\0")) {
                n += 2;
                continue;
            }
            if (string2.startsWith("\\1")) {
                n += 2;
                continue;
            }
            if (string2.startsWith("\\2")) {
                n += 2;
                continue;
            }
            if (string2.startsWith("\\7")) {
                n += 2;
                continue;
            }
            if (string2.startsWith("\\8")) {
                n += 2;
                continue;
            }
            if (string2.startsWith("\\9")) {
                n += 2;
                continue;
            }
            if (string2.startsWith("\\rect")) {
                n += 5;
                continue;
            }
            if (TextFormat.testForm(string2, 0)) {
                n += testLen;
                continue;
            }
            if (TextFormat.testRect(string2, 0)) {
                n += testLen;
                continue;
            }
            if (TextFormat.testImg(string2, 0)) {
                n += testLen;
                continue;
            }
            if (TextFormat.testCol(string2, 0)) {
                n += testLen;
                continue;
            }
            if (!TextFormat.testSize(string2, 0)) break;
            n += testLen;
        }
        return n;
    }

    Text dummyText(TeimFold teimFold) {
        return new Text("", teimFold.teim.getFon(this.fontName, this.fontStyle, this.fontSize), teimFold.teim.getCol(this.red, this.green, this.blue), teimFold.teim, 0, 0, 0, false);
    }

    public boolean check(String string, int n, TeimFold teimFold) {
        String string2 = null;
        String string3 = string.substring(n);
        boolean bl = true;
        string2 = "\\\\";
        if (string3.startsWith("\\\\")) {
            this.fmtO = new Text("\\", teimFold.teim.getFon(this.fontName, this.fontStyle, this.fontSize), teimFold.teim.getCol(this.red, this.green, this.blue), teimFold.teim, 0, 0, 0, false);
            teimFold.fmtPos = n + string2.length();
            return true;
        }
        string2 = "\\b ";
        if (string3.startsWith("\\b ")) {
            this.isBold = !this.isBold;
            this.fontStyle = (this.isBold ? 1 : 0) | (this.isItalic ? 2 : 0);
            this.fmtO = this.dummyText(teimFold);
            teimFold.fmtPos = n + string2.length();
            return true;
        }
        string2 = "\\i ";
        if (string3.startsWith("\\i ")) {
            this.isItalic = !this.isItalic;
            this.fontStyle = (this.isBold ? 1 : 0) | (this.isItalic ? 2 : 0);
            this.fmtO = this.dummyText(teimFold);
            teimFold.fmtPos = n + string2.length();
            return true;
        }
        string2 = "\\7";
        if (string3.startsWith("\\7")) {
            this.fontName = "Serif";
            this.fmtO = this.dummyText(teimFold);
            teimFold.fmtPos = n + string2.length();
            return true;
        }
        string2 = "\\8";
        if (string3.startsWith("\\8")) {
            this.fontName = "Sansserif";
            this.fmtO = this.dummyText(teimFold);
            teimFold.fmtPos = n + string2.length();
            return true;
        }
        string2 = "\\9";
        if (string3.startsWith("\\9")) {
            this.fontName = "Monospaced";
            this.fmtO = this.dummyText(teimFold);
            teimFold.fmtPos = n + string2.length();
            return true;
        }
        if (TextFormat.testCol(string3, 0)) {
            this.red = testR;
            this.green = testG;
            this.blue = testB;
            this.fmtO = this.dummyText(teimFold);
            teimFold.fmtPos = n + testLen;
            return true;
        }
        if (TextFormat.testSize(string3, 0)) {
            this.fontSize = testSi;
            this.fmtO = this.dummyText(teimFold);
            teimFold.fmtPos = n + testLen;
            return true;
        }
        if (TextFormat.testForm(string3, 0)) {
            this.fmtO = new FormObj(testS, teimFold);
            teimFold.fmtPos = n + testLen;
            return true;
        }
        if (TextFormat.testRect(string3, 0)) {
            this.fmtO = new Rect(teimFold.teim.getCol(this.red, this.green, this.blue), 0, 0, testW, testH);
            teimFold.fmtPos = n + testLen;
            return true;
        }
        if (TextFormat.testImg(string3, 0)) {
            float f = 1.0f;
            int n2 = testS.indexOf(" ");
            if (n2 != -1) {
                f = Float.parseFloat(testS.substring(n2 + 1));
                testS = testS.substring(0, n2);
            }
            Image image = teimFold.teim.imgPool.getScaledImg(testS, teimFold.teim, f);
            this.fmtO = new Img(image, teimFold.teim, 0, 0, 1.0f);
            teimFold.fmtPos = n + testLen;
            return true;
        }
        bl = false;
        int n3 = n + (bl ? string2.length() : 0);
        int n4 = Math.min(Math.min(Math.min(Math.min(this.iof(string, "\\b ", n3), this.iof(string, FORM_S, n3)), this.iof(string, "\\i ", n3)), this.iof(string, "\\\\", n3)), Math.min(Math.min(this.iof(string, "\\7", n3), Math.min(this.iof(string, "\\8", n3), this.iof(string, "\\9", n3))), Math.min(Math.min(this.iof(string, "\\i{", n3), this.iof(string, "\\r{", n3)), Math.min(this.iof(string, "\\c{", n3), this.iof(string, "\\s{", n3)))));
        if (n4 == Integer.MAX_VALUE) {
            n4 = -1;
        }
        if (n4 == -1) {
            this.fmtO = string.substring(n3);
            teimFold.fmtPos = string.length();
        } else {
            this.fmtO = string.substring(n3, n4);
            teimFold.fmtPos = n4;
        }
        this.fontStyle = (this.isBold ? 1 : 0) | (this.isItalic ? 2 : 0);
        return true;
    }

    public int format(Teim teim, Line line, int n, int n2) {
        if (this.fmtO == null) {
            return n;
        }
        if (this.fmtO instanceof String) {
            return TeimFold.addToLine(teim, line, (String)this.fmtO, this, n, n2);
        }
        if (this.fmtO instanceof Obj) {
            Obj obj = (Obj)this.fmtO;
            obj.x = n;
            obj.y = n2;
            line.objects.addElement(obj);
            return n + obj.w;
        }
        return n;
    }

    static {
        outlay = new Outlay();
    }
}

