/*
 * Decompiled with CFR 0.152.
 */
package auto.awt.teimfold;

import auto.awt.ExtScrollPane;
import auto.awt.fold.Fold;
import auto.awt.fold.IO;
import auto.awt.teim.Line;
import auto.awt.teim.Teim;
import auto.awt.teim.Text;
import auto.awt.teimfold.TeimFold;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.PrintWriter;
import java.util.Stack;

public final class TfEdit
implements Runnable,
KeyListener,
FocusListener {
    int cX = 0;
    int cY = 0;
    int cW = 2;
    int cH = 10;
    public int xC = 0;
    public int yC = 0;
    boolean isCursor = false;
    boolean isRunning = false;
    public Runnable escRunner;
    TeimFold tf;
    Teim teim;
    ExtScrollPane esp;
    Stack closeStack = new Stack();
    public boolean wasChange = false;
    boolean hasFocus = true;
    public String foldPath = "";
    public Runnable statusRunnable = null;
    int xCh;

    public TfEdit(TeimFold teimFold) {
        this.tf = teimFold;
        this.teim = this.tf.teim;
        this.esp = this.tf.esp;
    }

    int calcLineNr(Fold fold, int n) {
        fold.lineNr = n++;
        if (fold.fV == null) {
            return n;
        }
        int n2 = 0;
        while (n2 < fold.fV.size()) {
            n = this.calcLineNr(fold.at(n2), n);
            ++n2;
        }
        return ++n;
    }

    public void save(String string, PrintWriter printWriter) {
        try {
            this.tf.env.save(this.tf.fold, printWriter, string, this);
            this.setChange(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void copyFold(Fold fold, String string, StringBuffer stringBuffer) {
        if (fold.fV == null) {
            stringBuffer.append(string + "\n");
            return;
        }
        stringBuffer.append("\\f" + (fold.open ? "-" : "+") + " " + string + "\n");
        int n = 0;
        while (n < fold.fV.size()) {
            Fold fold2 = fold.at(n);
            this.copyFold(fold2, fold2.title, stringBuffer);
            ++n;
        }
        stringBuffer.append("\\fc\n");
    }

    public void copy() {
        Object object;
        Fold fold;
        if (this.teim.rselLi0 == -1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("");
        int n = Integer.MAX_VALUE;
        int n2 = this.teim.rselLi0;
        while (n2 <= this.teim.rselLi1) {
            fold = this.getFold(n2, false);
            if (fold != null) {
                n = Math.min(n, fold.calcDepth());
            }
            ++n2;
        }
        fold = this.getFold(this.teim.rselLi0, true);
        int n3 = fold.calcDepth() - n;
        if (n3 > 0) {
            int n4 = 0;
            while (n4 < n3) {
                stringBuffer.append("\\f+ ulu\n");
                ++n4;
            }
        }
        int n5 = this.teim.rselLi0;
        while (n5 <= this.teim.rselLi1) {
            object = this.getFold(n5, false);
            if (object == null) {
                stringBuffer.append("\\fc\n");
            } else {
                int n6 = 0;
                int n7 = ((Fold)object).title.length();
                if (n5 == this.teim.rselLi0) {
                    n6 = this.tf.env.getFoldPos(this.teim, this.teim.rselLi0, this.teim.rselTi0, this.teim.rsel0);
                }
                if (n5 == this.teim.rselLi1 && (n7 = this.tf.env.getFoldPos(this.teim, this.teim.rselLi1, this.teim.rselTi1, this.teim.rsel1)) == 0) break;
                String string = ((Fold)object).title.substring(n6, n7);
                if (((Fold)object).fV != null & n5 < this.teim.rselLi1) {
                    if (((Fold)object).open) {
                        stringBuffer.append("\\f- " + string + "\n");
                    } else {
                        this.copyFold((Fold)object, string, stringBuffer);
                    }
                } else {
                    stringBuffer.append(string + (n5 < this.teim.rselLi1 ? "\n" : ""));
                }
            }
            ++n5;
        }
        object = new StringSelection(stringBuffer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents((Transferable)object, (ClipboardOwner)object);
    }

    Fold newNextFold(Fold fold) {
        Fold fold2 = fold.parent;
        int n = fold2.fV.indexOf(fold);
        fold = new Fold("");
        fold.parent = fold2;
        fold2.fV.insertElementAt(fold, n + 1);
        return fold;
    }

    public void paste() {
        Transferable transferable = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this);
        try {
            String string = transferable.getTransferData(DataFlavor.stringFlavor).toString();
            Fold fold = this.getFold(this.yC, false);
            if (fold == null) {
                return;
            }
            this.setChange(true);
            String string2 = fold.title.substring(this.xC);
            int n = 0;
            while (true) {
                Fold fold2;
                int n2;
                if ((n2 = string.indexOf("\n")) == -1) break;
                String string3 = string.substring(0, n2);
                string = string.substring(n2 + 1);
                boolean bl = false;
                boolean bl2 = false;
                if (string3.startsWith("\\f- ")) {
                    bl = true;
                    string3 = string3.substring(4);
                } else if (string3.startsWith("\\f+ ")) {
                    bl2 = true;
                    string3 = string3.substring(4);
                } else if (string3.equals("\\fc")) {
                    fold2 = fold = fold.parent;
                    fold2.fV.setSize(fold2.fV.size() - 1);
                    fold = this.newNextFold(fold);
                    if (n == 0) {
                        this.xC = 0;
                        ++this.yC;
                    }
                    if (fold2.open) continue;
                    --n;
                    continue;
                }
                fold.title = fold.title.substring(0, this.xC) + string3;
                if (bl | bl2) {
                    fold2 = new Fold("");
                    fold.add(fold2);
                    fold.open = bl;
                    fold = fold2;
                } else {
                    fold = this.newNextFold(fold);
                }
                if (n == 0) {
                    this.xC = 0;
                    ++this.yC;
                }
                if (!bl2) continue;
                ++n;
            }
            fold.title = fold.title.substring(0, this.xC) + string + string2;
            this.lineRenderAll();
            this.setCursor(this.xC + string.length(), this.yC);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    void naviKey(int n, int n2, KeyEvent keyEvent) {
        this.checkClearSelection(keyEvent);
        if (keyEvent.isShiftDown() && !this.teim.isSelection()) {
            this.tf.env.getTiPos(this.teim, this.xC, this.yC);
            this.teim.setSel0(this.tf.env.gotPos, this.yC, this.tf.env.gotTi);
        }
        this.closeStack.setSize(0);
        this.setCursor(n, n2);
        if (keyEvent.isShiftDown()) {
            this.tf.env.getTiPos(this.teim, this.xC, this.yC);
            this.teim.setSel1(this.tf.env.gotPos, this.yC, this.tf.env.gotTi);
        }
    }

    void checkClearSelection(KeyEvent keyEvent) {
        if (!keyEvent.isShiftDown() && this.teim.clearSelection()) {
            this.teim.repaint();
        }
    }

    boolean checkRemoveSelection() {
        if (!this.teim.isSelection()) {
            return false;
        }
        int n = this.teim.rselLi0;
        int n2 = this.tf.env.getFoldPos(this.teim, n, this.teim.rselTi0, this.teim.rsel0);
        int n3 = this.teim.rselLi1;
        int n4 = this.tf.env.getFoldPos(this.teim, n3, this.teim.rselTi1, this.teim.rsel1);
        int n5 = n3;
        while (n5 >= n) {
            Fold fold = this.getFold(n5, false);
            if (fold != null) {
                if (n5 > n & n5 < n3) {
                    fold.parent.fV.removeElement(fold);
                } else {
                    int n6 = n5 == n ? n2 : 0;
                    int n7 = n5 == n3 ? n4 : this.getFold((int)n5, (boolean)true).title.length();
                    fold.title = fold.title.substring(0, n6) + fold.title.substring(n7);
                }
            }
            --n5;
        }
        this.teim.clearSelection();
        this.lineRenderAll();
        this.setCursor(n2, n);
        return true;
    }

    void lineRenderAll() {
        this.calcLineNr(this.tf.fold, 0);
        this.tf.renderAll();
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (this.teim.lines.size() == 0) {
            return;
        }
        switch (n) {
            case 39: {
                this.naviKey(this.xC + 1, this.yC, keyEvent);
                break;
            }
            case 37: {
                this.naviKey(this.xC - 1, this.yC, keyEvent);
                break;
            }
            case 40: {
                this.naviKey(this.xC, this.yC + 1, keyEvent);
                break;
            }
            case 38: {
                this.naviKey(this.xC, this.yC - 1, keyEvent);
                break;
            }
            case 33: {
                this.naviKey(this.xC, this.yC - 15, keyEvent);
                break;
            }
            case 34: {
                this.naviKey(this.xC, this.yC + 15, keyEvent);
                break;
            }
            case 36: {
                this.naviKey(0, this.yC, keyEvent);
                break;
            }
            case 35: {
                this.naviKey(this.getFold((int)this.yC, (boolean)true).title.length(), this.yC, keyEvent);
                break;
            }
            case 107: {
                this.checkClearSelection(keyEvent);
                if (!keyEvent.isControlDown()) break;
                Fold fold = this.getFold(this.yC, true);
                if (!(fold.fV != null & !fold.open)) break;
                this.tf.toggleFolder(fold);
                if (this.closeStack.size() <= 0) break;
                Point point = (Point)this.closeStack.pop();
                this.setCursor(point.x, point.y);
                break;
            }
            case 109: {
                this.checkClearSelection(keyEvent);
                if (!keyEvent.isControlDown()) break;
                Fold fold = this.getFold(this.yC, true);
                if (fold.fV == null | !fold.open) {
                    fold = fold.parent;
                }
                if (!(fold.open & fold != this.tf.fold)) break;
                this.closeStack.push(new Point(this.xC, this.yC));
                this.tf.toggleFolder(fold);
                break;
            }
            case 27: {
                this.checkClearSelection(keyEvent);
                if (this.escRunner == null) break;
                this.escRunner.run();
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 10: {
                this.checkRemoveSelection();
                Fold fold = this.getFold(this.yC, false);
                if (fold == null) break;
                this.setChange(true);
                if (keyEvent.isControlDown()) {
                    if (fold.fV != null) break;
                    fold.add(new Fold(""));
                    fold.open = true;
                    this.lineRenderAll();
                    this.setCursor(0, this.yC + 1);
                    break;
                }
                if (fold.open) {
                    Fold fold2 = new Fold("");
                    fold.fV.insertElementAt(fold2, 0);
                    fold2.parent = fold;
                    this.lineRenderAll();
                    this.setCursor(0, this.yC + 1);
                    break;
                }
                boolean bl = fold.fV == null;
                Fold fold3 = fold.parent;
                int n2 = IO.countSpace(fold.title);
                Fold fold4 = new Fold(IO.space(n2) + (bl ? fold.title.substring(this.xC) : ""));
                if (bl) {
                    fold.title = fold.title.substring(0, this.xC);
                }
                fold3.fV.insertElementAt(fold4, fold3.fV.indexOf(fold) + 1);
                fold4.parent = fold3;
                this.lineRenderAll();
                this.setCursor(n2, this.yC + 1);
                break;
            }
            case 127: {
                Fold fold;
                if (this.checkRemoveSelection() || (fold = this.getFold(this.yC, false)) == null) break;
                this.setChange(true);
                if (keyEvent.isControlDown()) {
                    if (fold.fV == null) break;
                    fold.fV = null;
                    fold.open = false;
                    this.lineRenderAll();
                    break;
                }
                if (this.xC < fold.title.length()) {
                    fold.title = fold.title.substring(0, this.xC) + fold.title.substring(this.xC + 1);
                    this.tf.renderAll();
                    break;
                }
                if (fold.fV != null) break;
                Fold fold5 = fold.parent;
                int n3 = fold5.fV.indexOf(fold);
                if (n3 == fold5.fV.size() - 1) break;
                Fold fold6 = fold5.at(n3 + 1);
                if (fold6.fV != null) break;
                fold.title = fold.title + fold6.title;
                fold5.fV.removeElementAt(n3 + 1);
                this.lineRenderAll();
                break;
            }
            case 8: {
                Fold fold;
                if (this.checkRemoveSelection() || (fold = this.getFold(this.yC, false)) == null) break;
                this.setChange(true);
                if (keyEvent.isControlDown()) {
                    if (fold.fV == null) break;
                    fold.fV = null;
                    fold.open = false;
                    this.lineRenderAll();
                    break;
                }
                if (this.xC > 0) {
                    fold.title = fold.title.substring(0, this.xC - 1) + fold.title.substring(this.xC);
                    this.tf.renderAll();
                    this.setCursor(this.xC - 1, this.yC);
                    break;
                }
                if (fold.fV != null) break;
                Fold fold7 = fold.parent;
                int n4 = fold7.fV.indexOf(fold);
                if (n4 == 0) break;
                Fold fold8 = fold7.at(n4 - 1);
                int n5 = fold8.title.length();
                fold8.title = fold8.title + fold.title;
                fold7.fV.removeElementAt(n4);
                this.lineRenderAll();
                this.setCursor(n5, this.yC - 1);
                break;
            }
            case 155: {
                if (keyEvent.isShiftDown()) {
                    this.paste();
                    break;
                }
                if (!keyEvent.isControlDown()) break;
                this.copy();
                break;
            }
            default: {
                int n6;
                if (keyEvent.isAltDown() ^ keyEvent.isControlDown() || keyEvent.getKeyChar() == '\u0000' || keyEvent.getKeyChar() > '\uea60') break;
                this.checkRemoveSelection();
                Fold fold = this.getFold(this.yC, false);
                if (fold == null) break;
                this.setChange(true);
                String string = (String)this.tf.properties.get("editing.wrapWidth");
                int n7 = n6 = string == null ? -1 : Integer.parseInt(string);
                if (n6 > -1 && this.cX > fold.calcDepth() * this.tf.env.xDepth + n6 && fold.fV == null) {
                    int n8 = IO.countSpace(fold.title);
                    int n9 = fold.title.substring(0, this.xC).lastIndexOf(" ");
                    if (n9 == -1) {
                        n9 = this.xC;
                    }
                    Fold fold9 = fold.parent;
                    Fold fold10 = new Fold(IO.space(n8) + (n9 < this.xC ? fold.title.substring(n9 + 1, this.xC) : "") + keyEvent.getKeyChar() + fold.title.substring(this.xC));
                    fold.title = fold.title.substring(0, n9);
                    fold9.fV.insertElementAt(fold10, fold9.fV.indexOf(fold) + 1);
                    fold10.parent = fold9;
                    this.lineRenderAll();
                    this.setCursor(n8 + 1 + this.xC - n9, this.yC + 1);
                    break;
                }
                fold.title = fold.title.substring(0, this.xC) + keyEvent.getKeyChar() + fold.title.substring(this.xC);
                this.tf.renderAll();
                this.setCursor(this.xC + 1, this.yC);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        if (this.isCursor) {
            this.drawCursor();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.hasFocus = true;
    }

    void selectPos(int n, int n2, int n3) {
        this.setCursor(this.tf.env.getFoldPos(this.teim, n, n2, n3), n);
    }

    public void setCursor(int n, int n2) {
        Fold fold;
        if (n != this.xC) {
            this.xCh = n;
        } else {
            n = this.xCh;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 >= this.teim.lines.size()) {
            n2 = this.teim.lines.size() - 1;
        }
        if ((fold = (Fold)this.teim.getLine((int)n2).o) == null) {
            n = 0;
        } else if (n > fold.title.length()) {
            n = fold.title.length();
        }
        this.xC = n;
        this.yC = n2;
        this.statusText();
        this.calcCursor(true);
        this.teim.repaint();
    }

    void setChange(boolean bl) {
        if (bl == this.wasChange) {
            return;
        }
        this.wasChange = bl;
        this.statusText();
        this.teim.repaint();
    }

    String calcFoldPath(Fold fold) {
        String string = "";
        fold = fold.parent;
        while (fold.parent != null) {
            String string2 = fold.title;
            if (string2.length() > 40) {
                string2 = ".." + string2.substring(string2.length() - 39, string2.length());
            }
            string = string2 + (string.length() > 0 ? " > " + string : "");
            fold = fold.parent;
        }
        return string;
    }

    void statusText() {
        Object object;
        this.teim.brV.setSize(0);
        Font font = this.teim.getFon("Sansserif", 0, 12);
        int n = 0;
        if (this.wasChange) {
            object = new Text(" *", font, this.teim.getCol(240, 240, 0), this.teim, 3, 3);
            this.br3DText((Text)object, font);
            n += ((Text)object).w;
        }
        if ((object = this.getFold(this.yC, false)) != null) {
            this.foldPath = this.calcFoldPath((Fold)object);
        }
        this.br3DText(new Text(this.xC + "" + (object == null ? "" : "," + ((Fold)object).lineNr), font, this.teim.getCol(170, 170, 170), this.teim, 3 + n, 3), font);
        if (this.statusRunnable != null) {
            this.statusRunnable.run();
        }
    }

    void br3DText(Text text, Font font) {
        Color color = this.teim.getCol(250, 250, 250);
        Color color2 = this.teim.getCol(0, 0, 0);
        this.teim.brV.addElement(new Text(text.text, font, color, this.teim, text.x + 1, text.y + 1));
        this.teim.brV.addElement(new Text(text.text, font, color, this.teim, text.x + 1, text.y));
        this.teim.brV.addElement(new Text(text.text, font, color, this.teim, text.x, text.y + 1));
        this.teim.brV.addElement(new Text(text.text, font, color2, this.teim, text.x - 1, text.y - 1));
        this.teim.brV.addElement(new Text(text.text, font, color2, this.teim, text.x - 1, text.y));
        this.teim.brV.addElement(new Text(text.text, font, color2, this.teim, text.x, text.y - 1));
        this.teim.brV.addElement(text);
    }

    public Fold getFold(int n, boolean bl) {
        Fold fold = (Fold)this.teim.getLine((int)n).o;
        if (bl && fold == null) {
            fold = (Fold)this.teim.getLine((int)(n - 1)).o;
        }
        return fold;
    }

    void calcCursor(boolean bl) {
        this.tf.env.getTiPos(this.teim, this.xC, this.yC);
        Line line = this.teim.getLine(this.yC);
        Text text = (Text)line.objects.elementAt(this.tf.env.gotTi);
        this.cX = text.fm.stringWidth(text.text.substring(0, this.tf.env.gotPos)) + text.x;
        this.cY = line.y + text.y;
        this.cH = text.h;
        this.cW = Math.max(2, this.cH / 5);
        if (bl && !this.teim.ensureVisibleLine(this.cX, this.cY, this.cH)) {
            this.drawCursor();
        }
    }

    boolean ensureVisibleLine(int n, int n2) {
        Dimension dimension = this.teim.getSize();
        if (n + this.teim.gY + n2 > dimension.height) {
            this.teim.gY = dimension.height - n - n2 - dimension.height / 4;
            this.teim.repaint();
            this.esp.setScroller();
        } else if (n + this.teim.gY < 0) {
            this.teim.gY = Math.min(0, -n + dimension.height / 4);
            this.teim.repaint();
            this.esp.setScroller();
        } else {
            return false;
        }
        return true;
    }

    synchronized void drawCursor() {
        Graphics graphics = this.teim.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setColor(Color.black);
        graphics.setXORMode(Color.white);
        graphics.fillRect(this.cX + this.teim.gX, this.cY + this.teim.gY, this.cW, this.cH);
        graphics.dispose();
        this.isCursor = !this.isCursor;
    }

    public void start() {
        this.isRunning = true;
        new Thread(this).start();
        this.teim.requestFocus();
        this.teim.beforePaintRunner = new Runnable(){

            public void run() {
                if (TfEdit.this.isCursor) {
                    TfEdit.this.drawCursor();
                }
            }
        };
        this.teim.cursorOnRunner = new Runnable(){

            public void run() {
                TfEdit.this.drawCursor();
            }
        };
        this.teim.addKeyListener(this);
        this.teim.doDefCopy = false;
        this.teim.addFocusListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.isRunning = false;
        if (this.isCursor) {
            this.drawCursor();
        }
        this.teim.removeKeyListener(this);
        this.teim.beforePaintRunner = null;
        this.teim.doDefCopy = true;
        this.teim.removeFocusListener(this);
        try {
            TfEdit tfEdit = this;
            synchronized (tfEdit) {
                this.wait();
            }
        }
        catch (Exception exception) {
            System.err.println("TfEdit.stop:" + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.isRunning) {
            if (this.hasFocus) {
                this.drawCursor();
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        TfEdit tfEdit = this;
        synchronized (tfEdit) {
            this.notify();
        }
    }

    void folderClosed(Fold fold) {
        boolean bl = false;
        boolean bl2 = false;
        while ((fold = fold.parent) != null) {
            if (fold.open) continue;
            this.setCursor(this.xC, this.tf.getLineNr(fold));
            bl = true;
            break;
        }
        if (!bl) {
            this.calcCursor(true);
        }
    }
}

