/*
 * Decompiled with CFR 0.152.
 */
package auto.awt.teimfold;

import auto.awt.fold.Fold;
import auto.awt.fold.IO;
import auto.awt.teimfold.TfEdit;
import auto.awt.teimfold.TfEnv;
import auto.awt.teimfold.TfFormat;
import auto.tools.foldor.Foldor;
import auto.util.io.TextUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackInputStream;

public final class TfTexEnv
extends TfEnv {
    String[][] loadConvert;
    String[][] saveConvert;
    boolean withChapters = false;

    public TfTexEnv() {
        this.openS = "";
        this.openCloseS = " ...";
        this.closeS = " ";
        this.defFormat = new TfFormat("Sansserif", 0, 12, 0, 0, 0);
        this.commentLineFmt = new TfFormat("Sansserif", 0, 12, 150, 150, 150);
        this.commentLineFmt.key = "%";
        String string = "";
        TfFormat tfFormat = new TfFormat("Sansserif", 1, 12, 200, 0, 0);
        tfFormat.typ = 3;
        tfFormat.key = "$";
        this.stringFmts.addElement(tfFormat);
        tfFormat = new TfFormat("Sansserif", 1, 12, 0, 0, 0);
        tfFormat.typ = 0;
        tfFormat.keys = new String[]{"\\textbf", "\\textit", "\\cite", "\\begin", "\\end", "\\[", "\\]"};
        this.keyFormats.addElement(tfFormat);
        this.emptyLineFmt = new TfFormat("Sansserif", 0, 12, 0, 0, 0, 8);
        this.loadConvert = new String[][]{{"\"u", "\u00fc"}, {"\"o", "\u00f6"}, {"\"a", "\u00e4"}, {"\"U", "\u00dc"}, {"\"O", "\u00d6"}, {"\"A", "\u00c4"}, {"\"s", "\u00df"}};
        this.saveConvert = new String[][]{{"\u00fc", "\"u"}, {"\u00f6", "\"o"}, {"\u00e4", "\"a"}, {"\u00dc", "\"U"}, {"\u00d6", "\"O"}, {"\u00c4", "\"A"}, {"\u00df", "\"s"}};
        this.yBorder = 7;
        this.lineComment = "%";
    }

    static String convert(String string, String[][] stringArray) {
        int n = stringArray.length - 1;
        while (n >= 0) {
            int n2;
            String string2 = stringArray[n][0];
            String string3 = stringArray[n][1];
            while ((n2 = string.indexOf(string2)) != -1) {
                string = string.substring(0, n2) + string3 + string.substring(n2 + string2.length());
            }
            --n;
        }
        return string;
    }

    public Fold loadTex(int n, String string, PushbackInputStream pushbackInputStream) throws IOException {
        Fold fold = new Fold(TfTexEnv.convert(string, this.loadConvert));
        TextUtils.jumpWhiteToEol(pushbackInputStream);
        StringBuffer stringBuffer = new StringBuffer("");
        while (true) {
            String string2;
            int n2;
            char c;
            if ((c = (char)(n2 = pushbackInputStream.read())) == '\n') {
                fold.add(new Fold(TfTexEnv.convert(stringBuffer.toString(), this.loadConvert)));
                stringBuffer.setLength(0);
            } else if (c == '$') {
                stringBuffer.append(c + IO.stringToChar(pushbackInputStream, '$', true));
            } else if (c == '%') {
                stringBuffer.append("%" + IO.stringToChar(pushbackInputStream, '\n', false));
            } else {
                if (n2 == -1) {
                    if (stringBuffer.length() <= 0) break;
                    fold.add(new Fold(TfTexEnv.convert(stringBuffer.toString(), this.loadConvert)));
                    break;
                }
                stringBuffer.append(c);
            }
            if (stringBuffer.toString().endsWith("\\end{document}") && n > 0) {
                pushbackInputStream.unread(stringBuffer.toString().getBytes());
                return fold;
            }
            if (stringBuffer.toString().endsWith("\\begin{slide}{")) {
                string2 = TextUtils.readRecToChar(pushbackInputStream, '}', '{');
                string2 = "\\begin{slide}{" + string2 + "}";
                if (n > 0) {
                    pushbackInputStream.unread(string2.getBytes());
                    return fold;
                }
                fold.add(this.loadTex(n + 1, string2, pushbackInputStream));
                stringBuffer.setLength(0);
            }
            if (stringBuffer.toString().endsWith("\\chapter{")) {
                string2 = TextUtils.readRecToChar(pushbackInputStream, '}', '{');
                string2 = "\\chapter{" + string2 + "}";
                this.withChapters = true;
                if (n > 0) {
                    pushbackInputStream.unread(string2.getBytes());
                    return fold;
                }
                fold.add(this.loadTex(n + 1, string2, pushbackInputStream));
                stringBuffer.setLength(0);
            }
            if (stringBuffer.toString().endsWith("\\section{")) {
                string2 = TextUtils.readRecToChar(pushbackInputStream, '}', '{');
                string2 = "\\section{" + string2 + "}";
                if (n > 0 + (this.withChapters ? 1 : 0)) {
                    pushbackInputStream.unread(string2.getBytes());
                    return fold;
                }
                fold.add(this.loadTex(n + 1, string2, pushbackInputStream));
                stringBuffer.setLength(0);
            }
            if (stringBuffer.toString().endsWith("\\subsection{")) {
                string2 = TextUtils.readRecToChar(pushbackInputStream, '}', '{');
                string2 = "\\subsection{" + string2 + "}";
                if (n > 1 + (this.withChapters ? 1 : 0)) {
                    pushbackInputStream.unread(string2.getBytes());
                    return fold;
                }
                fold.add(this.loadTex(n + 1, string2, pushbackInputStream));
                stringBuffer.setLength(0);
            }
            if (!stringBuffer.toString().endsWith("\\subsubsection{")) continue;
            string2 = TextUtils.readRecToChar(pushbackInputStream, '}', '{');
            string2 = "\\subsubsection{" + string2 + "}";
            if (n > 2 + (this.withChapters ? 1 : 0)) {
                pushbackInputStream.unread(string2.getBytes());
                return fold;
            }
            fold.add(this.loadTex(n + 1, string2, pushbackInputStream));
            stringBuffer.setLength(0);
        }
        return fold;
    }

    public void saveFold(Fold fold, PrintWriter printWriter, int n) throws IOException {
        printWriter.println(TfTexEnv.convert(fold.title, this.saveConvert));
        if (fold.fV != null) {
            int n2 = 0;
            while (n2 < fold.fV.size()) {
                this.saveFold(fold.at(n2), printWriter, n);
                ++n2;
            }
        }
    }

    public void sa___ve(Fold fold, PrintWriter printWriter, String string, TfEdit tfEdit) throws IOException {
    }

    public String[] compileCmd(String string) {
        string = string.replace('\\', '/');
        int n = string.lastIndexOf(47);
        String string2 = Foldor.instance.getProperty("texEnv.compileCmd", "Compile Command for (La)TeX", "texify");
        if (string2 == null) {
            return null;
        }
        return new String[]{string2 + " " + string.substring(n + 1), string.substring(0, n)};
    }

    public String[] runCmd(String string) {
        string = string.replace('\\', '/');
        int n = string.lastIndexOf(47);
        String string2 = string.substring(0, n);
        string = string.substring(n + 1);
        n = string.indexOf(".");
        string = string.substring(0, n) + ".dvi";
        String string3 = Foldor.instance.getProperty("texEnv.runCmd", "View Command for (La)TeX (DVI)", "yap");
        if (string3 == null) {
            return null;
        }
        return new String[]{string3 + " " + string, string2};
    }

    public Fold load(String string, PushbackInputStream pushbackInputStream) throws IOException {
        this.withChapters = false;
        return this.loadTex(0, "root", pushbackInputStream);
    }

    public void save(OutputStream outputStream) {
    }
}

