/*
 * Decompiled with CFR 0.152.
 */
package auto.image;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TgaConverter {
    public static void save(Image image, String string) {
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        int[] nArray = new int[dimension.width * dimension.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, dimension.width, dimension.height, nArray, 0, dimension.width);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        TgaConverter.save(nArray, dimension.width, dimension.height, string);
    }

    public static void save(int[] nArray, int n, int n2, OutputStream outputStream) throws IOException {
        int n3;
        boolean bl = false;
        int n4 = nArray.length - 1;
        while (n4 >= 0) {
            n3 = nArray[n4];
            if ((n3 >> 24 & 0xFF) != 255) {
                bl = true;
            }
            --n4;
        }
        outputStream.write(0);
        outputStream.write(0);
        outputStream.write(2);
        int n5 = 0;
        while (n5 < 9) {
            outputStream.write(0);
            ++n5;
        }
        TgaConverter.write2(outputStream, n);
        TgaConverter.write2(outputStream, n2);
        outputStream.write(bl ? 32 : 24);
        outputStream.write(0);
        int n6 = 0;
        while (n6 < n2) {
            int n7 = 0;
            while (n7 < n) {
                n3 = nArray[(n2 - n6 - 1) * n + n7];
                outputStream.write(n3 & 0xFF);
                outputStream.write(n3 >> 8 & 0xFF);
                outputStream.write(n3 >> 16 & 0xFF);
                if (bl) {
                    outputStream.write(n3 >> 24 & 0xFF);
                }
                ++n7;
            }
            ++n6;
        }
    }

    public static void save(int[] nArray, int n, int n2, String string) {
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            TgaConverter.save(nArray, n, n2, bufferedOutputStream);
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Image load(String string) {
        Image image = null;
        try {
            image = TgaConverter.load(new FileInputStream(string));
        }
        catch (Exception exception) {
            return null;
        }
        return image;
    }

    public static Image loadResource(String string) {
        Image image = null;
        System.out.println("tgaconverter.loadresource:" + string);
        try {
            image = TgaConverter.load(string.getClass().getResourceAsStream(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    private static void write2(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
    }

    private static int read2(InputStream inputStream) throws Exception {
        int n = inputStream.read();
        int n2 = inputStream.read();
        return n2 << 8 | n;
    }

    public static Image load(InputStream inputStream) throws Exception {
        return TgaConverter.load(inputStream, new Frame());
    }

    public static Image load(InputStream inputStream, Component component) throws Exception {
        inputStream = new BufferedInputStream(inputStream);
        inputStream.read();
        inputStream.read();
        if (inputStream.read() != 2) {
            throw new Exception("TgaConverter: can only read type-2 tga");
        }
        int n = 0;
        while (n < 9) {
            inputStream.read();
            ++n;
        }
        Dimension dimension = new Dimension(TgaConverter.read2(inputStream), TgaConverter.read2(inputStream));
        int[] nArray = new int[dimension.width * dimension.height];
        int n2 = inputStream.read();
        if (n2 != 24 & n2 != 32) {
            throw new Exception("TgaConverter: cant read " + n2 + "-Bit pics !");
        }
        inputStream.read();
        if (n2 == 24) {
            int n3 = 0;
            while (n3 < dimension.height) {
                int n4 = 0;
                while (n4 < dimension.width) {
                    nArray[(dimension.height - n3 - 1) * dimension.width + n4] = 0xFF000000 | inputStream.read() << 0 | inputStream.read() << 8 | inputStream.read() << 16;
                    ++n4;
                }
                ++n3;
            }
        } else {
            int n5 = 0;
            while (n5 < dimension.height) {
                int n6 = 0;
                while (n6 < dimension.width) {
                    nArray[(dimension.height - n5 - 1) * dimension.width + n6] = inputStream.read() << 0 | inputStream.read() << 8 | inputStream.read() << 16 | inputStream.read() << 24;
                    ++n6;
                }
                ++n5;
            }
        }
        inputStream.close();
        return component.createImage(new MemoryImageSource(dimension.width, dimension.height, nArray, 0, dimension.width));
    }
}

