/*
 * Decompiled with CFR 0.152.
 */
package auto.net.chat;

import auto.net.chat.ClientAble;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public class Client
implements Runnable {
    String host = null;
    int port = 7000;
    Socket socket;
    DataInputStream in;
    DataOutputStream out;
    Exception ex = null;
    ClientAble clientAble;
    public boolean connected = false;

    public Client(String string, int n, ClientAble clientAble) {
        this.host = string;
        this.port = n;
        this.clientAble = clientAble;
    }

    protected boolean connect() {
        boolean bl = true;
        try {
            this.socket = new Socket(this.host, this.port);
            this.in = new DataInputStream(this.socket.getInputStream());
            this.out = new DataOutputStream(this.socket.getOutputStream());
            this.connected = true;
        }
        catch (Exception exception) {
            this.ex = exception;
            System.err.println(exception);
            bl = false;
        }
        this.clientAble.clientConnected(bl);
        return bl;
    }

    public void run() {
        if (!this.connect()) {
            return;
        }
        new Thread(){

            public void run() {
                while (Client.this.connected) {
                    Client.this.put("&");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }.start();
        try {
            while (this.connected) {
                String string = this.in.readUTF();
                this.clientAble.clientTreat(string);
            }
        }
        catch (IOException iOException) {
            if (!this.connected) {
                return;
            }
            this.ex = iOException;
            this.destroy();
            this.clientAble.clientNetError();
            System.err.println("could not read from the net: " + this.ex);
        }
    }

    public synchronized boolean put(String string) {
        if (this.ex != null || !this.connected) {
            return false;
        }
        try {
            this.out.writeUTF(string);
        }
        catch (IOException iOException) {
            this.ex = iOException;
            System.err.println("could not write to the net: " + this.ex);
            this.destroy();
            return false;
        }
        return true;
    }

    public void disConnect() {
        this.connected = false;
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            this.ex = exception;
        }
    }

    public void destroy() {
        this.put("leave");
        String string = "Sorry, the applet has been destroyed. " + (this.ex == null ? "Load the page again." : this.ex.toString());
        this.disConnect();
    }

    public static void main(String[] stringArray) {
        ClientAble clientAble = new ClientAble(){

            public void clientConnected(boolean bl) {
                System.out.println("connected:" + bl);
            }

            public void clientNetError() {
                System.out.println("net error.");
            }

            public void clientTreat(String string) {
                System.out.println(string);
            }
        };
        final Client client = new Client("localhost", 7000, clientAble);
        new Thread(client).start();
        new Thread(){

            public void run() {
                DataInputStream dataInputStream = new DataInputStream(System.in);
                String string = null;
                while (true) {
                    try {
                        string = dataInputStream.readLine();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    client.put(string);
                }
            }
        }.start();
    }
}

