/*
 * Decompiled with CFR 0.152.
 */
package auto.tools.foldor;

import auto.awt.ImagePool;
import auto.tools.foldor.But;
import auto.util.awt.MainFrame;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.Vector;

public final class DiaShow
extends Canvas
implements Runnable,
MouseListener,
MouseMotionListener,
WindowListener {
    ImagePool imgPool;
    int w = 400;
    int h = 400;
    Vector fnV = new Vector();
    Vector fnoV = new Vector();
    Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    Image img = null;
    int index = -1;
    boolean isIcon = false;
    boolean mouseIn = false;
    But nextB = new But(10, 10, 40, 20, "Next");
    But pauseB = new But(55, 10, 40, 20, "Pause");
    But removeB = new But(100, 10, 50, 20, "Remove");
    But hideB = new But(10, 35, 50, 20, "Hide");
    But[] buts = new But[]{this.nextB, this.pauseB, this.removeB, this.hideB};
    boolean pause = false;
    boolean skipRun = false;
    Window win = new Window(new Frame());

    public DiaShow(String string, ImagePool imagePool, Frame frame) {
        this.win.setLayout(null);
        this.win.add((Component)this, "Center");
        if (frame != null) {
            frame.addWindowListener(this);
        }
        this.setBackground(Color.gray);
        this.setFont(new Font("Dialog", 0, 10));
        this.win.setBounds(this.screen.width - 1, 0, 1, 1);
        this.setBounds(0, 0, 1, 1);
        this.win.show();
        this.win.toBack();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.imgPool = imagePool;
        if (this.imgPool == null) {
            this.imgPool = new ImagePool(this);
        }
        this.loadFns(string);
        int n = 0;
        while (n < 10) {
            this.newFn();
            ++n;
        }
        new Thread(this).start();
    }

    void loadFns(String string) {
        File file = new File(string);
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            String string2 = string + "/" + stringArray[n];
            File file2 = new File(string2);
            if (file2.isDirectory()) {
                this.loadFns(string2);
            } else if (string2.toLowerCase().endsWith(".jpg")) {
                this.fnoV.addElement(string2);
            }
            ++n;
        }
    }

    void newFn() {
        if (this.fnoV.size() == 0) {
            return;
        }
        int n = (int)((double)this.fnoV.size() * Math.random());
        this.fnV.addElement(this.fnoV.elementAt(n));
        this.fnoV.removeElementAt(n);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.removeB.over) {
            this.skipRun = true;
            Image image = this.img;
            this.img = null;
            String string = (String)this.fnV.elementAt(this.index);
            this.fnV.removeElementAt(this.index);
            this.imgPool.flushScaledImage(string, this.w, this.h);
            this.newFn();
            this.nextPic();
        }
        if (this.nextB.over) {
            this.skipRun = true;
            this.nextPic();
        }
        if (this.hideB.over) {
            this.skipRun = true;
            this.win.setVisible(false);
        }
        if (this.pauseB.over) {
            this.pause = !this.pause;
            this.pauseB.s = this.pause ? "Run" : "Pause";
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.buts.length - 1;
        while (n >= 0) {
            But but = this.buts[n];
            boolean bl = but.r.contains(point.x, point.y);
            if (bl ^ but.over) {
                but.over = bl;
                this.repaint();
            }
            --n;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseIn = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseIn = false;
        this.repaint();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.isIcon = true;
        this.setVis(false);
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        this.isIcon = false;
        this.setVis(true);
    }

    public void run() {
        while (true) {
            if (!this.pause & !this.skipRun) {
                this.nextPic();
            }
            this.skipRun = false;
            try {
                Thread.sleep(20000L);
            }
            catch (Exception exception) {
            }
        }
    }

    void setVis(boolean bl) {
        this.win.setVisible(bl);
        if (bl) {
            this.win.toBack();
        }
    }

    boolean nextPic() {
        this.index = (int)((double)this.fnV.size() * Math.random());
        String string = (String)this.fnV.elementAt(this.index);
        this.img = this.imgPool.getScaledImg(string, this, this.w, this.h);
        if (this.img == null) {
            System.err.println("DiaShow.run: couldnt load " + string);
            this.fnV.removeElementAt(this.index);
            this.newFn();
            return false;
        }
        if (!this.isIcon && !this.win.isVisible()) {
            this.setVis(true);
        }
        int n = this.img.getWidth(this);
        int n2 = this.img.getHeight(this);
        this.win.setBounds(this.screen.width - n, 0, n, n2);
        this.setBounds(0, 0, n, n2);
        this.repaint();
        return true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this.img != null) {
            graphics.drawImage(this.img, 0, 0, this);
        }
        if (!this.mouseIn) {
            return;
        }
        Dimension dimension = this.getSize();
        int n = this.buts.length - 1;
        while (n >= 0) {
            this.buts[n].draw(graphics);
            --n;
        }
    }

    void drawBut(Graphics graphics, int n, int n2, int n3, int n4, String string, Color color) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.setColor(Color.black);
        graphics.drawRect(n, n2, n3, n4);
        graphics.drawRect(n + 2, n2 + 2, n3 - 4, n4 - 4);
        int n5 = fontMetrics.getAscent() - 2;
        graphics.drawString(string, n + 3, n2 + n5 + 3);
        graphics.drawString(string, n + 3, n2 + n5 + 4);
        graphics.drawString(string, n + 4, n2 + n5 + 3);
        graphics.drawString(string, n + 5, n2 + n5 + 5);
        graphics.drawString(string, n + 4, n2 + n5 + 5);
        graphics.drawString(string, n + 5, n2 + n5 + 4);
        graphics.setColor(color);
        graphics.drawRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        graphics.drawString(string, n + 4, n2 + n5 + 4);
    }

    public static void main(String[] stringArray) {
        Frame frame = MainFrame.mainFrame((String)"DiaShow", (Component)new Label("Close window to close show."), (int)50, (int)50, (int)200, (int)55);
        DiaShow diaShow = new DiaShow("d:/grafik/ref", null, frame);
        diaShow.w = 1000;
        diaShow.h = 700;
    }
}

